%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalpulsar
Version: 1.10.4
Release: 1
Summary: LSC Algorithm Pulsar Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.gz
URL: https://www.lsc-group.phys.uwm.edu/daswg/projects/lalsuite.html
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: python-devel octave-devel
Requires: gsl lal lalxml
Prefix: %{_prefix}

%description
The LSC Algorithm Pulsar Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Pulsar library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Pulsar
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel lal-devel lalxml-devel
%description devel
The LSC Algorithm Pulsar Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL
Pulsar library.

%package python
Summary: Python bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: python numpy lal-python lalxml-python
%description python
This package provides the Python bindings for LALPulsar.

%package octave
Summary: Octave bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: octave lal-octave lalxml-octave
%description octave
This package provides the Octave bindings for LALPulsar.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig
%{__make} V=1

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*
%{_prefix}/share/lalpulsar/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalpulsar/*.py
%{_libdir}/python*/site-packages/lalpulsar/*.pyc
%{_libdir}/python*/site-packages/lalpulsar/_lalpulsar.so*
%exclude %{_libdir}/python*/site-packages/lalpulsar/*.pyo

%files octave
%defattr(-,root,root)
%{_libexecdir}/octave/*/site/oct/*/lalpulsar.oct*
