/*
 * LALMetaIOVCSInfo.h - LALMetaIO VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALMETAIOVCSINFOHEADER_H
#define _LALMETAIOVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALMetaIOVCSInfo.h>
#include <lal/LALMetaIOConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information defines */
#define LALMETAIO_NAME "LALMetaIO"
#define LALMETAIO_VCS_ID "dc43b4813f7ba2c228ce5f2e6b4f99dfddb873e4"
#define LALMETAIO_VCS_DATE "2016-06-26 20:41:32 +0000"
#define LALMETAIO_VCS_BRANCH "None"
#define LALMETAIO_VCS_TAG "lalmetaio-v1.2.8"
#define LALMETAIO_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALMETAIO_VCS_COMMITTER "Adam Mercer <ramercer@gmail.com>"
#define LALMETAIO_VCS_STATUS "CLEAN: All modifications committed"

/* Identable VCS information defines */
#define LALMETAIO_VCS_IDENT_ID "$" "LALMetaIOId: dc43b4813f7ba2c228ce5f2e6b4f99dfddb873e4 " "$"
#define LALMETAIO_VCS_IDENT_DATE "$" "LALMetaIODate: 2016-06-26 20:41:32 +0000 " "$"
#define LALMETAIO_VCS_IDENT_BRANCH "$" "LALMetaIOBranch: None " "$"
#define LALMETAIO_VCS_IDENT_TAG "$" "LALMetaIOTag: lalmetaio-v1.2.8 " "$"
#define LALMETAIO_VCS_IDENT_AUTHOR "$" "LALMetaIOAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALMETAIO_VCS_IDENT_COMMITTER "$" "LALMetaIOCommitter: Adam Mercer <ramercer@gmail.com> " "$"
#define LALMETAIO_VCS_IDENT_STATUS "$" "LALMetaIOStatus: CLEAN: All modifications committed " "$"

/* Header VCS information structure */
static const LALVCSInfo lalMetaIOVCSInfoHeader = { \
  LALMETAIO_NAME, \
  LALMETAIO_VERSION, \
  LALMETAIO_VCS_ID, \
  LALMETAIO_VCS_DATE, \
  LALMETAIO_VCS_BRANCH, \
  LALMETAIO_VCS_TAG, \
  LALMETAIO_VCS_AUTHOR, \
  LALMETAIO_VCS_COMMITTER, \
  LALMETAIO_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALMETAIOVCSINFOHEADER_H */

/** \endcond */

/*
 * vim: tw=0 ts=2 et
 */
