/*
 * Copyright (C) 2014, 2016 Karl Wette
 * Copyright (C) 2009-2013 Adam Mercer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

#ifndef _LALAPPSVCSINFO_H
#define _LALAPPSVCSINFO_H

#include <lal/LALVCSInfoType.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \defgroup LALAppsVCSInfo_h Header LALAppsVCSInfo.h
 * \ingroup lalapps_general
 * \brief VCS and build information for LALApps
 */
/*@{*/

/** VCS and build information for LALApps */
extern const LALVCSInfo lalAppsVCSInfo;

/** Identable VCS and build information for LALApps */
extern const LALVCSInfo lalAppsVCSIdentInfo;

/** <tt>NULL</tt>-terminated list of VCS and build information for LALApps and its dependencies */
extern const LALVCSInfoList lalAppsVCSInfoList;

/*@}*/

#ifdef __cplusplus
}
#endif

#endif /* _LALAPPSVCSINFO_H */
