/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirErrorContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.diagnostics.ConeContractShouldBeFirstStatement;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0011\u001a\u00020\u000e*\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirContractNotFirstStatementChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isCorrectlyPlacedIn", "", "functionDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isNonFirstStatement", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "(Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;)Z", "checkers"})
public final class FirContractNotFirstStatementChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirContractNotFirstStatementChecker INSTANCE = new FirContractNotFirstStatementChecker();

    private FirContractNotFirstStatementChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
        if (!Intrinsics.areEqual(StandardClassIds.Callables.INSTANCE.getContract(), firCallableSymbol != null ? firCallableSymbol.getCallableId() : null)) {
            return;
        }
        FirDeclaration containingDeclaration = CollectionsKt.last(context.getContainingDeclarations());
        if (!(containingDeclaration instanceof FirFunction) || !this.isCorrectlyPlacedIn(expression2, (FirFunction)containingDeclaration)) {
            String message = containingDeclaration instanceof FirFunction && ((FirFunction)containingDeclaration).getBody() instanceof FirSingleExpressionBlock ? "Contracts are only allowed in function body blocks." : "Contract should be the first statement.";
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final boolean isCorrectlyPlacedIn(FirFunctionCall $this$isCorrectlyPlacedIn, FirFunction functionDeclaration) {
        Object object = functionDeclaration.getBody();
        FirStatement firstStatement = object != null && (object = ((FirBlock)object).getStatements()) != null ? (FirStatement)CollectionsKt.first(object) : null;
        return firstStatement instanceof FirContractCallBlock && Intrinsics.areEqual(((FirContractCallBlock)firstStatement).getCall(), $this$isCorrectlyPlacedIn) && (!(functionDeclaration instanceof FirContractDescriptionOwner) || !this.isNonFirstStatement(((FirContractDescriptionOwner)((Object)functionDeclaration)).getContractDescription()));
    }

    private final boolean isNonFirstStatement(FirContractDescription $this$isNonFirstStatement) {
        FirContractDescription firContractDescription = $this$isNonFirstStatement;
        return firContractDescription instanceof FirResolvedContractDescription ? Intrinsics.areEqual(((FirResolvedContractDescription)$this$isNonFirstStatement).getDiagnostic(), ConeContractShouldBeFirstStatement.INSTANCE) : (firContractDescription instanceof FirErrorContractDescription ? Intrinsics.areEqual(((FirErrorContractDescription)$this$isNonFirstStatement).getDiagnostic(), ConeContractShouldBeFirstStatement.INSTANCE) : false);
    }
}

