/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.component.repository;

import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jetbrains.kotlin.org.codehaus.plexus.component.repository.ComponentRequirement;

public class ComponentDescriptor<T> {
    private String role;
    private String hint = "default";
    private String description = "";
    private String instantiationStrategy = "singleton";
    private String implementation;
    private ClassRealm classRealm;
    private Class<?> implementationClass;
    private String componentFactory;
    private List<ComponentRequirement> requirements = Collections.emptyList();

    public String getRole() {
        return this.role;
    }

    public final Class<T> getRoleClass() {
        try {
            return this.classRealm.loadClass(this.getRole());
        }
        catch (Exception e) {
            throw new TypeNotPresentException(this.getRole(), e);
        }
        catch (LinkageError e) {
            throw new TypeNotPresentException(this.getRole(), e);
        }
    }

    public String getRoleHint() {
        return this.hint;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public final String getImplementation() {
        return this.implementation;
    }

    public final Class<T> getImplementationClass() {
        if (null == this.implementationClass && null != this.classRealm) {
            try {
                this.implementationClass = this.classRealm.loadClass(this.implementation);
            }
            catch (Exception e) {
                throw new TypeNotPresentException(this.implementation, e);
            }
            catch (LinkageError e) {
                throw new TypeNotPresentException(this.implementation, e);
            }
        }
        return this.implementationClass;
    }

    public final String getComponentFactory() {
        return this.componentFactory;
    }

    public final List<ComponentRequirement> getRequirements() {
        return Collections.unmodifiableList(this.requirements);
    }

    public final String toString() {
        return this.getClass().getName() + " [role: '" + this.getRole() + "', hint: '" + this.getRoleHint() + "', realm: " + this.classRealm + "]";
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof ComponentDescriptor) {
            ComponentDescriptor rhsDescriptor = (ComponentDescriptor)rhs;
            return ComponentDescriptor.equals(this.getRole(), rhsDescriptor.getRole()) && ComponentDescriptor.equals(this.getRoleHint(), rhsDescriptor.getRoleHint()) && ComponentDescriptor.equals(this.classRealm, rhsDescriptor.classRealm);
        }
        return false;
    }

    public int hashCode() {
        return ((527 + ComponentDescriptor.hash(this.getRole())) * 31 + ComponentDescriptor.hash(this.getRoleHint())) * 31 + ComponentDescriptor.hash(this.classRealm);
    }

    private static final <T> boolean equals(T lhs, T rhs) {
        return null != lhs ? lhs.equals(rhs) : null == rhs;
    }

    private static final int hash(Object obj) {
        return null != obj ? obj.hashCode() : 0;
    }
}

