/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.MembersInjector;
import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.internal.Lookups;
import org.jetbrains.kotlin.com.google.inject.internal.MethodAspect;
import org.jetbrains.kotlin.com.google.inject.matcher.Matcher;
import org.jetbrains.kotlin.com.google.inject.matcher.Matchers;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionListener;
import org.jetbrains.kotlin.com.google.inject.spi.Message;
import org.jetbrains.kotlin.com.google.inject.spi.TypeEncounter;
import org.jetbrains.kotlin.org.aopalliance.intercept.MethodInterceptor;

final class EncounterImpl<T>
implements TypeEncounter<T> {
    private final Errors errors;
    private final Lookups lookups;
    private List<MembersInjector<? super T>> membersInjectors;
    private List<InjectionListener<? super T>> injectionListeners;
    private List<MethodAspect> aspects;
    private boolean valid = true;

    EncounterImpl(Errors errors, Lookups lookups) {
        this.errors = errors;
        this.lookups = lookups;
    }

    void invalidate() {
        this.valid = false;
    }

    ImmutableList<MethodAspect> getAspects() {
        return this.aspects == null ? ImmutableList.of() : ImmutableList.copyOf(this.aspects);
    }

    @Override
    public void bindInterceptor(Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        if (this.aspects == null) {
            this.aspects = Lists.newArrayList();
        }
        this.aspects.add(new MethodAspect(Matchers.any(), methodMatcher, interceptors));
    }

    ImmutableSet<MembersInjector<? super T>> getMembersInjectors() {
        return this.membersInjectors == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.membersInjectors);
    }

    ImmutableSet<InjectionListener<? super T>> getInjectionListeners() {
        return this.injectionListeners == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.injectionListeners);
    }

    @Override
    public void register(MembersInjector<? super T> membersInjector) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        if (this.membersInjectors == null) {
            this.membersInjectors = Lists.newArrayList();
        }
        this.membersInjectors.add(membersInjector);
    }

    @Override
    public void register(InjectionListener<? super T> injectionListener) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        if (this.injectionListeners == null) {
            this.injectionListeners = Lists.newArrayList();
        }
        this.injectionListeners.add(injectionListener);
    }

    @Override
    public void addError(String message, Object ... arguments) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        this.errors.addMessage(message, arguments);
    }

    @Override
    public void addError(Throwable t) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        this.errors.errorInUserCode(t, "An exception was caught and reported. Message: %s", t.getMessage());
    }

    @Override
    public void addError(Message message) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        this.errors.addMessage(message);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        return this.lookups.getProvider(key);
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Preconditions.checkState(this.valid, "Encounters may not be used after hear() returns.");
        return this.lookups.getMembersInjector(typeLiteral);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.getMembersInjector(TypeLiteral.get(type));
    }
}

