/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.inline;

import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/ir/inline/GeneratedAccessor;", "", "accessorFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "targetSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)V", "getAccessorFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getTargetSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "inlineFunctions", "", "getInlineFunctions", "()Ljava/util/Set;", "computeNarrowedVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "ir.inline"})
@SourceDebugExtension(value={"SMAP\nSyntheticAccessorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/ir/inline/GeneratedAccessor\n+ 2 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n28#2:303\n29#2:305\n1#3:304\n*S KotlinDebug\n*F\n+ 1 SyntheticAccessorLowering.kt\norg/jetbrains/kotlin/ir/inline/GeneratedAccessor\n*L\n293#1:303\n293#1:305\n293#1:304\n*E\n"})
final class GeneratedAccessor {
    @NotNull
    private final IrFunction accessorFunction;
    @NotNull
    private final IrSymbol targetSymbol;
    @NotNull
    private final Set<IrFunction> inlineFunctions;

    public GeneratedAccessor(@NotNull IrFunction accessorFunction, @NotNull IrSymbol targetSymbol) {
        Intrinsics.checkNotNullParameter(accessorFunction, "accessorFunction");
        Intrinsics.checkNotNullParameter(targetSymbol, "targetSymbol");
        this.accessorFunction = accessorFunction;
        this.targetSymbol = targetSymbol;
        this.inlineFunctions = new HashSet();
    }

    @NotNull
    public final IrFunction getAccessorFunction() {
        return this.accessorFunction;
    }

    @NotNull
    public final IrSymbol getTargetSymbol() {
        return this.targetSymbol;
    }

    @NotNull
    public final Set<IrFunction> getInlineFunctions() {
        return this.inlineFunctions;
    }

    @NotNull
    public final DescriptorVisibility computeNarrowedVisibility() {
        for (IrFunction inlineFunction2 : this.inlineFunctions) {
            IrExceptionBuilder irExceptionBuilder;
            DescriptorVisibility visibility = inlineFunction2.getVisibility();
            if (Intrinsics.areEqual(visibility, DescriptorVisibilities.PUBLIC) || Intrinsics.areEqual(visibility, DescriptorVisibilities.PROTECTED)) {
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PUBLIC");
                return descriptorVisibility;
            }
            if (Intrinsics.areEqual(visibility, DescriptorVisibilities.INTERNAL)) {
                if (!IrUtilsKt.isPublishedApi(inlineFunction2)) continue;
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
                Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "PUBLIC");
                return descriptorVisibility;
            }
            String message$iv = "Unexpected visibility of inline function: " + visibility;
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder $this$computeNarrowedVisibility_u24lambda_u240 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            $this$computeNarrowedVisibility_u24lambda_u240.withIrEntry("inlineFunction", inlineFunction2);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INTERNAL;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "INTERNAL");
        return descriptorVisibility;
    }
}

