/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.AnalysisExceptionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00060\u0001j\u0002`\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/util/FileAnalysisException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "path", "", "cause", "", "lineAndOffset", "Lkotlin/Pair;", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;Lkotlin/Pair;)V", "getCause", "()Ljava/lang/Throwable;", "message", "getMessage", "()Ljava/lang/String;", "frontend.common"})
public final class FileAnalysisException
extends Exception {
    @NotNull
    private final String path;
    @NotNull
    private final Throwable cause;
    @Nullable
    private final Pair<Integer, Integer> lineAndOffset;

    public FileAnalysisException(@NotNull String path, @NotNull Throwable cause, @Nullable Pair<Integer, Integer> lineAndOffset) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(cause, "cause");
        this.path = path;
        this.cause = cause;
        this.lineAndOffset = lineAndOffset;
    }

    public /* synthetic */ FileAnalysisException(String string2, Throwable throwable, Pair pair, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pair = null;
        }
        this(string2, throwable, pair);
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    @NotNull
    public String getMessage() {
        Pair<Integer, Integer> pair = this.lineAndOffset;
        if (pair == null) {
            return "Somewhere in file " + this.path + ": " + AnalysisExceptionsKt.getClassNameAndMessage(this.getCause());
        }
        Pair<Integer, Integer> pair2 = pair;
        int line = ((Number)pair2.component1()).intValue();
        int offset2 = ((Number)pair2.component2()).intValue();
        return "While analysing " + this.path + ':' + (line + 1) + ':' + (offset2 + 1) + ": " + AnalysisExceptionsKt.getClassNameAndMessage(this.getCause());
    }
}

