/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElementImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "Lorg/jetbrains/kotlin/psi/KtElementImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "getContainingDoc", "Lorg/jetbrains/kotlin/kdoc/psi/api/KDoc;", "getContainingSection", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "getNameText", "", "getNameTextRange", "Lcom/intellij/openapi/util/TextRange;", "getQualifiedName", "", "getQualifiedNameAsFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getQualifier", "psi"})
@SourceDebugExtension(value={"SMAP\nKDocName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KDocName.kt\norg/jetbrains/kotlin/kdoc/psi/impl/KDocName\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,67:1\n142#2:68\n142#2:69\n154#2:70\n*S KotlinDebug\n*F\n+ 1 KDocName.kt\norg/jetbrains/kotlin/kdoc/psi/impl/KDocName\n*L\n33#1:68\n38#1:69\n42#1:70\n*E\n"})
public final class KDocName
extends KtElementImpl {
    public KDocName(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    @NotNull
    public final KDoc getContainingDoc() {
        KDoc kdoc;
        PsiElement $this$getStrictParentOfType$iv = this;
        boolean $i$f$getStrictParentOfType = false;
        KDoc kDoc = kdoc = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KDoc.class, true);
        if (kDoc == null) {
            throw new IllegalStateException("KDocName must be inside a KDoc");
        }
        return kDoc;
    }

    @NotNull
    public final KDocSection getContainingSection() {
        KDocSection kdoc;
        PsiElement $this$getStrictParentOfType$iv = this;
        boolean $i$f$getStrictParentOfType = false;
        KDocSection kDocSection = kdoc = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KDocSection.class, true);
        if (kDocSection == null) {
            throw new IllegalStateException("KDocName must be inside a KDocSection");
        }
        return kDocSection;
    }

    @Nullable
    public final KDocName getQualifier() {
        PsiElement $this$getChildOfType$iv = this;
        boolean $i$f$getChildOfType = false;
        return PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KDocName.class);
    }

    @NotNull
    public final TextRange getNameTextRange() {
        ASTNode dot = this.getNode().findChildByType(KtTokens.DOT);
        TextRange textRange = this.getTextRange();
        ASTNode aSTNode = dot;
        int nameStart = aSTNode != null ? aSTNode.getTextRange().getEndOffset() - textRange.getStartOffset() : 0;
        return new TextRange(nameStart, textRange.getLength());
    }

    @NotNull
    public final String getNameText() {
        String string2 = this.getNameTextRange().substring(this.getText());
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return string2;
    }

    @NotNull
    public final List<String> getQualifiedName() {
        KDocName qualifier2 = this.getQualifier();
        List<String> nameAsList = CollectionsKt.listOf(this.getNameText());
        KDocName kDocName = qualifier2;
        return kDocName != null ? CollectionsKt.plus((Collection)kDocName.getQualifiedName(), (Iterable)nameAsList) : nameAsList;
    }

    @NotNull
    public final FqName getQualifiedNameAsFqName() {
        FqName fqName2 = FqName.fromSegments(this.getQualifiedName());
        Intrinsics.checkNotNullExpressionValue(fqName2, "fromSegments(...)");
        return fqName2;
    }
}

