/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"simplifyWrappedFunctions", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "js.translator"})
public final class SimplifyWrappedFunctionsKt {
    public static final void simplifyWrappedFunctions(@NotNull JsNode root2) {
        Intrinsics.checkNotNullParameter(root2, "root");
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(){

            public void endVisit(@NotNull JsInvocation x, @NotNull JsContext<? super JsNode> ctx) {
                block1: {
                    Intrinsics.checkNotNullParameter(x, "x");
                    Intrinsics.checkNotNullParameter(ctx, "ctx");
                    FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(x);
                    if (functionWithWrapper == null) break block1;
                    FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                    boolean bl = false;
                    JsFunction function2 = functionWithWrapper2.component1();
                    JsBlock wrapper = functionWithWrapper2.component2();
                    if (wrapper != null && wrapper.getStatements().size() == 1) {
                        ctx.replaceMe((JsNode)function2);
                    }
                }
            }

            public void endVisit(@NotNull JsVars x, @NotNull JsContext<? super JsStatement> ctx) {
                block2: {
                    Intrinsics.checkNotNullParameter(x, "x");
                    Intrinsics.checkNotNullParameter(ctx, "ctx");
                    List<JsVars.JsVar> list2 = x.getVars();
                    Intrinsics.checkNotNullExpressionValue(list2, "getVars(...)");
                    JsVars.JsVar jsVar = CollectionsKt.singleOrNull(list2);
                    if (jsVar == null) break block2;
                    JsVars.JsVar jsVar2 = jsVar;
                    boolean bl = false;
                    JsExpression jsExpression = jsVar2.getInitExpression();
                    JsFunction jsFunction = jsExpression instanceof JsFunction ? (JsFunction)jsExpression : null;
                    if (jsFunction != null) {
                        JsFunction function2 = jsFunction;
                        boolean bl2 = false;
                        if (function2.getName() == null) {
                            function2.setName(jsVar2.getName());
                            ctx.replaceMe((JsNode)function2.makeStmt());
                        }
                    }
                }
            }
        };
        visitor2.accept(root2);
    }
}

