/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.runtime;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeStats {
    private final HashMap<StatsInterface, ArrayList<NativeFunction>> snapshot;

    public NativeStats(StatsInterface ... classes2) {
        this(Arrays.asList(classes2));
    }

    public NativeStats(Collection<StatsInterface> classes2) {
        this(NativeStats.snapshot(classes2));
    }

    private NativeStats(HashMap<StatsInterface, ArrayList<NativeFunction>> snapshot2) {
        this.snapshot = snapshot2;
    }

    public void reset() {
        for (ArrayList<NativeFunction> functions2 : this.snapshot.values()) {
            for (NativeFunction function2 : functions2) {
                function2.reset();
            }
        }
    }

    public void update() {
        for (Map.Entry<StatsInterface, ArrayList<NativeFunction>> entry : this.snapshot.entrySet()) {
            StatsInterface si = entry.getKey();
            for (NativeFunction function2 : entry.getValue()) {
                function2.setCounter(si.functionCounter(function2.getOrdinal()));
            }
        }
    }

    public NativeStats snapshot() {
        NativeStats copy2 = this.copy();
        copy2.update();
        return copy2;
    }

    public NativeStats copy() {
        HashMap<StatsInterface, ArrayList<NativeFunction>> rc = new HashMap<StatsInterface, ArrayList<NativeFunction>>(this.snapshot.size() * 2);
        for (Map.Entry<StatsInterface, ArrayList<NativeFunction>> entry : this.snapshot.entrySet()) {
            ArrayList<NativeFunction> list2 = new ArrayList<NativeFunction>(entry.getValue().size());
            for (NativeFunction function2 : entry.getValue()) {
                list2.add(function2.copy());
            }
            rc.put(entry.getKey(), list2);
        }
        return new NativeStats(rc);
    }

    public NativeStats diff() {
        HashMap<StatsInterface, ArrayList<NativeFunction>> rc = new HashMap<StatsInterface, ArrayList<NativeFunction>>(this.snapshot.size() * 2);
        for (Map.Entry<StatsInterface, ArrayList<NativeFunction>> entry : this.snapshot.entrySet()) {
            StatsInterface si = entry.getKey();
            ArrayList<NativeFunction> list2 = new ArrayList<NativeFunction>(entry.getValue().size());
            for (NativeFunction original : entry.getValue()) {
                NativeFunction copy2 = original.copy();
                copy2.setCounter(si.functionCounter(copy2.getOrdinal()));
                copy2.subtract(original);
                list2.add(copy2);
            }
            rc.put(si, list2);
        }
        return new NativeStats(rc);
    }

    public void dump(PrintStream ps) {
        boolean firstSI = true;
        for (Map.Entry<StatsInterface, ArrayList<NativeFunction>> entry : this.snapshot.entrySet()) {
            StatsInterface si = entry.getKey();
            ArrayList<NativeFunction> funcs = entry.getValue();
            int total = 0;
            for (NativeFunction func : funcs) {
                total += func.getCounter();
            }
            if (!firstSI) {
                ps.print(", ");
            }
            firstSI = false;
            ps.print("[");
            if (total > 0) {
                ps.println("{ ");
                ps.println("  \"class\": \"" + si.getNativeClass() + "\",");
                ps.println("  \"total\": " + total + ", ");
                ps.print("  \"functions\": {");
                boolean firstFunc = true;
                for (NativeFunction func : funcs) {
                    if (func.getCounter() <= 0) continue;
                    if (!firstFunc) {
                        ps.print(",");
                    }
                    firstFunc = false;
                    ps.println();
                    ps.print("    \"" + func.getName() + "\": " + func.getCounter());
                }
                ps.println();
                ps.println("  }");
                ps.print("}");
            }
            ps.print("]");
        }
    }

    private static HashMap<StatsInterface, ArrayList<NativeFunction>> snapshot(Collection<StatsInterface> classes2) {
        HashMap<StatsInterface, ArrayList<NativeFunction>> rc = new HashMap<StatsInterface, ArrayList<NativeFunction>>();
        for (StatsInterface sc : classes2) {
            int count = sc.functionCount();
            ArrayList<NativeFunction> functions2 = new ArrayList<NativeFunction>(count);
            for (int i = 0; i < count; ++i) {
                String name2 = sc.functionName(i);
                functions2.add(new NativeFunction(i, name2, 0));
            }
            Collections.sort(functions2);
            rc.put(sc, functions2);
        }
        return rc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NativeFunction
    implements Comparable<NativeFunction> {
        private final int ordinal;
        private final String name;
        private int counter;

        public NativeFunction(int ordinal, String name2, int callCount) {
            this.ordinal = ordinal;
            this.name = name2;
            this.counter = callCount;
        }

        void subtract(NativeFunction func) {
            this.counter -= func.counter;
        }

        public int getCounter() {
            return this.counter;
        }

        public void setCounter(int counter) {
            this.counter = counter;
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        @Override
        public int compareTo(NativeFunction func) {
            return func.counter - this.counter;
        }

        public void reset() {
            this.counter = 0;
        }

        public NativeFunction copy() {
            return new NativeFunction(this.ordinal, this.name, this.counter);
        }
    }

    public static interface StatsInterface {
        public String getNativeClass();

        public int functionCount();

        public String functionName(int var1);

        public int functionCounter(int var1);
    }
}

