/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.LinkedList;
import javaslang.collection.List;
import javaslang.collection.Stream;
import javaslang.collection.Tree;

interface TreeModule {

    public static final class Traversal {
        static <T> Stream<Tree.Node<T>> preOrder(Tree.Node<T> node) {
            return node.getChildren().foldLeft(Stream.of(node), (acc, child) -> acc.appendAll(Traversal.preOrder(child)));
        }

        static <T> Stream<Tree.Node<T>> inOrder(Tree.Node<T> node) {
            if (node.isLeaf()) {
                return Stream.of(node);
            }
            List<Tree.Node<T>> children2 = node.getChildren();
            return children2.tail().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll(Traversal.inOrder(child))).prepend(node).prependAll(Traversal.inOrder((Tree.Node)children2.head()));
        }

        static <T> Stream<Tree.Node<T>> postOrder(Tree.Node<T> node) {
            return node.getChildren().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll(Traversal.postOrder(child))).append(node);
        }

        static <T> Stream<Tree.Node<T>> levelOrder(Tree.Node<T> node) {
            Stream<Tree.Node> result2 = Stream.empty();
            LinkedList<Tree.Node<T>> queue = new LinkedList<Tree.Node<T>>();
            queue.add(node);
            while (!queue.isEmpty()) {
                Tree.Node next = (Tree.Node)queue.remove();
                result2 = result2.prepend(next);
                queue.addAll(next.getChildren().toJavaList());
            }
            return result2.reverse();
        }
    }
}

