function(kokkos_set_intel_flags full_standard int_standard)
  string(TOLOWER ${full_standard} FULL_LC_STANDARD)
  string(TOLOWER ${int_standard} INT_LC_STANDARD)
  # The following three blocks of code were copied from
  # /Modules/Compiler/Intel-CXX.cmake from CMake 3.18.1 and then modified.
  if(CMAKE_CXX_SIMULATE_ID STREQUAL MSVC)
    set(_std -Qstd)
    set(_ext c++)
  else()
    set(_std -std)
    set(_ext gnu++)
  endif()
  set(KOKKOS_CXX_STANDARD_FLAG "${_std}=c++${FULL_LC_STANDARD}" PARENT_SCOPE)
  set(KOKKOS_CXX_INTERMDIATE_STANDARD_FLAG "${_std}=${_ext}${INT_LC_STANDARD}" PARENT_SCOPE)
endfunction()
