/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.AsdfPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.release.GithubReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;

public class AsdfPackagerProcessor
extends AbstractRepositoryPackagerProcessor<AsdfPackager> {
    public AsdfPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.set("distributionJavaMainClass", (Object)distribution.getJava().getMainClass());
        props.set("distributionJavaMainModule", (Object)distribution.getJava().getMainModule());
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        String repoUrl = releaser.getResolvedRepoUrl(this.context.getModel(), ((AsdfPackager)this.packager).getRepository().getOwner(), ((AsdfPackager)this.packager).getRepository().getResolvedName());
        props.set("asdfPluginRepoUrl", (Object)repoUrl);
        props.set("asdfPluginToolCheck", (Object)Templates.resolveTemplate((String)((AsdfPackager)this.packager).getToolCheck(), (TemplateContext)props));
        String str = (String)props.get("distributionArtifactFile");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$ASDF_INSTALL_VERSION");
        props.set("asdfDistributionArtifactFile", (Object)str);
        str = (String)props.get("distributionArtifactFileName");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.set("asdfDistributionArtifactFileName", (Object)str);
        str = (String)props.get("distributionUrl");
        str = str.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.set("asdfDistributionUrl", (Object)str);
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        BaseReleaser gitService = this.context.getModel().getRelease().getReleaser();
        if (fileName.contains("github") && !(gitService instanceof GithubReleaser)) {
            return;
        }
        if (fileName.contains("-github")) {
            fileName = StringUtils.remove((String)fileName, (String)"-github");
        }
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

