/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.DiscussionsAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class DiscussionsAnnouncerValidator {
    private static final String DEFAULT_DISCUSSIONS_TPL = "src/jreleaser/templates/discussions.tpl";

    private DiscussionsAnnouncerValidator() {
    }

    public static void validateDiscussions(JReleaserContext context, DiscussionsAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.discussions");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.discussions", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!"github".equals(context.getModel().getRelease().getReleaser().getServiceName())) {
            errors.configuration(RB.$((String)"validation_discussions_enabled", (Object[])new Object[0]));
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            announcer.disable();
            return;
        }
        if (StringUtils.isBlank((String)announcer.getOrganization())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"discussions.organization"}));
        }
        if (StringUtils.isBlank((String)announcer.getTeam())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"discussions.team"}));
        }
        if (StringUtils.isBlank((String)announcer.getTitle())) {
            announcer.setTitle(RB.$((String)"default.discussion.title", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            announcer.setMessageTemplate(DEFAULT_DISCUSSIONS_TPL);
        }
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_DISCUSSIONS_TPL), new LinkOption[0])) {
                announcer.setMessageTemplate(DEFAULT_DISCUSSIONS_TPL);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"discussions.messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

