/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.TwitterAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class TwitterAnnouncerValidator {
    private TwitterAnnouncerValidator() {
    }

    public static void validateTwitter(JReleaserContext context, TwitterAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.twitter");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.twitter", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setConsumerKey(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.twitter.consumer.key", "TWITTER_CONSUMER_KEY"}), "announce.twitter.consumerKey", announcer.getConsumerKey(), errors, context.isDryrun()));
        announcer.setConsumerSecret(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.twitter.consumer.secret", "TWITTER_CONSUMER_SECRET"}), "announce.twitter.consumerSecret", announcer.getConsumerSecret(), errors, context.isDryrun()));
        announcer.setAccessToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.twitter.access.token", "TWITTER_ACCESS_TOKEN"}), "announce.twitter.accessToken", announcer.getAccessToken(), errors, context.isDryrun()));
        announcer.setAccessTokenSecret(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.twitter.access.token.secret", "TWITTER_ACCESS_TOKEN_SECRET"}), "announce.twitter.accessTokenSecret", announcer.getAccessTokenSecret(), errors, context.isDryrun()));
        if (StringUtils.isNotBlank((String)announcer.getStatusTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getStatusTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"twitter.statusTemplate", announcer.getStatusTemplate()}));
        }
        if (StringUtils.isBlank((String)announcer.getStatus()) && StringUtils.isBlank((String)announcer.getStatusTemplate()) && announcer.getStatuses().isEmpty()) {
            announcer.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        Validator.validateTimeout(announcer);
    }
}

