/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.hooks;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.api.hooks.ScriptHook;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Matrix;
import org.jreleaser.model.internal.hooks.CommandHook;
import org.jreleaser.model.internal.hooks.CommandHookProvider;
import org.jreleaser.model.internal.hooks.CommandHooks;
import org.jreleaser.model.internal.hooks.Hook;
import org.jreleaser.model.internal.hooks.Hooks;
import org.jreleaser.model.internal.hooks.JbangHook;
import org.jreleaser.model.internal.hooks.JbangHookProvider;
import org.jreleaser.model.internal.hooks.JbangHooks;
import org.jreleaser.model.internal.hooks.NamedCommandHooks;
import org.jreleaser.model.internal.hooks.NamedJbangHooks;
import org.jreleaser.model.internal.hooks.NamedScriptHooks;
import org.jreleaser.model.internal.hooks.ScriptHook;
import org.jreleaser.model.internal.hooks.ScriptHookProvider;
import org.jreleaser.model.internal.hooks.ScriptHooks;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.sdk.tool.JBang;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.DefaultVersions;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class HookExecutor {
    private static final String JRELEASER_OUTPUT = "JRELEASER_OUTPUT:";
    private final JReleaserContext context;

    public HookExecutor(JReleaserContext context) {
        this.context = context;
    }

    public void execute(String step, Runnable runnable) {
        this.executeHooks(ExecutionEvent.before((String)step));
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            this.executeHooks(ExecutionEvent.failure((String)step, (Throwable)e));
            throw e;
        }
        this.executeHooks(ExecutionEvent.success((String)step));
    }

    public void executeHooks(ExecutionEvent event) {
        Hooks hooks = this.context.getModel().getHooks();
        if (!hooks.isEnabled() || this.evaluateCondition(hooks.getCondition())) {
            return;
        }
        Map<String, String> rootEnv = this.resolveEnvironment(hooks.getEnvironment());
        this.executeScriptHooks(event, rootEnv);
        this.executeCommandHooks(event, rootEnv);
        this.executeJbangHooks(event, rootEnv);
    }

    private boolean evaluateCondition(String condition) {
        return StringUtils.isNotBlank((String)condition) && StringUtils.isFalse((Object)this.context.eval(condition));
    }

    private Map<String, String> resolveEnvironment(Map<String, String> src) {
        return this.resolveEnvironment(src, null);
    }

    private Map<String, String> resolveEnvironment(Map<String, String> src, TemplateContext additionalContext) {
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        TemplateContext props = this.context.props().setAll(additionalContext);
        src.forEach((k, v) -> {
            String value = Templates.resolveTemplate((String)v, (TemplateContext)props);
            if (StringUtils.isNotBlank((String)value)) {
                env.put((String)k, value);
            }
        });
        return env;
    }

    private Map<String, String> mergeEnvironment(Map<String, String> src, Map<String, String> ... others) {
        LinkedHashMap<String, String> tmp = new LinkedHashMap<String, String>(src);
        if (null != others && others.length > 0) {
            for (Map<String, String> env : others) {
                tmp.putAll(env);
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScriptHooks(ExecutionEvent event, Map<String, String> rootEnv) {
        ScriptHooks scriptHooks = this.context.getModel().getHooks().getScript();
        if (!scriptHooks.isEnabled() || this.evaluateCondition(scriptHooks.getCondition())) {
            return;
        }
        List<ScriptHook> hooks = this.collectScriptHooks(event, (ScriptHookProvider)scriptHooks);
        if (!hooks.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"hooks.script.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
        }
        this.context.getLogger().setPrefix("hooks");
        this.context.getLogger().increaseIndent();
        try {
            for (ScriptHook hook : hooks) {
                String prefix = "hooks";
                if (StringUtils.isNotBlank((String)hook.getName())) {
                    prefix = prefix + "." + hook.getName();
                }
                this.context.getLogger().replacePrefix(prefix);
                if (!hook.getMatrix().isEmpty()) {
                    for (Map matrixRow : hook.getMatrix().resolve()) {
                        String srcPlatform;
                        if (matrixRow.containsKey("platform") && !this.context.isPlatformSelected(srcPlatform = (String)matrixRow.get("platform"))) continue;
                        this.executeScriptHook(event, hook, this.mergeEnvironment(rootEnv, scriptHooks.getEnvironment()), matrixRow);
                    }
                    continue;
                }
                this.executeScriptHook(event, hook, this.mergeEnvironment(rootEnv, scriptHooks.getEnvironment()), null);
            }
        }
        finally {
            this.context.getLogger().decreaseIndent();
            this.context.getLogger().restorePrefix();
        }
        this.executeNamedScriptHooks(event, rootEnv, scriptHooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNamedScriptHooks(ExecutionEvent event, Map<String, String> rootEnv, ScriptHooks scriptHooks) {
        if (!scriptHooks.isEnabled() || this.evaluateCondition(scriptHooks.getCondition())) {
            return;
        }
        for (NamedScriptHooks group : scriptHooks.getGroups().values()) {
            if (!group.isEnabled() || this.evaluateCondition(group.getCondition())) continue;
            List<ScriptHook> hooks = this.collectScriptHooks(event, (ScriptHookProvider)group);
            if (!hooks.isEmpty()) {
                this.context.getLogger().info(RB.$((String)"hooks.script.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
            }
            this.context.getLogger().setPrefix("hooks");
            this.context.getLogger().increaseIndent();
            try {
                for (ScriptHook hook : hooks) {
                    String prefix = "hooks";
                    if (StringUtils.isNotBlank((String)hook.getName())) {
                        prefix = prefix + "." + hook.getName();
                    }
                    this.context.getLogger().replacePrefix(prefix);
                    if (!hook.getMatrix().isEmpty()) {
                        for (Map matrixRow : hook.getMatrix().resolve()) {
                            String srcPlatform;
                            if (matrixRow.containsKey("platform") && !this.context.isPlatformSelected(srcPlatform = (String)matrixRow.get("platform"))) continue;
                            this.executeScriptHook(event, hook, this.mergeEnvironment(rootEnv, scriptHooks.getEnvironment(), group.getEnvironment()), matrixRow);
                        }
                        continue;
                    }
                    this.executeScriptHook(event, hook, this.mergeEnvironment(rootEnv, scriptHooks.getEnvironment(), group.getEnvironment()), null);
                }
            }
            finally {
                this.context.getLogger().decreaseIndent();
                this.context.getLogger().restorePrefix();
            }
        }
    }

    private List<ScriptHook> collectScriptHooks(ExecutionEvent event, ScriptHookProvider scriptHookProvider) {
        ArrayList<ScriptHook> hooks = new ArrayList<ScriptHook>();
        switch (event.getType()) {
            case BEFORE: {
                hooks.addAll(this.filter(scriptHookProvider.getBefore(), event));
                break;
            }
            case SUCCESS: {
                hooks.addAll(this.filter(scriptHookProvider.getSuccess(), event));
                break;
            }
            case FAILURE: {
                hooks.addAll(this.filter(scriptHookProvider.getFailure(), event));
            }
        }
        return hooks;
    }

    private void executeScriptHook(ExecutionEvent event, ScriptHook hook, Map<String, String> env, Map<String, String> matrixRow) {
        TemplateContext additionalContext = Matrix.asTemplateContext(matrixRow);
        Map<String, String> localEnv = new LinkedHashMap<String, String>(env);
        localEnv = this.resolveEnvironment(localEnv, additionalContext);
        Path scriptFile = null;
        try {
            scriptFile = this.createScriptFile(this.context, hook, additionalContext, event);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_script_hook_create_error", (Object[])new Object[0]), (Throwable)e);
        }
        String resolvedCmd = hook.getShell().expression().replace("{{script}}", scriptFile.toAbsolutePath().toString());
        this.executeCommandLine(localEnv, additionalContext, (Hook)hook, resolvedCmd, resolvedCmd, "ERROR_script_hook_unexpected_error");
    }

    private Path createScriptFile(JReleaserContext context, ScriptHook hook, TemplateContext additionalContext, ExecutionEvent event) throws IOException {
        String scriptContents = hook.getResolvedRun(context, additionalContext, event);
        Path scriptFile = Files.createTempFile("jreleaser", hook.getShell().extension(), new FileAttribute[0]);
        if (hook.getShell() == ScriptHook.Shell.PWSH || hook.getShell() == ScriptHook.Shell.POWERSHELL) {
            scriptContents = "$ErrorActionPreference = 'stop'" + System.lineSeparator() + scriptContents;
            scriptContents = scriptContents + System.lineSeparator() + "if ((Test-Path -LiteralPath variable:\\LASTEXITCODE)) { exit $LASTEXITCODE }";
        }
        Files.write(scriptFile, scriptContents.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE);
        return scriptFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommandHooks(ExecutionEvent event, Map<String, String> rootEnv) {
        CommandHooks commandHooks = this.context.getModel().getHooks().getCommand();
        if (!commandHooks.isEnabled() || this.evaluateCondition(commandHooks.getCondition())) {
            return;
        }
        List<CommandHook> hooks = this.collectCommandHooks(event, (CommandHookProvider)commandHooks);
        if (!hooks.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"hooks.command.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
        }
        this.context.getLogger().setPrefix("hooks");
        this.context.getLogger().increaseIndent();
        try {
            for (CommandHook hook : hooks) {
                String prefix = "hooks";
                if (StringUtils.isNotBlank((String)hook.getName())) {
                    prefix = prefix + "." + hook.getName();
                }
                this.context.getLogger().replacePrefix(prefix);
                if (!hook.getMatrix().isEmpty()) {
                    for (Map matrixRow : hook.getMatrix().resolve()) {
                        String srcPlatform;
                        if (matrixRow.containsKey("platform") && !this.context.isPlatformSelected(srcPlatform = (String)matrixRow.get("platform"))) continue;
                        this.executeCommandHook(event, hook, this.mergeEnvironment(rootEnv, commandHooks.getEnvironment()), matrixRow);
                    }
                    continue;
                }
                this.executeCommandHook(event, hook, this.mergeEnvironment(rootEnv, commandHooks.getEnvironment()), null);
            }
        }
        finally {
            this.context.getLogger().decreaseIndent();
            this.context.getLogger().restorePrefix();
        }
        this.executeNamedCommandHooks(event, rootEnv, commandHooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNamedCommandHooks(ExecutionEvent event, Map<String, String> rootEnv, CommandHooks commandHooks) {
        if (!commandHooks.isEnabled() || this.evaluateCondition(commandHooks.getCondition())) {
            return;
        }
        for (NamedCommandHooks group : commandHooks.getGroups().values()) {
            if (!group.isEnabled() || this.evaluateCondition(group.getCondition())) continue;
            List<CommandHook> hooks = this.collectCommandHooks(event, (CommandHookProvider)group);
            if (!hooks.isEmpty()) {
                this.context.getLogger().info(RB.$((String)"hooks.command.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
            }
            this.context.getLogger().setPrefix("hooks");
            this.context.getLogger().increaseIndent();
            try {
                for (CommandHook hook : hooks) {
                    String prefix = "hooks";
                    if (StringUtils.isNotBlank((String)hook.getName())) {
                        prefix = prefix + "." + hook.getName();
                    }
                    this.context.getLogger().replacePrefix(prefix);
                    if (!hook.getMatrix().isEmpty()) {
                        for (Map matrixRow : hook.getMatrix().resolve()) {
                            String srcPlatform;
                            if (matrixRow.containsKey("platform") && !this.context.isPlatformSelected(srcPlatform = (String)matrixRow.get("platform"))) continue;
                            this.executeCommandHook(event, hook, this.mergeEnvironment(rootEnv, commandHooks.getEnvironment(), group.getEnvironment()), matrixRow);
                        }
                        continue;
                    }
                    this.executeCommandHook(event, hook, this.mergeEnvironment(rootEnv, commandHooks.getEnvironment(), group.getEnvironment()), null);
                }
            }
            finally {
                this.context.getLogger().decreaseIndent();
                this.context.getLogger().restorePrefix();
            }
        }
    }

    private List<CommandHook> collectCommandHooks(ExecutionEvent event, CommandHookProvider commandHookProvider) {
        ArrayList<CommandHook> hooks = new ArrayList<CommandHook>();
        switch (event.getType()) {
            case BEFORE: {
                hooks.addAll(this.filter(commandHookProvider.getBefore(), event));
                break;
            }
            case SUCCESS: {
                hooks.addAll(this.filter(commandHookProvider.getSuccess(), event));
                break;
            }
            case FAILURE: {
                hooks.addAll(this.filter(commandHookProvider.getFailure(), event));
            }
        }
        return hooks;
    }

    private void executeCommandHook(ExecutionEvent event, CommandHook hook, Map<String, String> env, Map<String, String> matrixRow) {
        TemplateContext additionalContext = Matrix.asTemplateContext(matrixRow);
        Map<String, String> localEnv = new LinkedHashMap<String, String>(env);
        localEnv = this.resolveEnvironment(localEnv, additionalContext);
        String resolvedCmd = hook.getResolvedCmd(this.context, additionalContext, event);
        this.executeCommandLine(localEnv, additionalContext, (Hook)hook, hook.getCmd(), resolvedCmd, "ERROR_command_hook_unexpected_error");
    }

    private void executeCommandLine(Map<String, String> localEnv, TemplateContext additionalContext, Hook hook, String cmd, String resolvedCmd, String errorKey) {
        List<String> commandLine = null;
        Map<String, String> hookEnv = new LinkedHashMap<String, String>(localEnv);
        hookEnv.putAll(hook.getEnvironment());
        hookEnv = this.resolveEnvironment(hookEnv, additionalContext);
        try {
            commandLine = HookExecutor.parseCommand(resolvedCmd);
        }
        catch (IllegalStateException e) {
            throw new JReleaserException(RB.$((String)"ERROR_command_hook_parser_error", (Object[])new Object[]{cmd}), (Throwable)e);
        }
        try {
            Command command = new Command(commandLine);
            this.processOutput(this.executeCommand(this.context.getBasedir(), command, hookEnv, hook.isVerbose()));
        }
        catch (CommandException e) {
            if (!hook.isContinueOnError()) {
                throw new JReleaserException(RB.$((String)errorKey, (Object[])new Object[0]), (Throwable)e);
            }
            if (null != e.getCause()) {
                this.context.getLogger().warn(e.getCause().getMessage());
            } else {
                this.context.getLogger().warn(e.getMessage());
            }
            this.context.getLogger().trace(RB.$((String)errorKey, (Object[])new Object[0]), (Throwable)e);
        }
    }

    private void processOutput(Command.Result result) {
        if (!result.getOut().contains(JRELEASER_OUTPUT)) {
            return;
        }
        for (String line : result.getOut().split(System.lineSeparator())) {
            if (!line.startsWith(JRELEASER_OUTPUT)) continue;
            line = line.substring(JRELEASER_OUTPUT.length());
            int p = line.indexOf("=");
            String key = line.substring(0, p);
            String value = line.substring(p + 1);
            this.context.getModel().getEnvironment().getProperties().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJbangHooks(ExecutionEvent event, Map<String, String> rootEnv) {
        JbangHooks jbangHooks = this.context.getModel().getHooks().getJbang();
        if (!jbangHooks.isEnabled() || this.evaluateCondition(jbangHooks.getCondition())) {
            return;
        }
        List<JbangHook> hooks = this.collectJbangHooks(event, (JbangHookProvider)jbangHooks);
        if (!hooks.isEmpty()) {
            this.context.getLogger().info(RB.$((String)"hooks.jbang.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
        }
        this.context.getLogger().setPrefix("hooks");
        this.context.getLogger().increaseIndent();
        try {
            for (JbangHook hook : hooks) {
                String prefix = "hooks";
                if (StringUtils.isNotBlank((String)hook.getName())) {
                    prefix = prefix + "." + hook.getName();
                }
                this.context.getLogger().replacePrefix(prefix);
                if (!hook.getMatrix().isEmpty()) {
                    for (Map matrixRow : hook.getMatrix().resolve()) {
                        String srcPlatform;
                        if (matrixRow.containsKey("platform") && !this.context.isPlatformSelected(srcPlatform = (String)matrixRow.get("platform"))) continue;
                        this.executeJbangHook(event, hook, this.mergeEnvironment(rootEnv, jbangHooks.getEnvironment()), matrixRow);
                    }
                    continue;
                }
                this.executeJbangHook(event, hook, this.mergeEnvironment(rootEnv, jbangHooks.getEnvironment()), null);
            }
        }
        finally {
            this.context.getLogger().decreaseIndent();
            this.context.getLogger().restorePrefix();
        }
        this.executeNamedJbangHooks(event, rootEnv, jbangHooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNamedJbangHooks(ExecutionEvent event, Map<String, String> rootEnv, JbangHooks jbangHooks) {
        if (!jbangHooks.isEnabled() || this.evaluateCondition(jbangHooks.getCondition())) {
            return;
        }
        for (NamedJbangHooks group : jbangHooks.getGroups().values()) {
            if (!group.isEnabled() || this.evaluateCondition(group.getCondition())) continue;
            List<JbangHook> hooks = this.collectJbangHooks(event, (JbangHookProvider)group);
            if (!hooks.isEmpty()) {
                this.context.getLogger().info(RB.$((String)"hooks.jbang.execution", (Object[])new Object[0]), new Object[]{event.getType().name().toLowerCase(Locale.ENGLISH), hooks.size()});
            }
            this.context.getLogger().setPrefix("hooks");
            this.context.getLogger().increaseIndent();
            try {
                for (JbangHook hook : hooks) {
                    String prefix = "hooks";
                    if (StringUtils.isNotBlank((String)hook.getName())) {
                        prefix = prefix + "." + hook.getName();
                    }
                    this.context.getLogger().replacePrefix(prefix);
                    if (!hook.getMatrix().isEmpty()) {
                        for (Map matrixRow : hook.getMatrix().resolve()) {
                            String srcPlatform;
                            if (matrixRow.containsKey("platform") && !this.context.isPlatformSelected(srcPlatform = (String)matrixRow.get("platform"))) continue;
                            this.executeJbangHook(event, hook, this.mergeEnvironment(rootEnv, jbangHooks.getEnvironment(), group.getEnvironment()), matrixRow);
                        }
                        continue;
                    }
                    this.executeJbangHook(event, hook, this.mergeEnvironment(rootEnv, jbangHooks.getEnvironment(), group.getEnvironment()), null);
                }
            }
            finally {
                this.context.getLogger().decreaseIndent();
                this.context.getLogger().restorePrefix();
            }
        }
    }

    private List<JbangHook> collectJbangHooks(ExecutionEvent event, JbangHookProvider jbangHookProvider) {
        ArrayList<JbangHook> hooks = new ArrayList<JbangHook>();
        switch (event.getType()) {
            case BEFORE: {
                hooks.addAll(this.filter(jbangHookProvider.getBefore(), event));
                break;
            }
            case SUCCESS: {
                hooks.addAll(this.filter(jbangHookProvider.getSuccess(), event));
                break;
            }
            case FAILURE: {
                hooks.addAll(this.filter(jbangHookProvider.getFailure(), event));
            }
        }
        return hooks;
    }

    private void executeJbangHook(ExecutionEvent event, JbangHook hook, Map<String, String> env, Map<String, String> matrixRow) {
        TemplateContext additionalContext = Matrix.asTemplateContext(matrixRow);
        Map<String, String> localEnv = new LinkedHashMap<String, String>(env);
        localEnv = this.resolveEnvironment(localEnv, additionalContext);
        String jbangVersion = DefaultVersions.getInstance().getJbangVersion();
        if (StringUtils.isNotBlank((String)hook.getVersion())) {
            jbangVersion = hook.getVersion();
        }
        JBang jbang = new JBang(this.context.asImmutable(), jbangVersion);
        try {
            if (!jbang.setup()) {
                throw new JReleaserException(RB.$((String)"tool_unavailable", (Object[])new Object[]{"jbang"}));
            }
        }
        catch (ToolException e) {
            throw new JReleaserException(RB.$((String)"tool_unavailable", (Object[])new Object[]{"jbang"}), (Throwable)e);
        }
        try {
            ArrayList<String> args = new ArrayList<String>();
            args.add("run");
            args.addAll(hook.getResolvedJbangArgs(this.context));
            args.add(hook.getResolvedScript(this.context));
            args.addAll(hook.getResolvedArgs(this.context));
            jbang.invokeVerbose(this.context.getBasedir(), args);
        }
        catch (CommandException e) {
            throw new JReleaserException(RB.$((String)"ERROR_jbang_hook_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private Collection<? extends Hook> filter(List<? extends Hook> hooks, ExecutionEvent event) {
        ArrayList<Hook> tmp = new ArrayList<Hook>();
        for (Hook hook : hooks) {
            if (!hook.isEnabled() || this.evaluateCondition(hook.getCondition())) continue;
            if (!hook.getFilter().getResolvedIncludes().isEmpty()) {
                if (hook.getFilter().getResolvedIncludes().contains(event.getName()) && this.filterByPlatform(hook)) {
                    tmp.add(hook);
                }
            } else if (this.filterByPlatform(hook)) {
                tmp.add(hook);
            }
            if (!hook.getFilter().getResolvedExcludes().contains(event.getName())) continue;
            tmp.remove(hook);
        }
        return tmp;
    }

    private boolean filterByPlatform(Hook hook) {
        if (hook.getPlatforms().isEmpty()) {
            return true;
        }
        boolean success = true;
        for (String platform : hook.getPlatforms()) {
            boolean exclude = false;
            if (platform.startsWith("!")) {
                exclude = true;
                platform = platform.substring(1);
            }
            success &= exclude != PlatformUtils.isCompatible((String)PlatformUtils.getCurrentFull(), (String)platform);
        }
        return success;
    }

    private Command.Result executeCommand(Path directory, Command command, Map<String, String> env, boolean verbose) throws CommandException {
        Command.Result result = new CommandExecutor(this.context.getLogger(), verbose ? CommandExecutor.Output.VERBOSE : CommandExecutor.Output.DEBUG).environment(env).executeCommand(directory, command);
        if (result.getExitValue() != 0) {
            throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
        }
        return result;
    }

    public static List<String> parseCommand(String str) {
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(str, "\"' ", true);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() > 0) {
            result.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalStateException(RB.$((String)"ERROR_unbalanced_quotes", (Object[])new Object[]{str}));
        }
        return result;
    }
}

