/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.catalog.GithubCataloger;
import org.jreleaser.model.internal.catalog.SlsaCataloger;
import org.jreleaser.model.internal.catalog.sbom.Sbom;
import org.jreleaser.model.internal.catalog.swid.SwidTag;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Domain;

public final class Catalog
extends AbstractActivatable<Catalog>
implements Domain {
    private static final long serialVersionUID = 4460775681741986722L;
    private final Sbom sbom = new Sbom();
    private final GithubCataloger github = new GithubCataloger();
    private final SlsaCataloger slsa = new SlsaCataloger();
    private final Map<String, SwidTag> swid = new LinkedHashMap<String, SwidTag>();
    @JsonIgnore
    private final org.jreleaser.model.api.catalog.Catalog immutable = new org.jreleaser.model.api.catalog.Catalog(){
        private static final long serialVersionUID = -4843558796194675065L;
        private Map<String, ? extends org.jreleaser.model.api.catalog.swid.SwidTag> swid;

        public org.jreleaser.model.api.catalog.sbom.Sbom getSbom() {
            return Catalog.this.sbom.asImmutable();
        }

        public org.jreleaser.model.api.catalog.GithubCataloger getGithub() {
            return Catalog.this.github.asImmutable();
        }

        public org.jreleaser.model.api.catalog.SlsaCataloger getSlsa() {
            return Catalog.this.slsa.asImmutable();
        }

        public Map<String, ? extends org.jreleaser.model.api.catalog.swid.SwidTag> getSwid() {
            if (null == this.swid) {
                this.swid = Catalog.this.swid.values().stream().map(SwidTag::asImmutable).collect(Collectors.toMap(org.jreleaser.model.api.catalog.swid.SwidTag::getName, Function.identity()));
            }
            return this.swid;
        }

        public Active getActive() {
            return Catalog.this.getActive();
        }

        public boolean isEnabled() {
            return Catalog.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Catalog.this.asMap(full));
        }
    };

    public Catalog() {
        this.enabledSet(true);
    }

    public org.jreleaser.model.api.catalog.Catalog asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Catalog source) {
        super.merge(source);
        this.setSbom(source.sbom);
        this.setGithub(source.github);
        this.setSlsa(source.slsa);
        this.setSwid(this.mergeModel(this.swid, source.swid));
    }

    @Override
    public boolean isSet() {
        return super.isSet() || this.sbom.isSet() || this.github.isSet() || this.slsa.isSet() || !this.swid.isEmpty();
    }

    public Sbom getSbom() {
        return this.sbom;
    }

    public void setSbom(Sbom sbom) {
        this.sbom.merge(sbom);
    }

    public GithubCataloger getGithub() {
        return this.github;
    }

    public void setGithub(GithubCataloger github) {
        this.github.merge(github);
    }

    public SlsaCataloger getSlsa() {
        return this.slsa;
    }

    public void setSlsa(SlsaCataloger slsa) {
        this.slsa.merge(slsa);
    }

    public Map<String, SwidTag> getSwid() {
        return this.swid;
    }

    public void setSwid(Map<String, SwidTag> swid) {
        this.swid.clear();
        this.swid.putAll(swid);
    }

    public void addSwid(SwidTag swid) {
        this.swid.put(swid.getName(), swid);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.getActive());
        map.putAll(this.github.asMap(full));
        map.put("sbom", this.sbom.asMap(full));
        map.putAll(this.slsa.asMap(full));
        List swid = this.swid.values().stream().map(d -> d.asMap(full)).filter(m -> !m.isEmpty()).collect(Collectors.toList());
        if (!swid.isEmpty()) {
            map.put("swid", swid);
        }
        return map;
    }
}

