/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorGeneralConfigPart;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.TypeScope;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;

public class SimpleTypeModule
implements Module {
    private final Map<Class<?>, SchemaKeyword> fixedJsonSchemaTypes = new HashMap();
    private final Set<Class<?>> typesWithStandardFormats = new HashSet();
    private final Map<Class<?>, String> formatValues = new HashMap();

    public static SimpleTypeModule forPrimitiveTypes() {
        SimpleTypeModule module = new SimpleTypeModule();
        module.withEmptySchema(Object.class);
        Stream.of(String.class, Character.class, Character.TYPE, CharSequence.class, Byte.class, Byte.TYPE).forEach(module::withStringType);
        Stream.of(Boolean.class, Boolean.TYPE).forEach(module::withBooleanType);
        Stream.of(Integer.class, Integer.TYPE).forEach(javaType -> module.withIntegerType((Class<?>)javaType, "int32"));
        Stream.of(Long.class, Long.TYPE).forEach(javaType -> module.withIntegerType((Class<?>)javaType, "int64"));
        Stream.of(Short.class, Short.TYPE).forEach(module::withIntegerType);
        Stream.of(Double.class, Double.TYPE).forEach(javaType -> module.withNumberType((Class<?>)javaType, "double"));
        Stream.of(Float.class, Float.TYPE).forEach(javaType -> module.withNumberType((Class<?>)javaType, "float"));
        return module;
    }

    public static SimpleTypeModule forPrimitiveAndAdditionalTypes() {
        SimpleTypeModule module = SimpleTypeModule.forPrimitiveTypes();
        module.withStandardStringType(LocalDate.class, "date");
        Stream.of(LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, Instant.class, Date.class, Calendar.class).forEach(javaType -> module.withStandardStringType((Class<?>)javaType, "date-time"));
        Stream.of(LocalTime.class, OffsetTime.class).forEach(javaType -> module.withStandardStringType((Class<?>)javaType, "time"));
        Stream.of(Duration.class, Period.class).forEach(javaType -> module.withStandardStringType((Class<?>)javaType, "duration"));
        module.withStandardStringType(UUID.class, "uuid");
        module.withStandardStringType(URI.class, "uri");
        module.withStringType(ZoneId.class);
        module.withIntegerType(BigInteger.class);
        Stream.of(BigDecimal.class, Number.class).forEach(module::withNumberType);
        return module;
    }

    private SimpleTypeModule with(Class<?> javaType, SchemaKeyword jsonSchemaTypeValue, String openApiFormat) {
        this.fixedJsonSchemaTypes.put(javaType, jsonSchemaTypeValue);
        if (openApiFormat != null) {
            this.formatValues.put(javaType, openApiFormat);
        }
        return this;
    }

    public final SimpleTypeModule withEmptySchema(Class<?> javaType) {
        return this.with(javaType, SchemaKeyword.TAG_TYPE_NULL, null);
    }

    @Deprecated
    public final SimpleTypeModule withObjectType(Class<?> javaType) {
        return this.with(javaType, SchemaKeyword.TAG_TYPE_OBJECT, null);
    }

    public final SimpleTypeModule withStringType(Class<?> javaType) {
        return this.withStringType(javaType, null);
    }

    public final SimpleTypeModule withStringType(Class<?> javaType, String openApiFormat) {
        return this.with(javaType, SchemaKeyword.TAG_TYPE_STRING, openApiFormat);
    }

    public final SimpleTypeModule withStandardStringType(Class<?> javaType, String standardFormat) {
        this.typesWithStandardFormats.add(javaType);
        return this.withStringType(javaType, standardFormat);
    }

    public final SimpleTypeModule withBooleanType(Class<?> javaType) {
        return this.with(javaType, SchemaKeyword.TAG_TYPE_BOOLEAN, null);
    }

    public final SimpleTypeModule withIntegerType(Class<?> javaType) {
        return this.withIntegerType(javaType, null);
    }

    public final SimpleTypeModule withIntegerType(Class<?> javaType, String openApiFormat) {
        return this.with(javaType, SchemaKeyword.TAG_TYPE_INTEGER, openApiFormat);
    }

    public final SimpleTypeModule withNumberType(Class<?> javaType) {
        return this.withNumberType(javaType, null);
    }

    public final SimpleTypeModule withNumberType(Class<?> javaType, String openApiFormat) {
        return this.with(javaType, SchemaKeyword.TAG_TYPE_NUMBER, openApiFormat);
    }

    private Boolean isNullableType(MemberScope<?, ?> fieldOrMethod) {
        return fieldOrMethod.getType().isPrimitive() ? Boolean.FALSE : null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withNullableCheck(this::isNullableType);
        builder.forMethods().withNullableCheck(this::isNullableType);
        ((SchemaGeneratorGeneralConfigPart)((SchemaGeneratorGeneralConfigPart)builder.forTypesInGeneral().withAdditionalPropertiesResolver(this::resolveAdditionalProperties)).withPatternPropertiesResolver(this::resolvePatternProperties)).withCustomDefinitionProvider(new SimpleTypeDefinitionProvider());
    }

    private Type resolveAdditionalProperties(TypeScope scope) {
        if (this.shouldHaveEmptySchema(scope)) {
            return Object.class;
        }
        return null;
    }

    private Map<String, Type> resolvePatternProperties(TypeScope scope) {
        if (this.shouldHaveEmptySchema(scope)) {
            return Collections.emptyMap();
        }
        return null;
    }

    private boolean shouldHaveEmptySchema(TypeScope scope) {
        return scope.getType() == null || SchemaKeyword.TAG_TYPE_NULL == this.fixedJsonSchemaTypes.get(scope.getType().getErasedType());
    }

    private final class SimpleTypeDefinitionProvider
    implements CustomDefinitionProviderV2 {
        private SimpleTypeDefinitionProvider() {
        }

        @Override
        public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
            String formatValue;
            if (!javaType.getTypeParameters().isEmpty()) {
                return null;
            }
            SchemaKeyword jsonSchemaTypeValue = (SchemaKeyword)((Object)SimpleTypeModule.this.fixedJsonSchemaTypes.get(javaType.getErasedType()));
            if (jsonSchemaTypeValue == null) {
                return null;
            }
            ObjectNode customSchema = context.getGeneratorConfig().createObjectNode();
            if (jsonSchemaTypeValue != SchemaKeyword.TAG_TYPE_NULL) {
                customSchema.put(context.getKeyword(SchemaKeyword.TAG_TYPE), context.getKeyword(jsonSchemaTypeValue));
            }
            if (this.shouldAddFormatTag(javaType, context.getGeneratorConfig()) && (formatValue = (String)SimpleTypeModule.this.formatValues.get(javaType.getErasedType())) != null) {
                customSchema.put(context.getKeyword(SchemaKeyword.TAG_FORMAT), formatValue);
            }
            return new CustomDefinition(customSchema, CustomDefinition.DefinitionType.INLINE, CustomDefinition.AttributeInclusion.YES);
        }

        private boolean shouldAddFormatTag(ResolvedType javaType, SchemaGeneratorConfig config) {
            return config.shouldIncludeExtraOpenApiFormatValues() || config.shouldIncludeStandardFormatValues() && SimpleTypeModule.this.typesWithStandardFormats.contains(javaType.getErasedType());
        }
    }
}

