/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.MastodonAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class MastodonAnnouncerValidator {
    private MastodonAnnouncerValidator() {
    }

    public static void validateMastodon(JReleaserContext context, MastodonAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.mastodon");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.mastodon", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setHost(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.mastodon.host", "mastodon.host"}), "announce.mastodon.host", announcer.getHost(), errors));
        announcer.setAccessToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.mastodon.access.token", "MASTODON_ACCESS_TOKEN"}), "announce.mastodon.accessToken", announcer.getAccessToken(), errors, context.isDryrun()));
        if (StringUtils.isNotBlank((String)announcer.getStatusTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getStatusTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"mastodon.statusTemplate", announcer.getStatusTemplate()}));
        }
        if (StringUtils.isBlank((String)announcer.getStatus()) && StringUtils.isBlank((String)announcer.getStatusTemplate()) && announcer.getStatuses().isEmpty()) {
            announcer.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        Validator.validateTimeout(announcer);
    }
}

