/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.SftpUploader;
import org.jreleaser.model.validation.SshValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SftpUploaderValidator
extends Validator {
    public static void validateSftpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("sftp");
        Map<String, SftpUploader> sftp = context.getModel().getUpload().getSftp();
        for (Map.Entry<String, SftpUploader> e : sftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) {
                SftpUploaderValidator.validateSftpUploader(context, mode, e.getValue(), new Errors());
                continue;
            }
            SftpUploaderValidator.validateSftpUploader(context, mode, e.getValue(), errors);
        }
    }

    private static void validateSftpUploader(JReleaserContext context, JReleaserContext.Mode mode, SftpUploader sftp, Errors errors) {
        context.getLogger().debug("sftp.{}", new Object[]{sftp.getName()});
        if (!sftp.isActiveSet()) {
            sftp.setActive(Active.NEVER);
        }
        if (!sftp.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!(sftp.isArtifacts().booleanValue() || sftp.isFiles().booleanValue() || sftp.isSignatures().booleanValue())) {
            sftp.disable();
            return;
        }
        SshValidator.validateSsh(context, sftp, sftp.getName(), "SFTP", sftp.getType(), errors);
        if (StringUtils.isBlank((String)sftp.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"sftp." + sftp.getName() + ".path"}));
        }
        SftpUploaderValidator.validateTimeout(sftp);
    }
}

