/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.FtpUploader;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class FtpUploaderValidator
extends Validator {
    public static void validateFtpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        context.getLogger().debug("ftp");
        Map<String, FtpUploader> ftp = context.getModel().getUpload().getFtp();
        for (Map.Entry<String, FtpUploader> e : ftp.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) {
                FtpUploaderValidator.validateFtp(context, mode, e.getValue(), new Errors());
                continue;
            }
            FtpUploaderValidator.validateFtp(context, mode, e.getValue(), errors);
        }
    }

    private static void validateFtp(JReleaserContext context, JReleaserContext.Mode mode, FtpUploader ftp, Errors errors) {
        context.getLogger().debug("ftp.{}", new Object[]{ftp.getName()});
        if (!ftp.isActiveSet()) {
            ftp.setActive(Active.NEVER);
        }
        if (!ftp.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!(ftp.isArtifacts().booleanValue() || ftp.isFiles().booleanValue() || ftp.isSignatures().booleanValue())) {
            ftp.disable();
            return;
        }
        ftp.setUsername(FtpUploaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_USERNAME", "ftp.username", ftp.getUsername(), errors, context.isDryrun()));
        ftp.setPassword(FtpUploaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_PASSWORD", "ftp.password", ftp.getPassword(), errors, context.isDryrun()));
        ftp.setHost(FtpUploaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_HOST", "ftp.host", ftp.getHost(), errors, context.isDryrun()));
        ftp.setPort(FtpUploaderValidator.checkProperty(context, "FTP_" + Env.toVar((String)ftp.getName()) + "_PORT", "ftp.port", ftp.getPort(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)ftp.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"ftp." + ftp.getName() + ".path"}));
        }
        FtpUploaderValidator.validateTimeout(ftp);
    }
}

