/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.rules.Rule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;

public class RuleFactory {
    private static final Logger LOGGER = Logger.getLogger(RuleFactory.class.getName());
    public static final RuleFactory instance = new RuleFactory();
    private final Map<String, Rule> rules = new HashMap<String, Rule>();

    public Rule getRule(String id) {
        if (this.rules.containsKey(id)) {
            return this.rules.get(id);
        }
        try {
            ServiceLoader<Rule> loader = ServiceLoader.load(Rule.class, this.getClass().getClassLoader());
            Optional<Rule> found = StreamSupport.stream(loader.spliterator(), false).filter(rule -> id.equals(rule.getId())).findFirst();
            if (found.isPresent()) {
                Rule rule2 = found.get();
                this.rules.put(rule2.getId(), rule2);
                return rule2;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unexpected error loading Rule instances", e);
        }
        return null;
    }

    private RuleFactory() {
    }
}

