/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.util;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.Files;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Glob;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.SdkmanAnnouncer;
import org.jreleaser.model.Upload;
import org.jreleaser.model.Uploader;
import org.jreleaser.util.FileType;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Artifacts {
    private static final String DOWNLOAD_URL_SUFFIX = "DownloadUrl";
    private static final String DOWNLOAD_URL_KEY = "downloadUrl";
    private static final String DOWNLOAD_URL_FROM_KEY = "downloadUrlFrom";

    public static String resolveForArtifact(String input, JReleaserContext context) {
        return Templates.resolveTemplate((String)input, context.fullProps());
    }

    public static String resolveForArtifact(String input, JReleaserContext context, Artifact artifact) {
        return Templates.resolveTemplate((String)input, Artifacts.artifactProps(artifact, context.fullProps()));
    }

    public static String resolveForGlob(String input, JReleaserContext context, Glob glob) {
        return Templates.resolveTemplate((String)input, Artifacts.globProps(glob, context.fullProps()));
    }

    public static String resolveForFileSet(String input, JReleaserContext context, FileSet fileSet) {
        return Templates.resolveTemplate((String)input, Artifacts.fileSetProps(fileSet, context.fullProps()));
    }

    public static String resolveForArtifact(String input, JReleaserContext context, Artifact artifact, Distribution distribution) {
        Map<String, Object> props = context.fullProps();
        props.putAll(distribution.props());
        props = Artifacts.artifactProps(artifact, props);
        return Templates.resolveTemplate((String)input, props);
    }

    public static String resolveForArtifact(String input, JReleaserContext context, Artifact artifact, Assembler assembler) {
        Map<String, Object> props = context.fullProps();
        props.putAll(assembler.props());
        props = Artifacts.artifactProps(artifact, props);
        return Templates.resolveTemplate((String)input, props);
    }

    public static Map<String, Object> artifactProps(Artifact artifact, Map<String, Object> props) {
        if (artifact.getEffectivePath() != null) {
            return Artifacts.resolvedArtifactProps(artifact, props);
        }
        return Artifacts.unresolvedArtifactProps(artifact, props);
    }

    public static Map<String, Object> artifactProps(Artifact artifact, Distribution distribution, Map<String, Object> props) {
        if (artifact.getEffectivePath() != null) {
            return Artifacts.resolvedArtifactProps(artifact, distribution, props);
        }
        return Artifacts.unresolvedArtifactProps(artifact, props);
    }

    public static Map<String, Object> unresolvedArtifactProps(Artifact artifact, Map<String, Object> props) {
        props.putAll(artifact.getExtraProperties());
        props.putAll(artifact.getResolvedExtraProperties());
        props.put("platform", artifact.getPlatform());
        props.put("artifactPlatform", artifact.getPlatform());
        return props;
    }

    public static Map<String, Object> resolvedArtifactProps(Artifact artifact, Map<String, Object> props) {
        props.putAll(artifact.getExtraProperties());
        props.putAll(artifact.getResolvedExtraProperties());
        String artifactFile = artifact.getEffectivePath().getFileName().toString();
        String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
        props.put("artifactFile", artifactFile);
        props.put("artifactFileName", artifactFileName);
        if (!artifactFile.equals(artifactFileName)) {
            String artifactExtension = artifactFile.substring(artifactFileName.length());
            String artifactFileFormat = artifactExtension.substring(1);
            props.put("artifactFileExtension", artifactExtension);
            props.put("artifactFileFormat", artifactFileFormat);
        }
        String artifactName = "";
        String projectVersion = (String)props.get("projectEffectiveVersion");
        if (StringUtils.isNotBlank((String)projectVersion) && artifactFileName.contains(projectVersion)) {
            artifactName = artifactFileName.substring(0, artifactFileName.indexOf(projectVersion));
            if (artifactName.endsWith("-")) {
                artifactName = artifactName.substring(0, artifactName.length() - 1);
            }
            props.put("artifactVersion", projectVersion);
        }
        projectVersion = (String)props.get("projectVersion");
        if (StringUtils.isBlank((String)artifactName) && StringUtils.isNotBlank((String)projectVersion) && artifactFileName.contains(projectVersion)) {
            artifactName = artifactFileName.substring(0, artifactFileName.indexOf(projectVersion));
            if (artifactName.endsWith("-")) {
                artifactName = artifactName.substring(0, artifactName.length() - 1);
            }
            props.put("artifactVersion", projectVersion);
        }
        props.put("artifactName", artifactName);
        String platform = artifact.getPlatform();
        if (StringUtils.isNotBlank((String)platform)) {
            props.put("platform", platform);
            props.put("artifactPlatform", platform);
            if (platform.contains("-")) {
                String[] parts = platform.split("-");
                props.put("artifactOs", parts[0]);
                props.put("artifactArch", parts[1]);
            }
        }
        return props;
    }

    public static Map<String, Object> resolvedArtifactProps(Artifact artifact, Distribution distribution, Map<String, Object> props) {
        String platformReplaced;
        props.putAll(artifact.getExtraProperties());
        props.putAll(artifact.getResolvedExtraProperties());
        String artifactFile = artifact.getEffectivePath().getFileName().toString();
        String artifactFileName = StringUtils.getFilename((String)artifactFile, (Collection)FileType.getSupportedExtensions());
        props.put("artifactFile", artifactFile);
        props.put("artifactFileName", artifactFileName);
        props.put("distributionArtifactFile", artifactFile);
        props.put("distributionArtifactFileName", artifactFileName);
        if (!artifactFile.equals(artifactFileName)) {
            String artifactExtension = artifactFile.substring(artifactFileName.length());
            String artifactFileFormat = artifactExtension.substring(1);
            props.put("artifactFileExtension", artifactExtension);
            props.put("artifactFileFormat", artifactFileFormat);
            props.put("distributionArtifactFileExtension", artifactExtension);
            props.put("distributionArtifactFileFormat", artifactFileFormat);
            props.put("distributionArtifactArchiveFormat", artifactFileFormat);
        }
        String artifactName = "";
        String projectVersion = (String)props.get("projectEffectiveVersion");
        if (StringUtils.isNotBlank((String)projectVersion) && artifactFileName.contains(projectVersion)) {
            artifactName = artifactFileName.substring(0, artifactFileName.indexOf(projectVersion));
            if (artifactName.endsWith("-")) {
                artifactName = artifactName.substring(0, artifactName.length() - 1);
            }
            props.put("artifactVersion", projectVersion);
        }
        projectVersion = (String)props.get("projectVersion");
        if (StringUtils.isBlank((String)artifactName) && StringUtils.isNotBlank((String)projectVersion) && artifactFileName.contains(projectVersion)) {
            artifactName = artifactFileName.substring(0, artifactFileName.indexOf(projectVersion));
            if (artifactName.endsWith("-")) {
                artifactName = artifactName.substring(0, artifactName.length() - 1);
            }
            props.put("artifactVersion", projectVersion);
        }
        props.put("artifactName", artifactName);
        String platform = artifact.getPlatform();
        if (StringUtils.isNotBlank((String)platform)) {
            props.put("platform", platform);
            props.put("artifactPlatform", platform);
            if (platform.contains("-")) {
                String[] parts = platform.split("-");
                props.put("artifactOs", parts[0]);
                props.put("artifactArch", parts[1]);
            }
        }
        if (StringUtils.isNotBlank((String)(platformReplaced = distribution.getPlatform().applyReplacements(platform)))) {
            props.put("artifactPlatformReplaced", platformReplaced);
        }
        if (StringUtils.isNotBlank((String)platform)) {
            props.put("distributionArtifactPlatform", platform);
        }
        if (StringUtils.isNotBlank((String)platformReplaced)) {
            props.put("distributionArtifactPlatformReplaced", platformReplaced);
        }
        return props;
    }

    public static Map<String, Object> globProps(Glob glob, Map<String, Object> props) {
        props.putAll(glob.getExtraProperties());
        props.putAll(glob.getResolvedExtraProperties());
        return props;
    }

    public static Map<String, Object> fileSetProps(FileSet fileSet, Map<String, Object> props) {
        props.putAll(fileSet.getExtraProperties());
        props.putAll(fileSet.getResolvedExtraProperties());
        return props;
    }

    public static String resolveDownloadUrl(JReleaserContext context, String packagerName, Distribution distribution, Artifact artifact) {
        List<String> keys = Collections.singletonList("skip" + StringUtils.capitalize((String)packagerName));
        if (Artifacts.isSkip(artifact, keys)) {
            return "";
        }
        String downloadUrl = artifact.getExtraProperty(packagerName + DOWNLOAD_URL_SUFFIX);
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = artifact.getExtraProperty(DOWNLOAD_URL_KEY);
        }
        Object packager = distribution.findPackager(packagerName);
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = packager.getDownloadUrl();
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = distribution.getExtraProperty(packagerName + DOWNLOAD_URL_SUFFIX);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = distribution.getExtraProperty(DOWNLOAD_URL_KEY);
        }
        GitService service = context.getModel().getRelease().getGitService();
        if (StringUtils.isBlank((String)downloadUrl) && !service.isSkipRelease() && service.isArtifacts().booleanValue() && service.resolveUploadAssetsEnabled(context.getModel().getProject())) {
            downloadUrl = service.getDownloadUrl();
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, artifact, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, packager, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, distribution, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            context.getLogger().warn(RB.$((String)"ERROR_artifacts_download_url_missing", (Object[])new Object[]{artifact.getEffectivePath(context, distribution).getFileName().toString(), service.getServiceName()}));
            downloadUrl = service.getDownloadUrl();
        }
        Map<String, Object> props = context.fullProps();
        props.putAll(packager.getResolvedExtraProperties());
        props.putAll(distribution.props());
        Artifacts.artifactProps(artifact, distribution, props);
        return Templates.resolveTemplate((String)downloadUrl, props);
    }

    public static String resolveDownloadUrl(JReleaserContext context, SdkmanAnnouncer announcer, Distribution distribution, Artifact artifact) {
        String packager = "sdkman";
        List<String> keys = Collections.singletonList("skip" + StringUtils.capitalize((String)packager));
        if (Artifacts.isSkip(artifact, keys)) {
            return "";
        }
        String downloadUrl = artifact.getExtraProperty(packager + DOWNLOAD_URL_SUFFIX);
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = artifact.getExtraProperty(DOWNLOAD_URL_KEY);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = announcer.getDownloadUrl();
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = distribution.getExtraProperty(packager + DOWNLOAD_URL_SUFFIX);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = distribution.getExtraProperty(DOWNLOAD_URL_KEY);
        }
        GitService service = context.getModel().getRelease().getGitService();
        if (StringUtils.isBlank((String)downloadUrl) && !service.isSkipRelease() && service.isArtifacts().booleanValue() && service.resolveUploadAssetsEnabled(context.getModel().getProject())) {
            downloadUrl = service.getDownloadUrl();
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, artifact, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, announcer, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            downloadUrl = Artifacts.resolveDownloadUrlFromUploader(context, distribution, artifact);
        }
        if (StringUtils.isBlank((String)downloadUrl)) {
            context.getLogger().warn(RB.$((String)"ERROR_artifacts_download_url_missing", (Object[])new Object[]{artifact.getEffectivePath(context, distribution).getFileName().toString()}), new Object[]{service.getServiceName()});
            downloadUrl = service.getDownloadUrl();
        }
        Map<String, Object> props = context.fullProps();
        props.putAll(announcer.getResolvedExtraProperties());
        props.putAll(distribution.props());
        Artifacts.artifactProps(artifact, distribution, props);
        return Templates.resolveTemplate((String)downloadUrl, props);
    }

    private static String resolveDownloadUrlFromUploader(JReleaserContext context, ExtraProperties props, Artifact artifact) {
        Upload upload = context.getModel().getUpload();
        String coords = props.getExtraProperty(DOWNLOAD_URL_FROM_KEY);
        if (StringUtils.isBlank((String)coords)) {
            for (Uploader up : upload.findAllActiveUploaders()) {
                List<String> keys = up.resolveSkipKeys();
                String key = up.getType() + StringUtils.capitalize((String)up.getName()) + "Path";
                if (!artifact.getExtraProperties().containsKey(key) || Artifacts.isSkip(props, keys)) continue;
                return up.getResolvedDownloadUrl(context, artifact);
            }
            return null;
        }
        String[] parts = coords.split(":");
        if (parts.length != 2) {
            return null;
        }
        Optional<? extends Uploader> uploader = upload.getActiveUploader(parts[0], parts[1]);
        if (uploader.isPresent()) {
            List<String> keys = uploader.get().resolveSkipKeys();
            if (!Artifacts.isSkip(props, keys)) {
                return uploader.get().getResolvedDownloadUrl(context, artifact);
            }
        } else {
            for (Uploader up : upload.findAllActiveUploaders()) {
                List<String> keys = up.resolveSkipKeys();
                String key = up.getType() + StringUtils.capitalize((String)up.getName()) + "Path";
                if (!artifact.getExtraProperties().containsKey(key) || Artifacts.isSkip(props, keys)) continue;
                return up.getResolvedDownloadUrl(context, artifact);
            }
        }
        return null;
    }

    private static boolean isSkip(ExtraProperties props, List<String> keys) {
        for (String key : keys) {
            if (!props.extraPropertyIsTrue(key)) continue;
            return true;
        }
        return false;
    }

    public static Path checkAndCopyFile(JReleaserContext context, Path src, Path dest) throws JReleaserException {
        if (null == dest) {
            return src;
        }
        if (!java.nio.file.Files.exists(dest, new LinkOption[0])) {
            context.getLogger().debug(RB.$((String)"artifacts.not.exists", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(dest)});
            Artifacts.copyFile(context, src, dest);
        } else if (src.toFile().lastModified() > dest.toFile().lastModified()) {
            context.getLogger().debug(RB.$((String)"artifacts.newer", (Object[])new Object[0]), new Object[]{context.relativizeToBasedir(src), context.relativizeToBasedir(dest)});
            Artifacts.copyFile(context, src, dest);
        }
        return dest;
    }

    public static void copyFile(JReleaserContext context, Path src, Path dest) throws JReleaserException {
        try {
            java.nio.file.Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            java.nio.file.Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_artifacts_unexpected_error_copying", (Object[])new Object[]{context.relativizeToBasedir(src), context.relativizeToBasedir(dest)}));
        }
    }

    public static Set<Artifact> resolveFiles(JReleaserContext context) throws JReleaserException {
        Files files = context.getModel().getFiles();
        LinkedHashSet<Artifact> paths = new LinkedHashSet<Artifact>();
        if (!files.isEnabled()) {
            return paths;
        }
        if (files.arePathsResolved()) {
            return files.getPaths();
        }
        for (Artifact artifact : files.getArtifacts()) {
            if (!context.isPlatformSelected(artifact)) continue;
            artifact.activate();
            artifact.getEffectivePath(context);
            paths.add(artifact);
        }
        for (Glob glob : files.getGlobs()) {
            for (Artifact artifact : glob.getResolvedArtifacts(context)) {
                if (!artifact.isActive()) continue;
                paths.add(artifact);
            }
        }
        files.setPaths(Artifact.sortArtifacts(paths));
        return files.getPaths();
    }

    public static Set<Artifact> resolveFiles(JReleaserLogger logger, Path basedir, Collection<String> globs) throws JReleaserException {
        if (null == globs || globs.isEmpty()) {
            return Collections.emptySet();
        }
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String glob : globs) {
            matchers.add(fileSystem.getPathMatcher(glob));
        }
        GlobResolver resolver = new GlobResolver(logger, basedir, matchers);
        try {
            java.nio.file.Files.walkFileTree(basedir, resolver);
            if (resolver.failed) {
                throw new JReleaserException(RB.$((String)"ERROR_artifacts_glob_resolution", (Object[])new Object[0]));
            }
            return Artifact.sortArtifacts(resolver.artifacts);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_artifacts_unexpected_error_globs", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static Set<Artifact> resolveFiles(JReleaserLogger logger, Map<String, Object> props, Path basedir, Collection<String> globs) throws JReleaserException {
        if (null == globs || globs.isEmpty()) {
            return Collections.emptySet();
        }
        FileSystem fileSystem = FileSystems.getDefault();
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String glob : globs) {
            matchers.add(fileSystem.getPathMatcher(Templates.resolveTemplate((String)glob, props)));
        }
        GlobResolver resolver = new GlobResolver(logger, basedir, matchers);
        try {
            java.nio.file.Files.walkFileTree(basedir, resolver);
            if (resolver.failed) {
                throw new JReleaserException(RB.$((String)"ERROR_artifacts_glob_resolution", (Object[])new Object[0]));
            }
            return Artifact.sortArtifacts(resolver.artifacts);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_artifacts_unexpected_error_globs", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static Set<Artifact> resolveFiles(JReleaserContext context, Collection<String> globs) throws JReleaserException {
        return Artifacts.resolveFiles(context, context.getBasedir(), globs);
    }

    public static Set<Artifact> resolveFiles(JReleaserContext context, Path directory, Collection<String> globs) throws JReleaserException {
        return Artifacts.resolveFiles(context.getLogger(), context.fullProps(), directory, globs);
    }

    private static class GlobResolver
    extends SimpleFileVisitor<Path> {
        private final JReleaserLogger logger;
        private final List<PathMatcher> matchers;
        private final Path basedir;
        private final Set<Artifact> artifacts = new LinkedHashSet<Artifact>();
        private boolean failed;

        private GlobResolver(JReleaserLogger logger, Path basedir, List<PathMatcher> matchers) {
            this.logger = logger;
            this.matchers = matchers;
            this.basedir = basedir;
        }

        private void match(Path path) {
            if (this.matchers.stream().anyMatch(matcher -> matcher.matches(path))) {
                this.artifacts.add(Artifact.of(path));
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.match(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            this.failed = true;
            this.logger.error(RB.$((String)"ERROR_artifacts_unexpected_error_path", (Object[])new Object[0]), new Object[]{this.basedir.toAbsolutePath().relativize(file.toAbsolutePath()), e});
            return FileVisitResult.CONTINUE;
        }
    }
}

