/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.sign;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.sdk.tool.Tool;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.command.Command;
import org.jreleaser.util.command.CommandException;
import org.jreleaser.util.command.CommandExecutor;
import org.jreleaser.util.io.RepeatableInputStream;
import org.jreleaser.util.signing.SigningException;

public class Cosign {
    private final JReleaserContext context;
    private final Tool cosign;

    public Cosign(JReleaserContext context, String version) {
        StringUtils.requireNonBlank((String)version, (String)"'version' must not be blank");
        this.context = context;
        this.cosign = new Tool(context.getLogger(), "cosign", version, PlatformUtils.getCurrentFull());
    }

    public boolean setup() throws SigningException {
        if (!this.cosign.verify()) {
            if (this.cosign.isEnabled()) {
                try {
                    this.cosign.download();
                }
                catch (Exception e) {
                    throw new SigningException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
                }
                if (this.cosign.verify()) {
                    return true;
                }
            }
            this.context.getLogger().warn(RB.$((String)"cosign_verify_error", (Object[])new Object[]{this.cosign.getVersion()}));
            return false;
        }
        return true;
    }

    public boolean checkPassword(Path keyFile, byte[] password) {
        ByteArrayInputStream in = new ByteArrayInputStream(password);
        Command command = this.cosign.asCommand().arg("public-key").arg("--key").arg(keyFile.toAbsolutePath().toString());
        try {
            this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), true).executeCommandWithInput(command, (InputStream)in));
            return true;
        }
        catch (CommandException e) {
            this.context.getLogger().debug(RB.$((String)"ERROR_password_incorrect", (Object[])new Object[0]));
            return false;
        }
    }

    public Path generateKeyPair(byte[] password) throws SigningException {
        ByteArrayInputStream in = new ByteArrayInputStream(password);
        Command command = this.cosign.asCommand().arg("generate-key-pair");
        Path homeDir = this.resolveJReleaserHomeDir();
        try {
            this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), true).executeCommandWithInput(homeDir, command, (InputStream)new RepeatableInputStream((InputStream)in)));
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_generate_key_pair", (Object[])new Object[0]), (Throwable)e);
        }
        this.context.getLogger().info(RB.$((String)"cosign_generated_keys_at", (Object[])new Object[0]), new Object[]{homeDir.toAbsolutePath()});
        return homeDir.resolve("cosign.key");
    }

    public void signBlob(Path keyFile, byte[] password, Path input, Path destinationDir) throws SigningException {
        this.context.getLogger().info("{}", new Object[]{this.context.relativizeToBasedir(input)});
        ByteArrayInputStream in = new ByteArrayInputStream(password);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Command command = this.cosign.asCommand().arg("sign-blob").arg("--key").arg(keyFile.toAbsolutePath().toString()).arg(input.toAbsolutePath().toString());
        try {
            this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), true).executeCommandWithInputCapturing(command, (InputStream)in, (OutputStream)out));
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input.toAbsolutePath()}), (Throwable)e);
        }
        try {
            Path signature = destinationDir.resolve(input.getFileName() + ".sig");
            Files.write(signature, out.toByteArray(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input}), (Throwable)e);
        }
    }

    public void verifyBlob(Path keyFile, Path signature, Path input) throws SigningException {
        this.context.getLogger().debug("{}", new Object[]{this.context.relativizeToBasedir(signature)});
        Command command = this.cosign.asCommand().arg("verify-blob").arg("--key").arg(keyFile.toAbsolutePath().toString()).arg("--signature").arg(signature.toAbsolutePath().toString()).arg(input.toAbsolutePath().toString());
        try {
            this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), true).executeCommand(command));
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{this.context.relativizeToBasedir(signature)}), (Throwable)e);
        }
    }

    private void executeCommand(CommandExecution execution) throws CommandException {
        int exitValue = execution.execute();
        if (exitValue != 0) {
            throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{exitValue}));
        }
    }

    private Path resolveJReleaserHomeDir() {
        String home = System.getenv("JRELEASER_USER_HOME");
        if (StringUtils.isBlank((String)home)) {
            home = System.getProperty("user.home") + File.separator + ".jreleaser";
        }
        return Paths.get(home, new String[0]);
    }

    static interface CommandExecution {
        public int execute() throws CommandException;
    }
}

