/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractAnnouncer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Templates;

public class Telegram
extends AbstractAnnouncer {
    public static final String NAME = "telegram";
    public static final String TELEGRAM_TOKEN = "TELEGRAM_TOKEN";
    public static final String TELEGRAM_CHAT_ID = "TELEGRAM_CHAT_ID";
    private String token;
    private String chatId;
    private String message;
    private String messageTemplate;

    public Telegram() {
        super(NAME);
    }

    void setAll(Telegram telegram) {
        super.setAll(telegram);
        this.token = telegram.token;
        this.chatId = telegram.chatId;
        this.message = telegram.message;
        this.messageTemplate = telegram.messageTemplate;
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.props();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.props();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getGitService().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedToken() {
        return Env.resolve((String)TELEGRAM_TOKEN, (String)this.token);
    }

    public String getResolvedChatId() {
        return Env.resolve((String)TELEGRAM_CHAT_ID, (String)this.chatId);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(Map<String, Object> props, boolean full) {
        props.put("token", StringUtils.isNotBlank((String)this.getResolvedToken()) ? "************" : "**unset**");
        props.put("chatId", StringUtils.isNotBlank((String)this.getResolvedChatId()) ? "************" : "**unset**");
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

