/*
 * (C) Copyright IBM Corp. 2002
 */
// $Id: VM_ThreadEventWaitDataVisitor.java,v 1.2 2003/02/05 20:19:22 dgrove-oss Exp $

package com.ibm.JikesRVM;

/**
 * Visitor class for <code>VM_ThreadEventWaitData</code> objects.
 * Subclasses can recover the actual type of an object from a
 * <code>VM_ThreadEventWaitData</code> reference.
 *
 * @author David Hovemeyer
 */
public abstract class VM_ThreadEventWaitDataVisitor implements VM_Uninterruptible {

  /**
   * Visit a VM_ThreadIOWaitData object.
   */
  public abstract void visitThreadIOWaitData(VM_ThreadIOWaitData waitData);

  /**
   * Visit a VM_ThreadProcessWaitData object.
   */
  public abstract void visitThreadProcessWaitData(VM_ThreadProcessWaitData waitData);

}
