/*
 * (C) Copyright IBM Corp 2002
 */
//$Id: OSR_OnStackReplacementEvent.java,v 1.6 2004/04/23 15:30:38 dgrove-oss Exp $

package com.ibm.JikesRVM.adaptive;

import com.ibm.JikesRVM.*;
import com.ibm.JikesRVM.classloader.*;
import com.ibm.JikesRVM.opt.*;
/**
 * Event generated by a thread aware of on-stack-replacement request.
 * The event is feed to the controller with suspended thread, and hot
 * method id. Since it does not need to go through analytic model, it does 
 * not extend the VM_HotMethodEvent.
 * 
 * @author Feng Qian
 */

public final class OSR_OnStackReplacementEvent
  implements VM_ControllerInputEvent {

  /* the suspended thread. */
  public VM_Thread suspendedThread;

  /* remember where it comes from */
  public int whereFrom;

  /* the compiled method id */
  public int CMID;

  /* the threadSwithFrom fp offset */
  public int tsFromFPoff;
  
  /* the osr method's fp offset */
  public int ypTakenFPoff;

  public OSR_OnStackReplacementEvent() {}

  /** 
   * This function will generate a controller plan and 
   * inserted in the recompilation queue. 
   */
  public void process() {
    
    VM_CompiledMethod compiledMethod = VM_CompiledMethods.getCompiledMethod(CMID);
    
    VM_NormalMethod todoMethod = (VM_NormalMethod)compiledMethod.getMethod();

    double priority;
    OPT_Options options;
    OPT_OptimizationPlanElement[] optimizationPlan;
  
    VM_ControllerPlan oldPlan = VM_ControllerMemory.findLatestPlan(todoMethod);

    if (oldPlan != null) {
      OPT_CompilationPlan oldCompPlan = oldPlan.getCompPlan();
      priority = oldPlan.getPriority();
      options = oldCompPlan.options;
      optimizationPlan = oldCompPlan.optimizationPlan;
    } else {
      priority = 5.0;
      options = VM_RuntimeCompiler.options;
      optimizationPlan = VM_RuntimeCompiler.optimizationPlan;
    }

    OPT_CompilationPlan compPlan = 
      new OPT_CompilationPlan(todoMethod,
                              optimizationPlan,
                              null,
                              options);
  
    OSR_OnStackReplacementPlan plan = 
      new OSR_OnStackReplacementPlan(this.suspendedThread,
                                     compPlan,
                                     this.CMID,
                                     this.whereFrom,
                                     this.tsFromFPoff,
                                     this.ypTakenFPoff,
                                     priority);
    
    VM_Controller.compilationQueue.insert(priority, plan);

    VM_AOSLogging.logOsrEvent("OSR inserts compilation plan successfully!");

    // do not hold the reference anymore.
    suspendedThread = null;
    CMID = 0;
  }
}
