
open Syntax
open Typecheckenv


(* ------------------------------------------------------------
 * Create Substitutions
 * ------------------------------------------------------------ *)

type subst

val new_subst : id list -> subst
val nosubst : subst
val mksubst : env -> id list -> typ list -> subst


(* ------------------------------------------------------------
 * Inspect Substitutions
 * ------------------------------------------------------------ *)

val is_bound_var : subst -> id -> bool
val subst_find : subst -> id -> typ
val check_subst_complete : env -> subst -> unit


(* ------------------------------------------------------------
 * Unification
 * ------------------------------------------------------------ *)

val unify_typs : env -> subst -> typ -> typ -> unit

(* ------------------------------------------------------------
 * Apply Substitutions
 * ------------------------------------------------------------ *)

val subst_typ : subst -> typ -> typ
val subst_decl : subst -> declaration -> declaration
val subst_funsig : subst -> funsig -> funsig


(* ------------------------------------------------------------
 * Type Equivalence
 * ------------------------------------------------------------ *)

val same_funsig : env -> funsig -> funsig -> unit 
val same_type : env -> typ -> typ -> unit

(* ------------------------------------------------------------
 * Specialised Unification
 * ------------------------------------------------------------ *)

val fill_in_generic_arg_types : subst -> env -> typ -> typ -> unit
val fill_in_generic_dict_type : subst -> env -> id -> typ -> typ -> unit
val fill_in_pattern_typ : subst -> env -> typ -> typ -> unit
