
open Syntax
open Syntaxutil
open Util

module SH = Data.StringHash
type 'a strhash = 'a SH.t


(* ------------------------------------------------------------
 * Current Context
 * ------------------------------------------------------------ *)

let thisscope : typ strhash = SH.create ()
let taggedscope : unit strhash = SH.create ()
let structparamscope : id list strhash = SH.create ()

let add_init_decl (quals,corety) ((mods,ido),inito) =
	match ido with
	| Some id -> SH.add (id_str id) (quals,corety,mods) thisscope
	| None -> ()

let add_taggedtyp (quals,corety) = match corety with
	| TyStruct (SKTagged, Some id,_) -> SH.add (id_str id) () taggedscope
	| _ -> ()

let add_structparams (quals,corety) = match corety with
	| TyStruct (_,Some id,Some (_,tyvars,_)) -> 
		SH.add (id_str id) tyvars structparamscope
	| _ -> ()

let add_decl (m,(basetyp,init_decls)) = 
	add_taggedtyp basetyp;
	add_structparams basetyp;
	List.iter (add_init_decl basetyp) init_decls

let add_extdecl (m,extdecl) = match extdecl with
	| Decl decl -> add_decl decl
	| Func (decl,_,_) -> add_decl decl
	| _ -> ()

let set_old_program program = List.iter add_extdecl program

let push_local_scope decls = List.iter add_decl decls
let pop_local_scope () = ()


(* ------------------------------------------------------------
 * Query the current scope
 * ------------------------------------------------------------ *)
	
let old_tagged name = SH.mem (id_str name) taggedscope
	
let old_struct_tyvars name = 
	match SH.maybe_find (id_str name) structparamscope with
	| Some tyvars -> tyvars
	| None -> []
		
