open Syntax

val name_dict : id -> id -> string
val name_dictenv : id -> id -> string
val name_iface : id -> string
val name_tagged : id -> string
val name_method : id -> id -> id -> string
val name_envvar : string
val name_temp : string -> string
val name_dicttemp : string -> string
val name_funenv : id -> string
val name_c_tyvar : id -> string
val name_jkl_tyvar : id -> string

val is_dict_name : id -> bool
val is_dictenv_name : id -> bool
val is_dicttemp_name : id -> bool
val is_tagged_name : id -> bool
val is_env_name : id -> bool
val is_tag_name : id -> bool
val is_body_name : id -> bool
val is_iface_name : id -> bool
val is_temp_name : id -> bool
val is_funtemp_name : id -> bool
val is_funenv_name : id -> bool
val is_thisenv_name : id -> bool
val is_lambda_name : id -> bool

val is_cons_name : id -> bool
val is_operator_name : string -> bool
val is_basetyp_name : string -> bool

val untagged_nameo : id option -> id option
val untagged_name : id -> id
val strip_iface_name : id -> id

val split_tycontext_name : id -> (id * id) option
