open Lexing


(* ------------------------------------------------------------
 * Position in a file
 * ------------------------------------------------------------ *)

val pos_is_nowhere : position -> bool
val nowhere : position


(* ------------------------------------------------------------
 * Span of positions
 * ------------------------------------------------------------ *)

type span = {pstart : position; pend : position}
val mkspan : position -> position -> span
val span_is_nowhere : span -> bool


(* ------------------------------------------------------------
 * Lexer Tokens
 * ------------------------------------------------------------ *)

type lextoken
val mktoken : lexbuf -> lextoken
val dotoken : lexbuf -> unit
val tokenlexeme : lexbuf -> string
val lt_what : lextoken -> string
val lt_white : lextoken -> string
val lt_span : lextoken -> span
val empty_token : lextoken


(* ------------------------------------------------------------
 * Maintain state while lexing
 * ------------------------------------------------------------ *)

val lexstate_set_file_line : lexbuf -> string -> int -> int -> unit
val current_span : unit -> span
val newline : lexbuf -> unit
val add_whitespace : lexbuf -> unit
val gather_whitespace : unit -> string
val track_tokens : bool ref

val get_inputlines : unit -> lextoken list list
val get_inputtokens : unit -> lextoken list
val reset_inputtokens : unit -> unit

val print_current_line : unit -> unit
