
open Syntax
open Syntaxutil
open Names
open Util
open Metadata
open Transform


(* ------------------------------------------------------------
 * Interface <-> struct with "_i" prefix
 * ------------------------------------------------------------ *)

let is_func_decl (m,decl) = match decl_strip_parens decl with
	| _,[(DPtr _::DFun _::_,Some id),None] -> true
	| _ -> false

let all_func_decls decls = List.for_all is_func_decl decls

let decode_iface_member (m,decl) = match decl_strip_parens decl with
	| base,[(DPtr p::DFun(args,kind)::mods,Some id),None] ->
		m, (base,[(DFun(args,IfaceMethod)::mods,Some id),None])
	| _ -> mfatal m "Internal failure while decoding interface"

let maybe_interface ctyp = match ctyp with
	| TyStruct (_,Some id,Some (_,_,mems)) 
		when all_func_decls mems && (not !Cmdargs.j2c) -> 
			Some (id,List.map decode_iface_member mems)
	| _ -> None 


(* ------------------------------------------------------------
 * Tagged struct <-> struct with "_tag" and "_body" fields
 * ------------------------------------------------------------ *)


let is_tag d = List.exists is_tag_name (decl_names d)	
let is_body d = List.exists is_body_name (decl_names d)
			
let maybe_tagged_enum (m,enum) = match enum with
	| (_,TyEnum (None,Some tags)),_ -> Some (List.map fst tags)
	| _ -> None
	
let maybe_tagged_union (m,union) = match union with
	| (_,TyStruct (SKUnion,None,Some (_,[],fields))),_ -> Some fields
	| _ -> None

let decl_has_name name decl = 
	is_simpledecl decl && id_equal name (simpledecl_name decl)

let field_for_name decls name =
	match list_first_match (decl_has_name name) decls with
	| Some decl -> decl
	| None -> nometa (),(([SCoreHere],TyVoid),[([],Some name),None])

let process_tagged_details tag_names union_fields = 
	match tag_names,union_fields with
	| Some names,Some decls ->
		Some (List.map (field_for_name decls) names)
	| _ -> None
			
let maybe_tagged details = match details with
	| Some (_,_,[tag;body]) when is_tag tag && is_body body && (not !Cmdargs.j2c) ->
			let tag_names = maybe_tagged_enum tag in
			let union_fields = maybe_tagged_union body in
			process_tagged_details tag_names union_fields
	| _ -> None
	

(* ------------------------------------------------------------
 * Find all type arguments used in a program
 * ------------------------------------------------------------ *)

let possible_tyargs : typ list list ref = ref []

let get_possible_tyargs () = !possible_tyargs

let find_tyargs dmod = match dmod with
	| DWithArgs typs ->
		possible_tyargs := typs :: !possible_tyargs;
		dmod
	| _ -> dmod


(* ------------------------------------------------------------
 * Find all implement declarations
 * ------------------------------------------------------------ *)

let possible_impls : dictdecl list ref = ref []

let get_possible_impls () = !possible_impls

let find_impls (typ,iface,body) = 
	let needs = match body with DictProto x -> x | DictImpl (x,_) -> x in
	possible_impls := (typ, iface, needs) :: !possible_impls;
	typ,iface,body


(* ------------------------------------------------------------
 * Top level examine routine
 * ------------------------------------------------------------ *)

let mp_examine = {mp_default with
	m_dmod = seq [find_tyargs] mp_default.m_dmod;
	m_ddef = seq [find_impls] mp_default.m_ddef
	}

let examine_old_program program = ignore (map_program mp_examine program)

let noexpand = ref false

let with_noexpand f x =
	let old = !noexpand in
	noexpand := true;
	let r = f x in
	noexpand := old;
	r

	


(* ------------------------------------------------------------
 * Try all possible type params combinations
 * ------------------------------------------------------------ *)



