
open Jklarg

let sourcefiles = ref []
let outfile = ref None
let prevfile = ref None
let includedirs = ref ["."]
let verbose = ref false
let noembed_info = ref false
let typecheck = ref true
let j2c = ref true
let many_errors = ref false
let short_errors = ref false
let warn_white = ref false
let copy_output = ref false
let new_output = ref false
let dropsrc = ref false
let cparams = ref ""

let setstr strref = String (fun s -> strref := Some s)
let addstr listref = String (fun s -> listref := s :: !listref)
let addparam strref flag = String (fun s -> strref := !strref ^ " " ^ flag ^ s)

type cmdargs = (key * spec * doc) list

let argformat = [
	("-o", setstr outfile, "Output file");
	("-p", setstr prevfile, "Previous version");
	("-I", addstr includedirs, "Add an import/include directory");
	("-D", addparam cparams "-D" , "Define a preprocessor variable");
	("--warnwhite", Set warn_white, "Warn if whitespace lost"); 
	("--j2c", Set j2c, "Convert Jekyll code to C code");
	("--c2j", Clear j2c, "Convert C code to Jekyll code");
	("--new", Set new_output, "There is no previous version");
	("--copy", Set copy_output, "Output to a new copy, rather than overwriting");
	("--dropsrc", Set dropsrc, "Ignore source whitespace");
	("--noannot", Set noembed_info, "Generate clean C without annotations");
	("--verbose", Set verbose, "Verbose progress messages");
	("--shorterror", Set short_errors, "Short error messages");
	("--manyerror", Set many_errors, "Show more than one error message")
]

let add_source_filename (filename : string) =
	sourcefiles := filename :: !sourcefiles


let intromsg = 	
	"The Jekyll Translator, alpha 0.3, (c) 2006 Intel Research\n" ^
	"USAGE: jekyll [OPTIONS] [SOURCE FILE]"


let print_usage () = usage argformat intromsg

let process_command_args () = parse argformat add_source_filename intromsg


(* the source file we have been asked to compile *)
let get_fname () = match !sourcefiles with
	| [x] -> x
	| _ -> print_usage (); exit 2
