/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.model;

import java.util.Comparator;
import java.util.Objects;

public class BytecodeVersion
implements Comparable<BytecodeVersion> {
    private static final Comparator<BytecodeVersion> BYTECODE_VERSION_COMPARATOR = Comparator.comparingInt(BytecodeVersion::getMajor).thenComparing(BytecodeVersion::getMinor);
    private final int major;
    private final int minor;

    public static BytecodeVersion of(int major) {
        return new BytecodeVersion(major, 0);
    }

    public static BytecodeVersion of(int major, int minor) {
        return new BytecodeVersion(major, minor);
    }

    private BytecodeVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public boolean isEmpty() {
        return 0 == this.major && 0 == this.minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(BytecodeVersion o) {
        if (null == o) {
            return -1;
        }
        return BYTECODE_VERSION_COMPARATOR.compare(this, o);
    }

    public String toString() {
        return this.major + (String)(0 != this.minor ? "." + this.minor : "") + this.asJavaVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytecodeVersion that = (BytecodeVersion)o;
        return this.major == that.major && this.minor == that.minor;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    private String asJavaVersion() {
        if (45 == this.major && 3 == this.minor) {
            return " (Java 1.1)";
        }
        int javaVersion = this.major - 44;
        if (65535 == this.minor) {
            return " (Java " + javaVersion + "-preview)";
        }
        return " (Java " + javaVersion + ")";
    }
}

