!! Code to manage IMAGER messages
module map_message_private
  use gpack_def
  !
  ! Identifier used for message identification
  integer :: map_message_id = gpack_global_id  ! Default value for startup message
  !
end module map_message_private
!
subroutine map_message_set_id(id)
  use map_message_private
  use gbl_message
  !---------------------------------------------------------------------
  !*
  ! IMAGER -- Message Utility  
  ! Alter library id into input id. Should be called by the library
  ! which wants to share its id with the current one.
  !!
  !---------------------------------------------------------------------
  integer, intent(in) :: id  !! Package ID
  ! Local
  character(len=message_length) :: mess
  !
  map_message_id = id
  !
  write (mess,'(A,I3)') 'Now use id #',map_message_id
  call gmessage_write(map_message_id,seve%d,'map_message_set_id',mess)
  !
end subroutine map_message_set_id
!
subroutine map_message(mkind,procname,message,colour)
  use gbl_ansicodes
  use gkernel_interfaces
  use map_message_private
  !---------------------------------------------------------------------
  ! @ public-mandatory
  !*
  ! IMAGER -- Message Utility
  !
  !   Messaging facility for the current library. Calls the low-level
  !   (internal) messaging routine with its own identifier.
  ! This is a variant of the GILDAS message, with color options added.
  !!
  !---------------------------------------------------------------------
  integer,          intent(in) :: mkind       !! Message kind
  character(len=*), intent(in) :: procname    !! Name of calling procedure
  character(len=*), intent(in) :: message     !! Message string
  integer, intent(in), optional :: colour     !! Colour of message 
  !
  ! Constants
  logical, parameter :: new=.false.         ! Until SIC is updated
  character(len=8), parameter :: colors(10) = &
      (/ 'NONE    ',  &
         'BLACK   ',  &
         'RED     ',  &
         'GREEN   ',  &
         'YELLOW  ',  &
         'BLUE    ',  &
         'MAGENTA ',  &
         'CYAN    ',  &
         'WHITE   ',  &
         'ORANGE  ' /)
  integer :: color_codes(0:7) ! Only Black, RGB,CYM, and White
  data color_codes /2, 3,4,6, 8,10,7, 9/
  !
  ! Code ---
  if (present(colour)) then
    if (new) then
      call gmessage_write_color(map_message_id,mkind,procname,message, &
        & color_codes(colour))
    else
      call message_colour(colour)
      call gmessage_colors_swap(.false.)
      call gmessage_write(map_message_id,mkind,procname,message)
      write(*,'(A)',advance='NO') c_clear
      call gmessage_colors_swap(.true.)
    endif
  else
    call gmessage_write(map_message_id,mkind,procname,message)
  endif
  !
end subroutine map_message
!
subroutine map_iostat(mkind,procname,ier)
  use gkernel_interfaces
  use map_message_private
  !---------------------------------------------------------------------
  ! @ public
  !*
  ! IMAGER -- Message utility - IO error 
  !
  !   Output system message corresponding to IO error code IER, and
  !   using the Message facility
  !!
  !---------------------------------------------------------------------
  integer,          intent(in) :: mkind       !! Message severity
  character(len=*), intent(in) :: procname    !! Calling routine name
  integer,          intent(in) :: ier         !! IO error number
  !
  ! Local
  character(len=message_length) :: msg
  !
  if (ier.eq.0) return
  call gag_iostat(msg,ier)
  call gmessage_write(map_message_id,mkind,procname,msg)
  !
end subroutine map_iostat
!
subroutine message_colour(colour)
  use gbl_ansicodes
  !---------------------------------------------------------------------
  ! @ public
  !
  !! IMAGER --  Message Utility: Change the colour of the next message
  !---------------------------------------------------------------------
  integer, intent(in) :: colour  !! Desired colour index
  !
  character(len=12) :: chain
  !
  select case (colour)
    case(0)
      chain = c_bold//c_black
    case(1)
      chain = c_bold//c_red
    case(2)
      chain = c_bold//c_green
    case(3)
      chain = c_bold//c_blue
    case(4)
      chain = c_bold//c_cyan 
    case(5)
      chain = c_bold//c_yellow
    case(6)
      chain = c_bold//c_magenta
    case(7)
      chain = c_bold//c_white
    case default
      chain = c_clear
  end select
  write(*,'(A)',advance='NO') trim(chain)
  !
end subroutine message_colour
!
subroutine message_attribute(cattr)
  use gbl_ansicodes
  !! IMAGER -- Message Utility -- Write color or bold modifier to terminal
  character(len=*), intent(in) :: cattr  !! Attribute modifier
  !
  write(*,'(A)',advance='NO') c_start//cattr//c_end
end subroutine message_attribute
