# Adjust list of files as desired, according to files
# found on GitHub on url below
for x in define-system.sh gildas-env.sh Makefile.def; do
  echo $x
  #
  # Step 1: Download the specified patch from GitHub
  rm ~/Downloads/patch-admin-$x.diff.zip
  open https://downgit.github.io/#/home?url=https://github.com/macports/macports-ports/blob/master/science/gildas/files/patch-admin-$x.diff
  # (almost) Ensure download is complete
  sleep 3
  # then Unzip it
  mv ~/Downloads/patch-admin-$x.diff.zip ./
  rm patch-admin-$x.diff
  unzip patch-admin-$x.diff.zip
  rm patch-admin-$x.diff.zip
  #
  # Step 2: Apply the patch
  cp $IRAM_ROOT/admin/$x ./
  patch -o $x.orig $x patch-admin-$x.diff
done 
#
# At this step, the .orig files contains what is appropriate for MacPorts according to GILDAS
#
# Step 3: Customize the .orig files for IMAGER
# 3.1 Makefile.def
sed 's/LATEX2HTML = latex2html/LATEX2HTML = makehtml/g' Makefile.def.orig > Maketmp.def
diff Maketmp.def Makefile.def.orig
mv Maketmp.def Makefile.def.orig
#
# 3.2 Makefile.build
sed 's/$(LATEX2HTML) -dir $@ $</$(LATEX2HTML) $</' $IRAM_ROOT/admin/Makefile.build > Makefile.build.orig
#
# 3.3 Convert gildas-env.sh to imager-env.sh
sed 's/gildas/imager/g; s/GILDAS/IMAGER/g' gildas-env.sh.orig > imager-env.a.tmp
sed 's/J. Pety <pety@iram.fr>/S.Guilloteau <stephane.guilloteau@u-bordeaux.fr>/g; s|http://www.iram.fr/IRAMFR/IMAGER>|https://imager.oasu.u-bordeaux.fr>|g' imager-env.a.tmp > imager-env.b.tmp
echo '# Script Cloned from gildas-env.sh (J.Pety pety@iram.fr), but customized for IMAGER' > imager-env.sh.orig
cat imager-env.b.tmp >> imager-env.sh.orig
rm imager-env.b.tmp imager-env.a.tmp

