#!/bin/bash
# (according to J.F. Desmurs comment)
# Retrieve source code
Version=" "
if [ "$#" == "0" ] ; then
  Version="last"
  echo "Recovering imager-last.tgz"
  # Link is permanent, but file may be updated at each version
  curl -o imager-last.tgz https://mycore.core-cloud.net/index.php/s/sGNSjGtRBPZ4VhY/download
#  curl -o imager-last.tgz https://mycore.core-cloud.net/remote.php/webdav/IMAGER/imager-last.tgz
  tar -xvf imager-last.tgz
  for file in `ls -1 -rd */`
  do
  #  echo $file
  #  echo "${file:0:10}"
    if [ "${file:0:10}" == "imager-src" ] ; then
      if [ "${file:16:1}" == "/" ] ; then
        Version="${file:11:5}"
  #      echo "${file:11:5}"
      fi
    fi
  done
  echo "Downloaded last available Version $Version"
else
  Version=$1
  echo "Selecting user-specified Version $Version"
fi
unset answer
read -t 600 -p "Ready to continue (y/N) ?" answer
# if answer is yes within 10 minutes, proceed with compilation+installation process
if [ ! "${answer}" == "y" ]
then
  echo "Aborting due to non positive answer ${answer}"
  return 1
fi
#
# Compile
if [ -d "imager-src-$Version" ]; then
  echo "Moving to imager-src-$Version"
elif [ -d "imager-$Version" ]; then
  mv imager-$Version imager-src-$Version
elif [ -f "imager-$Version.tar.gz" ]; then
  tar -xvf imager-$Version.tar.gz
  mv imager-$Version imager-src-$Version
else 
  echo "No such version $Version available"
  return 1
fi
# Patch until imager-env.sh has been updated
export my_exedir=$PWD/imager-exe-$Version # Patch
# Ensure no conflict with other versions being compiled
unset gagsrcdir
unset gagexedir
unset gagadmdir
#
cd imager-src-$Version
source admin/imager-env.sh -o openmp
export gagexedir=$my_exedir         # Patch
#
# get confirmation
read -t 60 -p "Ready to compile Imager in $gagsrcdir. Continue (y/N)? " answer
# if answer is yes within 60 seconds start compilation
if [ "${answer}" == "y" ]
then
  make -j16
fi
#
unset answer
read -t 600 -p "Ready to install Imager on $gagexedir. Continue (y/N)? " answer
# if answer is yes within 10 minutes, proceed with installation
if [ "${answer}" == "y" ]
then
  make install
fi
# Avoid remanence
set --  
cd ..
