subroutine omp_setup
  use omp_control
  !$ use omp_lib
  use gkernel_interfaces
  !
  logical :: error
  real :: rthread
  !
  call sic_defstructure('OMP_MAP',.true.,error)
  omp_compiled = .false.
  !$ omp_compiled = .true.
  call sic_def_logi('OMP_MAP%COMPILED',omp_compiled,.false.,error)
  omp_debug = .false.
  call sic_def_logi('OMP_MAP%DEBUG',omp_debug,.false.,error)
  call sic_def_inte('OMP_MAP%GRID',omp_grid,0,0,.false.,error)
  call sic_def_inte('OMP_MAP%SINGLE_BEAM_CODE',omp_single_beam,0,0,.false.,error)
  omp_outer_threadgoal = 1
  !$ rthread = omp_get_max_threads()
  !$ omp_outer_threadgoal = nint(sqrt(rthread))
  call sic_def_inte('OMP_MAP%OUTER_GOAL',omp_outer_threadgoal,0,0,.false.,error)
  !$ omp_outer_threadgoal = max(1,omp_outer_threadgoal)
end subroutine omp_setup
!
subroutine ompset_thread_nesting(rname, nplane, max_inner, omp_nested)
  !$ use omp_lib
  use omp_control
  use gbl_message
  use imager_interfaces, only : map_message
  ! @ private
  character(len=*), intent(in) :: rname
  integer, intent(in) :: nplane
  integer, intent(in) :: max_inner
  logical, intent(out) :: omp_nested
  !
  character(len=80) :: chain
  integer :: mthread
  !
  mthread = 1
  !$  mthread = omp_get_max_threads()
  !$  omp_nested = omp_get_nested()
  if (nplane.le.mthread/2) then
    ! There are more available Threads than planes - One can use nested
    ! parallelism with Outer and Inner threads
    omp_outer_thread = nplane 
    omp_inner_thread = mthread/nplane
    !$  call omp_set_nested(.true.)
  else
    omp_outer_thread = mthread
    omp_inner_thread = 1 
    !$  call omp_set_nested(.false.)
  endif
  !
  if (max_inner.ne.0) omp_inner_thread = min(max_inner,omp_inner_thread)
  write(chain,'(A,I0,A,I0)') 'Nested threads Outer ',omp_outer_thread,' Inner ',omp_inner_thread
  call map_message(seve%i,rname,chain)
end subroutine ompset_thread_nesting
!
function ompget_outer_threads()
  use omp_control
  ! @ private
  integer :: ompget_outer_threads ! Intent(out)
  !
  ompget_outer_threads = omp_outer_thread
end function ompget_outer_threads
!
function ompget_inner_threads()
  use omp_control
  ! @ private
  integer :: ompget_inner_threads ! Intent(out)
  !
  ompget_inner_threads = omp_inner_thread
end function ompget_inner_threads
!
function ompget_grid_code()
  use omp_control
  ! @ private
  integer :: ompget_grid_code    ! Intent(out)
  !
  ompget_grid_code = omp_grid    ! From OMP_MAP%GRID variable
end function ompget_grid_code
!
function ompget_debug_code()
  use omp_control
  logical :: ompget_debug_code    ! Intent(out)
  !
  ompget_debug_code = omp_debug    ! From OMP_MAP%GRID variable
end function ompget_debug_code
!
function ompget_outer_goal()
  use omp_control
  ! @ private
  integer :: ompget_outer_goal    ! Intent(out)
  !
  ompget_outer_goal = omp_outer_threadgoal   ! From OMP_MAP%OUTER_GOAL variable
end function ompget_outer_goal
!
subroutine uv_get_block(via_fft,nx,ny,nc,nthread,step,chunk)
  use clean_default
  use gbl_message
  use gkernel_interfaces
  use imager_interfaces, only : map_message
  !-----------------------------------------------------------------
  ! @ private
  !
  ! IMAGER   Support for UV_RESTORE and UV_RESIDUAL
  !
  !     Compute the blocking factor according to the
  !   available memory and Clean component removal mode
  !-----------------------------------------------------------------
  logical, intent(in) :: via_fft    ! Do we use FFTs or not
  integer, intent(in) :: nx,ny      ! Image size
  integer, intent(in) :: nc         ! INumber of channels
  integer, intent(in)  :: nthread   ! Number of threads
  real, intent(in) :: step          ! Number of words per pixel (1 to 4)
  integer, intent(out) :: chunk     ! Resulting "chunk" size in Channels
  !
  integer :: mx,my
  real :: rmega
  integer :: ier
  real :: blsize
  integer :: sblock
  character(len=128) :: chain
  character(len=12) :: task='BLOCK_SIZE'
  !
  if (via_fft) then
    call cct_fft_size(nx,ny,mx,my)
  else
    mx = nx
    my = ny
  endif
  !
  rmega = sys_ramsize/4     ! Do not overload Memory
  rmega = max(4096.0,rmega) !! Assume you can at least take 4GByte of memory
  ier = sic_ramlog('SPACE_IMAGER',rmega)
  !
  ! The memory use depends on the TOTAL number of threads --Share with equity...
  rmega = rmega/nthread
  !
  ! Re-adjust the block size according to Memory requirements of the method
  blsize = 4.0*step*mx*my/1024/1024
  !! Print *,'Channel size (FFT+Channel) ',blsize/1024.,' Gbytes), Avail per thread ',rmega/1024
  sblock = max(1,int(rmega/blsize))
  sblock = min(nc,sblock)
  write(chain,'(A,I0,A,F8.1,A)') 'Blocking by ',sblock,' channels, Estimated memory usage ', &
    & nthread*sblock*blsize/1024.,' Gbytes'
  call map_message(seve%i,task,chain)
  !
  chunk = sblock
end subroutine uv_get_block
