subroutine uv_removeh_clean(method,hbeam,hclean, &
  & hcct,duv,ouv,nc,mic,fcou,freq,first,last,ifield) !
  use image_def
  use clean_def
  use imager_interfaces, except_this => uv_removeh_clean
  use gbl_message
  !$ use omp_lib
  !-----------------------------------------------------------------
  ! @ private-mandatory
  !
  ! IMAGER   Support for UV_RESTORE
  !     Compute visibilities for a UV data set according to a
  !     set of Clean Components , and remove them from the original
  !     UV table
  !   This version is for tranpose CCT data (3 or 4,ncomp,nchannels)
  !   and uses an intermediate FFT for speed
  !-----------------------------------------------------------------
  type(clean_par), intent(in) :: method ! Cleaning Method
  type(gildas), intent(in) :: hbeam   ! header of Clean Components Table
  type(gildas), intent(in) :: hclean  ! header of Clean Components Table
  type(gildas), intent(in) :: hcct    ! header of Clean Components Table
  integer, intent(in) :: nc           ! Number of channels
  integer, intent(in) :: mic(:)       ! Number of Clean Components
  real, intent(in) :: duv(:,:)        ! Input visibilities
  real, intent(out) :: ouv(:,:)       ! Output visibilities
  real, intent(in), target :: fcou(:,:,:) ! Clean Components
  real(8), intent(in) :: freq         ! Apparent observing frequency
  integer, intent(in) :: first        ! First
  integer, intent(in) :: last         ! and last channel
  integer, intent(in) :: ifield
!  real, intent(in) :: dbeam(:,:)    ! Primary Beam for current field
  !
  integer :: jc,kc,oic,olc,j3,j4,ier
  real, allocatable :: dmap(:,:,:)
  real, pointer :: fctmp(:,:,:)
  integer :: nx,ny
  integer :: ibeam
  !
  oic = first
  olc = last
  !
  nx = (hcct%gil%convert(1,1)-1)*2   ! Reference pixel is at Mx/2+1
  ny = (hcct%gil%convert(1,3)-1)*2
  allocate(dmap(nx,ny,nc),stat=ier)
  ! Loop over channels to compute the Clean Component Cube
  fctmp => fcou(:,:,:) !! oic-ic+1:) ! A voir
  do jc=oic,olc
    kc = jc-oic+1
    call clean_make_cct(method,hclean,dmap(:,:,kc:kc),fctmp(:,:,kc:kc),method%gsize)
  enddo
  !
  ! This is approximate
  jc = (oic+olc)/2
  ibeam = beam_for_channel(jc,hclean,hbeam)
  if (hbeam%gil%faxi.eq.3) then
    j3 = ibeam
    j4 = ifield
  else
    j3 = ifield
    j4 = ibeam
  endif
  !
  call uv_removeg_clean(hcct,duv,ouv,olc-oic+1,mic(oic:olc), &
    & dmap,freq, oic, olc, hbeam%r4d(:,:,j3,j4))
end subroutine uv_removeh_clean
!
subroutine uv_removeg_clean(hcct,duv,ouv,nc,mic,dmap,freq,first,last,dbeam)
  use image_def
  use imager_interfaces, except_this => uv_removeg_clean
  use gbl_message
  !$ use omp_lib
  !-----------------------------------------------------------------
  ! @ private-mandatory
  !
  ! IMAGER   Support for UV_RESTORE
  !     Compute visibilities for a UV data set according to a
  !     set of Clean Components , and remove them from the original
  !     UV table
  !   This version is for tranpose CCT data (3 or 4,ncomp,nchannels)
  !   and uses an intermediate FFT for speed
  !-----------------------------------------------------------------
  type(gildas), intent(in) :: hcct  ! header of Clean Components Table
  integer, intent(in) :: nc         ! Number of channels
  integer, intent(in) :: mic(:)     ! Number of Clean Components
  real, intent(in) :: duv(:,:)      ! Input visibilities
  real, intent(out) :: ouv(:,:)     ! Output visibilities
  real, intent(in) :: dmap(:,:,:)   ! Sky distribution of Clean components
  real(8), intent(in) :: freq       ! Apparent observing frequency
  integer, intent(in) :: first      ! First
  integer, intent(in) :: last       ! and last channel
  real, intent(in) :: dbeam(:,:)    ! Primary Beam for current field
  !
  real(8), parameter :: pi=3.14159265358979323846d0
  !
  integer :: nv    ! Number of visibilities
  integer :: mv    ! Size of a visibility
  integer :: nx,ny
  integer :: mx,my
  integer :: kx,ky
  real :: dxy
  real :: value
  complex, allocatable :: cfft(:,:,:)
  real, allocatable :: work(:)
  real, allocatable :: lmap(:,:)
  integer :: iplane,ic,ix,iy,iv,ier, dim(2)
  logical :: error
  real(8) :: xinc, yinc, xref, yref, xval, yval
  integer :: mthread, lx,ly, scc, ncc_size, jsize, j, is
  real :: asize, cc_size(20), fact(20), cc_count(20), cc_flux(20)
  !
  !
  nv = ubound(duv,2)    ! Number of Visibilities
  mv = 7+3*nc
  !
  ! Image size - Twice the (reference_pixel-1) by convention
  mx = (hcct%gil%convert(1,1)-1)*2
  my = (hcct%gil%convert(1,3)-1)*2
  if ((mx.ne.size(dmap,1)).or.(my.ne.size(dmap,2))) then
    Print *,'MX MY ',mx,my
    Print *,'Sizes ',size(dmap,1),size(dmap,2)
    call map_message(seve%e,'RESTORE_G','Size mismatch ')
    error = .true.
    return
  endif
  !
  nx = mx
  ny = my
  ! No reinterpolation - Will come later if needed
  ! call cct_fft_size(mx,my,nx,ny)
  !
  ! Get Virtual Memory & compute the FFT
  allocate(cfft(nx,ny,nc),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,'RESTORE_G','uv_removeg_clean -- allocation error')
    error = .true.
    return
  endif
  !
  xref = hcct%gil%convert(1,1)
  xval = hcct%gil%convert(2,1)
  xinc = hcct%gil%convert(3,1)
  yref = hcct%gil%convert(1,3)
  yval = hcct%gil%convert(2,3)
  yinc = hcct%gil%convert(3,3)
  dim = [nx,ny]
  !
  !  call fourt_plan(ftbeam,dim,2,1,1)
  kx = mx/2+1
  lx = nx/2+1
  ky = my/2+1
  ly = ny/2+1
  !
  ! Must set the number of threads according to number of channels
  ! and available Thread nesting
  mthread = 1
  !$ mthread = ompget_inner_threads()
  mthread = min(nc,mthread)
  !
  !$OMP PARALLEL IF (nc.gt.1) DEFAULT(none) NUM_THREADS(mthread) SHARED(dmap,dbeam,cfft) &
  !$OMP    & SHARED(nc,nx,ny,mx,my,dim) &
  !$OMP    & PRIVATE(iplane,work,lmap,ier) 
  !
  allocate(work(2*max(nx,ny)),lmap(nx,ny),stat=ier)
  !!Print *,'IER ',ier, size(dbeam,1), size(dbeam,2)
  !!Print *,dbeam(1,1)
  !$OMP DO
  do iplane=1,nc
    ! Apply primary beam
    lmap(:,:) = dbeam * dmap(:,:,iplane)
    !!Print *,'Done LMAP ',iplane
    cfft(:,:,iplane) = cmplx(lmap,0.0)
    !!Print *,'Done CFFT ',iplane
    ! FOURT is now Thread-safe for the non-FFTW version.
    call fourt(cfft(:,:,iplane),dim,2,1,1,work)
    !!Print *,'Done FOURT ',iplane
    call recent(nx,ny,cfft(:,:,iplane))
    !!Print *,'Done RECENT ',iplane
  enddo
  !$OMP END DO
  deallocate(work)
  !$OMP END PARALLEL
  !
  ! Extract the visibility subset
  do iv = 1,nv
    ouv(1:7,iv) = duv(1:7,iv)
    ouv(8:mv,iv) = duv(5+3*first:7+3*last,iv)
  enddo
  !
  ! Interpolate and subtract the model visibilities
  !$ mthread = ompget_inner_threads()
  call do_smodel(ouv,mv,nv,cfft,nx,ny,nc,freq,xinc,yinc,1.0,mthread)
  !
  deallocate(cfft)
end subroutine uv_removeg_clean
!
subroutine uv_removef_clean(hcct,duv,ouv,nc,mic,dcct,freq,first,last)
  use image_def
  use imager_interfaces, except_this => uv_removef_clean
  use gbl_message
  !$ use omp_lib
  !-----------------------------------------------------------------
  ! @ private-mandatory
  !
  ! IMAGER   Support for UV_RESTORE
  !     Compute visibilities for a UV data set according to a
  !     set of Clean Components , and remove them from the original
  !     UV table
  !   This version is for tranpose CCT data (3 or 4,ncomp,nchannels)
  !   and uses an intermediate FFT for speed
  !-----------------------------------------------------------------
  type(gildas), intent(in) :: hcct  ! header of Clean Components Table
  integer, intent(in) :: nc         ! Number of channels
  integer, intent(in) :: mic(:)     ! Number of Clean Components
  real, intent(in) :: duv(:,:)      ! Input visibilities
  real, intent(out) :: ouv(:,:)     ! Output visibilities
  real, intent(in) :: dcct(:,:,:)   ! Clean components
  real(8), intent(in) :: freq       ! Apparent observing frequency
  integer, intent(in) :: first      ! First
  integer, intent(in) :: last       ! and last channel
  !
  real(8), parameter :: pi=3.14159265358979323846d0
  !
  integer :: nv    ! Number of visibilities
  integer :: mv    ! Size of a visibility
  integer :: nx,ny
  integer :: mx,my
  integer :: kx,ky
  real :: dxy
  real :: value
  complex, allocatable :: cfft(:,:,:)
  complex, allocatable :: lfft(:,:,:)
  real, allocatable :: work(:)
  integer :: iplane,ic,ix,iy,iv,ier, dim(2)
  logical :: error
  real(8) :: xinc, yinc, xref, yref, xval, yval
  integer :: mthread, lx,ly, scc, ncc_size, jsize, j, is
  real :: asize, cc_size(20), fact(20), cc_count(20), cc_flux(20)
  !
  scc = size(dcct,1)    ! Size of a Clean Component (3 or 4)
  if (scc.ne.3) then
    ncc_size = 0
    do iplane=1,nc
      do ic=1,mic(iplane)
        if (dcct(3,ic,iplane).eq.0) exit
        jsize = 0
        do j=1,ncc_size
          if (dcct(4,ic,iplane).eq.cc_size(j)) then
            jsize = j
            exit
          endif
        enddo
        if (jsize.eq.0) then
          ncc_size = ncc_size+1
          cc_size(ncc_size) =  dcct(4,ic,iplane)
        endif
        if (ncc_size.gt.10) exit
      enddo
    enddo
    cc_count = 0
    cc_flux = 0.
  else
    ncc_size = 1
  endif
  !
  nv = ubound(duv,2)    ! Number of Visibilities
  !! Print *,'Number of visibilities ',nv,' in removef_clean'
  mv = 7+3*nc
  !
  ! Image size - Twice the (reference_pixel-1) by convention
  mx = (hcct%gil%convert(1,1)-1)*2
  my = (hcct%gil%convert(1,3)-1)*2
  !
  call cct_fft_size(mx,my,nx,ny)
  !
  ! Get Virtual Memory & compute the FFT
  allocate(cfft(nx,ny,nc),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,'UV_RESTORE','uv_removef_clean -- allocation error')
    error = .true.
    return
  endif
  !
  xref = hcct%gil%convert(1,1)
  xval = hcct%gil%convert(2,1)
  xinc = hcct%gil%convert(3,1)
  yref = hcct%gil%convert(1,3)
  yval = hcct%gil%convert(2,3)
  yinc = hcct%gil%convert(3,3)
  dim = [nx,ny]
  !
  !  call fourt_plan(ftbeam,dim,2,1,1)
  kx = mx/2+1
  lx = nx/2+1
  ky = my/2+1
  ly = ny/2+1
  !
  ! Must set the number of threads according to number of channels
  ! and available Thread nesting
  mthread = 1
  !$ mthread = ompget_inner_threads()
  mthread = min(nc,mthread)
  !
  if (scc.eq.3) then
    !
    !$OMP PARALLEL IF (nc.gt.1) DEFAULT(none) NUM_THREADS(mthread) SHARED(dcct,cfft) &
    !$OMP    & SHARED(nc,mic,nx,ny,mx,my,dim,xinc,yinc,xref,yref,xval,yval) &
    !$OMP    & PRIVATE(iplane,ic,ix,iy,value,ier) PRIVATE(work) &
    !$OMP    & PRIVATE(dxy) SHARED(kx,lx,ky,ly)
    !
    allocate(work(2*max(nx,ny)),stat=ier)
    !$OMP DO
    do iplane=1,nc
      cfft(:,:,iplane) = 0.0
      do ic=1,mic(iplane)
        if (dcct(3,ic,iplane).eq.0) exit
        !
        value = dcct(3,ic,iplane)
        ! The NINT is required because of rounding errors
        ix = nint( (dcct(1,ic,iplane)-xval) / xinc + xref )
        iy = nint( (dcct(2,ic,iplane)-yval) / yinc + yref )
        cfft(ix-kx+lx,iy-ky+ly,iplane) = cfft(ix-kx+lx,iy-ky+ly,iplane) + &
          & cmplx(value,0.0)
      enddo
      !
      ! FOURT is now Thread-safe for the non-FFTW version.
      call fourt(cfft(:,:,iplane),dim,2,1,1,work)
      call recent(nx,ny,cfft(:,:,iplane))
    enddo
    !$OMP END DO
    deallocate(work)
    !$OMP END PARALLEL
    !
  else
    !
    !$OMP PARALLEL IF (nc.gt.1) DEFAULT(none) NUM_THREADS(mthread) SHARED(dcct,cfft) &
    !$OMP    & SHARED(nc,mic,nx,ny,mx,my,dim,xinc,yinc,xref,yref,xval,yval, fact) &
    !$OMP    & PRIVATE(iplane,ic,ix,iy,is,value,ier) PRIVATE(work) &
    !$OMP    & PRIVATE(asize, lfft) SHARED(kx,lx,ky,ly,cc_size,ncc_size) &
    !$OMP    & PRIVATE(cc_count,cc_flux)
    !
    allocate(work(2*max(nx,ny)),lfft(nx,ny,ncc_size),stat=ier)
    !$OMP DO
    do iplane=1,nc
      cfft(:,:,iplane) = 0.0
      cc_count = 0
      cc_flux = 0.0
      lfft = cmplx(0.,0.)
      do ic=1,mic(iplane)
        if (dcct(3,ic,iplane).eq.0) exit
        !
        value = dcct(3,ic,iplane)
        ! The NINT is required because of rounding errors
        ix = nint( (dcct(1,ic,iplane)-xval) / xinc + xref )
        iy = nint( (dcct(2,ic,iplane)-yval) / yinc + yref )
        asize = dcct(4,ic,iplane)
        do is=1,ncc_size
          if (cc_size(is).eq.asize) then
            lfft(ix-kx+lx,iy-ky+ly,is) = lfft(ix-kx+lx,iy-ky+ly,is) + &
              & cmplx(value,0.0)
            cc_count(is) = cc_count(is)+1
            cc_flux(is) = cc_flux(is)+value
            exit
          endif
        enddo
      enddo
      !
      do is=1,ncc_size
        ! FOURT is now Thread-safe for the non-FFTW version.
        call fourt(lfft(:,:,is),dim,2,1,1,work)
        ! For flux normalisation
        ! fact = cmajor*cminor*pi/(4.0*log(2.0))   &
        !     &    /abs(xinc*yinc)/(nx*ny)
        ! For simple FFT normalization  1./(nx*ny)
        if (cc_size(is).ne.0) then
          ! Factor is just 1.0 here, since we work in total flux
          ! and directly in the Fourier Plane
          call mulgau(lfft(:,:,is),nx,ny,   &
               &    cc_size(is),cc_size(is),0.0,  &
               &    1.0,real(xinc),real(yinc),-1)
        endif
        !
        cfft(:,:,iplane) = cfft(:,:,iplane) + lfft(:,:,is)
      enddo
      !
      call recent(nx,ny,cfft(:,:,iplane))
    enddo
    !$OMP END DO
    deallocate(work)
    !$OMP END PARALLEL
    !
  endif
  !
  ! Extract the visibility subset
  do iv = 1,nv
    ouv(1:7,iv) = duv(1:7,iv)
    ouv(8:mv,iv) = duv(5+3*first:7+3*last,iv)
  enddo
  !
  ! Interpolate and subtract the model visibilities
  !$ mthread = ompget_inner_threads()
  call do_smodel(ouv,mv,nv,cfft,nx,ny,nc,freq,xinc,yinc,1.0,mthread)
  !
  deallocate(cfft)
end subroutine uv_removef_clean
!
subroutine cossin(phase,rcos,rsin)
  !-------------------------------------------------------
  ! Semi-Fast,  Semi-accurate Sin/Cos pair computation
  ! using (not yet clever) interpolation from a precise
  ! loop-up table
  !
  ! A solution using Taylor expansion and symmetries
  ! would be faster and more accurate
  !-------------------------------------------------------
  real(8), intent(inout) :: phase
  real(8), intent(out) :: rcos
  real(8), intent(out) :: rsin

!!  integer, intent(inout) :: ier
!!  real(8), intent(in) :: maxerr
!!  real(8), intent(inout) :: themax
  !
  real(8), parameter :: pi=3.14159265358979323846d0
  integer, parameter :: mcos=2048
  integer, save :: ncos = 0
  real(8), save :: cosine(mcos)
  real(8), save :: sine(mcos)
  real(8), save :: rstep
  real(8) :: rdeg
  integer :: i
  logical :: minus
  !
  ! Use accurate value
  rcos = cos(phase)
  rsin = sin(phase)
  !
  ! Approximate solution below
  if (.TRUE.) return
  !
  if (ncos.eq.0) then
    ncos = mcos
    rstep = 2.01d0*pi/mcos
    do i=1,ncos
      rdeg = (i-1)*rstep
      cosine(i) = cos(rdeg)
      sine(i) = sin(rdeg)
    enddo
  endif
  !
  if (phase.ge.0) then
    minus =.false.
    rdeg = modulo(phase,2.0d0*pi)+0.5d0*rstep
  else
    minus = .true.
    rdeg = modulo(-phase,2.0d0*pi)+0.5d0*rstep
  endif
  rdeg = rdeg/rstep
  i = int(rdeg)
  rdeg = rdeg - i
  i = i+1
  rcos = (1.0-rdeg)*cosine(i) + rdeg*cosine(i+1)
  rsin = (1.0-rdeg)*sine(i) + rdeg*sine(i+1)
  if (minus) rsin = -rsin
end subroutine cossin
!
