subroutine old_uvmap(task,line,error)
  use gkernel_interfaces
  use imager_interfaces, except_this=>old_uvmap
  use clean_def
  use clean_arrays
  use clean_types
  use clean_default
  use gbl_message
  !------------------------------------------------------------------------
  ! @ private
  !
  ! "Historical" version of UV_MAP, deprecated in IMAGER,
  ! only used for debugging and comparison.
  !
  ! TASK  Compute a map from a CLIC UV Sorted Table
  ! by Gridding and Fast Fourier Transform, using adequate
  ! scratch space for optimisation. Will work for
  ! up to 128x128x128 cube data size, may be more...
  !
  ! Input :
  !     a precessed UV table
  ! Output :
  !     a precessed, rotated, shifted UV table, sorted in V,
  !     ordered in (U,V,W,D,T,iant,jant,nchan(real,imag,weig))
  !     a beam image or cube
  !     a LMV cube
  !------------------------------------------------------------------------
  character(len=*), intent(in) :: task ! Caller (MX or UV_MAP)
  character(len=*), intent(in) :: line ! Command line
  logical, intent(out) :: error
  !t
  character(len=1), parameter :: question_mark='?'
  real(8), parameter :: pi=3.14159265358979323846d0
  real(8), parameter :: f_to_k = 2.d0*pi/299792458.d-6
  !
  real ubias,vbias,ubuff(4096),vbuff(4096)
  common /conv/ ubias,vbias,ubuff,vbuff ! To be saved
  !
  real, allocatable :: w_mapu(:), w_mapv(:), w_grid(:,:)
  real, allocatable :: res_uv(:,:)
!  type (uvmap_par), save :: map
  real(8) new(3)
  real(4) rmega,uvmax,uvmin,uvma
  integer wcol,mcol(2),nfft,sblock
  integer n,ier, nsizes(3)
  logical one, sorted, shift, abort
  character(len=24) ra_c,dec_c
  character(len=message_length) :: chain
  real cpu0, cpu1
  real(8) :: freq
  real, allocatable :: fft(:)
  integer nx,ny,nu,nv,nc,np,nb
  !
  character(len=4) :: argum
  logical limits, needed
  real ylimn,ylimp
  integer ipen
  !
  type(channel_par) :: channels
  type(cct_lst) :: cct_list
  type(gridding) :: conv
  !
  call imager_tree('OLD_UVMAP')
  !
  call map_prepare(task,huv,themap,error)
  if (error) return
  !
  if (task.eq.'MX') then
    ! Test the ? argument
    if (sic_narg(0).eq.1) then
      call sic_ch(line,0,1,argum,n,.false.,error)
      if (argum(1:1).eq.question_mark) then
        call exec_program("@ i_mx "//argum)
        return
      endif
    endif
    !
    if (themap%beam.ne.0) then
      call map_message(seve%e,task,'Only works of 1 beam in total (so far)')
      error = .true.
      return
    endif
  endif
  !
  call uvmap_cols(task,line,huv,channels,error)
  if (error) return 
  mcol = channels%bounds
  wcol = channels%weight
  !
  one = .true.
  !
  call sic_get_logi('UV_SHIFT',shift,error)
  if (shift) then
     call sic_get_char('MAP_RA',ra_c,n,error)
     call sic_get_char('MAP_DEC',dec_c,n,error)
     call sic_get_dble('MAP_ANGLE',new(3),error)
  else
     new = 0.d0
  endif
  !
  ! First sort the input UV Table, leaving UV Table in UV_*
  if (shift) then
     call sic_decode(ra_c,new(1),24,error)
     if (error) then
        write(chain,'(A)') 'Input conversion error on phase center'
        call map_message(seve%e,task,chain)
        return
     endif
     call sic_decode(dec_c,new(2),360,error)
     if (error) then
        write(chain,'(A)') 'Input conversion error on phase center'
        call map_message(seve%e,task,chain)
        return
     endif
     new(3) = new(3)*pi/180.0d0
  endif
  call gag_cpu(cpu0)
  needed = themap%uniform(2).ne.0
  call uv_sort (huv,duv,error,sorted,shift,new,uvmax,uvmin,needed)
  if (error) return
  if (.not.sorted) then
    ! Redefine SIC variables (mandatory)
    call map_uvgildas('UV',huv,error,duv)
  endif
  call gag_cpu(cpu1)
  write(chain,102) 'Finished sorting ',cpu1-cpu0
  call map_message(seve%i,task,chain)
  !
  call map_parameters(task,themap,huv,freq,uvmax,uvmin,error) ! huv%gil%majo)
  if (error) return
  uvma = uvmax/(freq*f_to_k)
  !
  themap%xycell = themap%xycell*pi/180.0/3600.0
  !
  ! Get work space, ideally before mapping first image, for
  ! memory contiguity reasons.
  !
  nx = themap%size(1)
  ny = themap%size(2)
  nu = huv%gil%dim(1)
  nv = huv%gil%nvisi ! not %%dim(2)
  !
  ! Define the number of output channels
  nc = mcol(2)-mcol(1)+1
  !
  write(chain,'(A,I0,A,I0,A)') 'Imaging channel range [',mcol(1),',',mcol(2),']'
  call map_message(seve%i,task,chain)
  !
  ! Check if Weights have changed by MCOL choice
  if (any(saved_chan%bounds.ne.mcol)) do_weig = .true.
  saved_chan%bounds = mcol
  !
  !
  if (the_method%method.eq.'MX') do_weig = .true. ! Test
  if (do_weig) then
    call map_message(seve%i,task,'Computing weights ')
    if (allocated(g_weight)) deallocate(g_weight)
    if (allocated(g_v)) deallocate(g_v)
    allocate(g_weight(nv),g_v(nv),stat=ier)
    if (ier.ne.0) goto 98
  else
    call map_message(seve%d,task,'Re-using weight space')
  endif
  !
  rmega = 8.0
  ier = sic_ramlog('SPACE_MAPPING',rmega)
  sblock = max(int(256.0*rmega*1024.0)/(nx*ny),1)
  !
  ! New Beam place
  if (allocated(dbeam)) then
     call sic_delvariable ('BEAM',.false.,error)
     deallocate(dbeam)
  endif
  call gildas_null(hbeam)
  !
  ! New dirty image
  if (allocated(ddirty)) then
     call sic_delvariable ('DIRTY',.false.,error)
     deallocate(ddirty)
  endif
  allocate(ddirty(nx,ny,nc),stat=ier)
  !
  call gildas_null(hdirty)
  hdirty%gil%ndim = 3
  hdirty%gil%dim(1:3) = (/nx,ny,nc/)
  call sic_mapgildas('DIRTY',hdirty,error,ddirty)
  !
  hdirty%r3d => ddirty
  !
  ! Find out how many beams are required
  call map_beams(task,themap%beam,huv,nx,ny,nb,nc)
  !
  ! Process sorted UV Table according to the number of beams produced
  if (map_version.eq.-1 .or. task.eq.'MX') then
    ! The MX patch is temporary
    !
    ! Use old code only when explicitely requested
    hbeam%gil%ndim = 2
    hbeam%gil%dim(1:2)=(/nx,ny/)
    allocate(dbeam(nx,ny,1,1),stat=ier)
    if (ier.ne.0) then
      call map_message(seve%e,task,'Memory allocation error on DBEAM')
      error =.true.
      return
    endif
    !
    nfft = 2*max(nx,ny)
    allocate(w_mapu(nx),w_mapv(ny),w_grid(nx,ny),fft(nfft),stat=ier)
    if (ier.ne.0) goto 98
    !
    hbeam%r3d => dbeam(:,:,:,1)
    call one_beam (task,themap,   &
       &    huv, hbeam, hdirty,   &
       &    nx,ny,nu,nv, duv,   &
       &    w_mapu, w_mapv, w_grid, &
       &    g_weight, g_v, do_weig,  &
       &    wcol,mcol,fft,   &
       &    sblock,cpu0,error,uvma)
    if (error) return
    !
    call sic_mapgildas('BEAM',hbeam,error,dbeam)
  else
    ! The MX part still needs debugging
    !
    hbeam%gil%ndim = 3
    hbeam%gil%dim(1:4)=[nx,ny,nb,1]
    if (nb.gt.1) then
      allocate(hbeam%r3d(nx,ny,nb),dbeam(nx,ny,1,nb),stat=ier)
    else
      allocate(dbeam(nx,ny,1,1),stat=ier)
      hbeam%r3d => dbeam(:,:,:,1)
    endif
    if (ier.ne.0) then
      call map_message(seve%e,task,'Memory allocation error on DBEAM')
      error =.true.
      return
    endif
    !
    call many_beams_para (task,themap,channels,   &
       &    huv, hbeam, hdirty,   &
       &    nx,ny,nu,nv, duv,   &
       &    g_weight, do_weig,  &
       &    sblock,cpu0,error,uvma,0,abort,0)
    if (abort) then
      call map_message(seve%w,task,'Aborted by user')
      error = .true.
      return
    endif
    !
    hdirty%loca%addr = locwrd(ddirty)
    call gdf_get_extrema (hdirty,error)
    !
    ! Re-shape the beam, and reset the 4-D pointer, 
    ! but show it as a 3-D array in SIC
    if (nb.gt.1) then
      dbeam(:,:,:,:) = reshape(hbeam%r3d,[nx,ny,1,nb])
      deallocate(hbeam%r3d)
    endif
    call sic_mapgildas('BEAM',hbeam,error,dbeam)
    !
    hbeam%r4d => dbeam
    hbeam%gil%dim(1:4)=[nx,ny,1,nb]
    hbeam%gil%ndim = 4
    !
    ! Transpose the header appropriately
    hbeam%gil%convert(:,4) = hbeam%gil%convert(:,3)
    hbeam%gil%faxi = 4
    hbeam%char%code(4) = 'VELOCITY' ! Frequency would be better...
    hbeam%gil%convert(:,3) = 1.d0
    hbeam%char%code(3) = 'FIELD'    ! Pseudo-mosaic
    hbeam%gil%ndim = 4
    !
    hbeam%loca%addr = locwrd(dbeam)
    call gdf_get_extrema (hbeam,error)
  endif
  save_data(code_save_beam) = .true.
  save_data(code_save_dirty) = .true.
  !
  call new_dirty_beam
  !
  ! Define Min Max
  d_max = hdirty%gil%rmax
  if (hdirty%gil%rmin.eq.0) then
     d_min = -0.03*hdirty%gil%rmax
  else
     d_min = hdirty%gil%rmin
  endif
  !
  if (task.ne.'MX') goto 99
  !
!!!---------------------------------------------------
  !
  ! Prepare MX part
  limits = sic_present(1,1)
  if (limits) then
     call sic_r4 (line,1,1,ylimn,.true.,error)
     if (error) return
     call sic_r4 (line,1,2,ylimp,.true.,error)
     if (error) return
  else
     ylimp = sqrt (float(the_method%m_iter+200) *   &
          &      log(float(the_method%m_iter+1)) ) * the_method%gain
     if (-hdirty%gil%rmin.gt.1.3*hdirty%gil%rmax) then
        ylimn = ylimp*hdirty%gil%rmin
        ylimp = 0.0
     elseif (-1.3*hdirty%gil%rmin.gt.hdirty%gil%rmax) then
        ylimn = 0.0
        ylimp = ylimp*hdirty%gil%rmax
     else
        ylimn = ylimp*hdirty%gil%rmin
        ylimp = ylimp*hdirty%gil%rmax
     endif
  endif
  np = max(1,hprim%gil%dim(1))
  !
  ! Data checkup
  call clean_data (error)
  if (error) return
  !
  ! Copy the UV Data (eh eh)
  allocate (res_uv(nu,nv),stat=ier)
  res_uv(:,:) = duv
  !
  ! Get the right pointers before starting...
  hclean%r3d => dclean
  hresid%r3d => dresid
  dresid(:,:,:) = ddirty
  hbeam%r4d => dbeam ! Also required for MX
  !
  ! Parameter Definitions
  call beam_unit_conversion(user_method)
  call copy_method(user_method,the_method)
  the_method%method = 'MX'
  the_method%pflux = sic_present(1,0)
  the_method%pcycle = sic_present(2,0)
  the_method%qcycle = sic_present(3,0)
  the_method%pclean = .false.
  the_method%pmrc = .false.
  !
  call sic_get_inte('FIRST',the_method%first,error)
  call sic_get_inte('LAST',the_method%last,error)
  if (the_method%first.eq.0) the_method%first = 1
  if (the_method%last.eq.0) the_method%last = hdirty%gil%dim(3)
  the_method%first = max(1,min(the_method%first,hdirty%gil%dim(3)))
  the_method%last = max(the_method%first,min(the_method%last,hdirty%gil%dim(3)))
  !
  ! Other parameters
  if (the_method%patch(1).ne.0) then
     the_method%patch(1) = min(the_method%patch(1),nx)
  else
     the_method%patch(1) = min(nx,max(32,nx/4))
  endif
  if (the_method%patch(2).ne.0) then
     the_method%patch(2) = min(the_method%patch(2),nx)
  else
     the_method%patch(2) = min(nx,max(32,nx/4))
  endif
  the_method%bzone = (/1,1,nx,ny/)
  !
  call check_area(the_method,hdirty,.false.)
  call check_mask(the_method,hdirty)
  the_method%do_mask = the_method%do_mask
  !
  ! Clean Component Structure (once it is defined, i.e. after check)
  call cct_list%reallocate(the_method%m_iter)
  !
  ! Prepare the CCT data
  nsizes = [nx,ny,nc]
  call cct_prepare(line,nsizes,the_method,task,error)
  if (error) return
  !
  if (the_method%pflux) call init_flux90(the_method,hdirty,ylimn,ylimp,ipen)
  !
  if (the_method%pcycle) call init_plot(the_method,hdirty,dresid)
  !
  ! Perform the cleaning
  conv%ubias = ubias
  conv%vbias = vbias
  conv%ubuff = ubuff
  conv%vbuff = vbuff
  !
  call mx_clean (themap,huv,res_uv,g_weight,g_v,       &
       &    the_method,hdirty,hbeam,hclean,hresid,hprim,   &
       &    w_grid,w_mapu,w_mapv,cct_list,dcct,d_mask,d_list,      &
       &    sblock, cpu0, uvma, conv)
  !
  if (the_method%pflux) then
    call close_flux90(ipen,error)
  else
    call gr_execl('CHANGE DIRECTORY <GREG')
  endif
  !
  ! Reset extrema
  hresid%gil%extr_words = 0
  hclean%gil%extr_words = 0
  !
  ! Specify clean beam parameters
  hclean%gil%reso_words = 3
  hclean%gil%majo = the_method%major
  hclean%gil%mino = the_method%minor
  hclean%gil%posa = pi*the_method%angle/180.0
  ! Specify clean beam parameters
  hbeam%gil%reso_words = 3
  hbeam%gil%majo = the_method%major
  hbeam%gil%mino = the_method%minor
  hbeam%gil%posa = pi*the_method%angle/180.0
  save_data(code_save_clean) = .true.
  the_method%nlist = the_method%nlist
  !
  ! Defines the CCT variable
  call sic_mapgildas ('CCT',hcct,error,dcct)
  !
  ! Cleanup
  deallocate(cct_list%cc)
  error = .false.
  !
99 continue
  if (allocated(w_mapu)) deallocate(w_mapu)
  if (allocated(w_mapv)) deallocate(w_mapv)
  if (allocated(w_grid)) deallocate(w_grid)
  if (allocated(fft)) deallocate(fft)
  return
  !
98 call map_message(seve%e,task,'Memory allocation failure')
  error = .true.
  return
  !
102 format(a,f9.2)
end subroutine old_uvmap
!
subroutine old_major_multi90 (rname,method,head,   &
     &    beam,nx,ny,mx,my,            &
     &    dirty,resid,mask,clean,      &
     &    tcc,siter,miter,limit,niter, &
     &    smask, sresid, trans, cdata, sbeam, &
     &    tfbeam, wfft, mcct, nker, kernel, &
     &    np, primary, weight)    ! For mosaics
  use gbl_ansicodes
  use imager_interfaces, except_this=>old_major_multi90
  use gkernel_interfaces
  use image_def
  use gbl_message
  use clean_def
  use clean_default
  use omp_control
  !$  use omp_lib
  !-----------------------------------------------------------------------
  ! @ public-mandatory
  !
  ! IMAGER
  !     Multi-Resolution CLEAN - with NS (parameter) scales
  !
  !     Algorithm
  !     For each iteration, search at which scale the signal to noise
  !     is largest. Use the strongest S/N to determine the "component"
  !     intensity and shape at this iteration.
  !
  !     Restore the ("infinite" resolution) image from the list of location
  !     types, and intensities of the "components"
  !
  !     The noise level at each scale is computed from the Fourier transform
  !     of the smoothed dirty beams, since the FT is the weight distribution
  !     and the noise level is the inverse square root of the sum of the
  !     weights.
  !-----------------------------------------------------------------------
  character(len=*), intent(in) :: rname
  type (clean_par), intent(inout) :: method
  type (gildas), intent(inout) :: head         ! Unused, but here for consistency...
  real, intent(in)  :: beam(:,:,:)             ! Dirty beams
  integer, intent(in)  :: nx,ny                ! Beam sizes
  integer, intent(in)  :: mx,my                ! Image size
  integer, intent(in) :: np                    ! Number of Pointings
  integer, intent(in)  :: siter                ! Starting Iteration
  integer, intent(in)  :: miter                ! Maximum number of clean components
  integer, intent(out) :: niter                ! Number of found components
  real, intent(in)  :: dirty(:,:)              ! Dirty image
  real, intent(inout) :: resid(:,:)            ! Residual image (initialized to Dirty image)
  real, intent(inout) :: clean(:,:)            ! "CLEAN" image (not convolved yet)
  real, intent(in) :: weight(:,:)              ! Combined weights
  logical, intent(in)  :: mask(:,:)            ! Search area
  real, intent(in)  :: limit                   ! Maximum residual
  real, intent(in)  :: tfbeam(:,:,:)           ! Real Beam TF for final Clean restoration
  real, intent(inout) :: wfft(*)               ! Work space for FFT
  type (cct_par), intent(out) :: tcc(miter)
  integer, intent(out) :: nker(:)              ! Kernel sizes
  real, intent(out) :: kernel(:,:,:)           ! Smoothing kernel values
  ! So far, big ones
  real, intent(in) :: primary(np, mx, my)      ! Primary beams
  !
  integer, intent(out) :: mcct                 ! Number of separate Clean components
  !
  ! Work spaces - In call sequence
  real, intent(inout) ::  sbeam(:,:,:)         ! Smoothed beams
  real, intent(inout) ::  sresid(:,:)          ! Smoothed residuals
  real, intent(inout) ::  trans(:,:)           ! Translated beam  
  complex, intent(inout) ::  cdata(:,:)        ! Work array
  logical, intent(inout) ::  smask(:,:)        ! Smoothed mask
  !
  ! Local work variables
  integer :: dimcum, ncum, nchain
  integer nn(2), ndim, kx,ky
  integer is,i,j, oldis, goodis
  real, allocatable :: oldcum(:)
  real value, converge, sign, lastcum
  real maxa,flux,smooth,gain,maxsn,worry
  logical ok, plot, printout, interrupt
  character(len=message_length) :: chain
  character(len=24) :: string
  !
  ! Kernel related ones
  integer, parameter :: ms=3
  integer, parameter :: mk=11
  integer  ns                  ! Number of Kernels
  integer max_nker             ! Last kernel used
  real scale(ms)               ! Noise level for each beam - in ReadOnly
  real sn(ms)                  ! Signal / Noise - used in ReadOnly
  real gains(ms)               ! Gain per kernel 
  real fluxes(ms)              ! Cumulative flux per kernel
  real loss(ms)                ! Noise degradation factor...
  !
  integer ncase(ms)            ! Number of components per kernel case
  real bruit(ms)               ! Residual level for each kernel
  integer ix(ms),iy(ms)        ! Coordinates of each iteration maximum
  !
  integer :: nf                ! Number of frequency planes (=1)
  integer :: ip                ! Current pointing
  integer :: ic,nc             ! Current component and Number of components
  integer :: lx,ly             ! Current pixel and Offset from center
  real :: kcct(3,1,mk**2)      ! "Bulk" component decomposition
  real :: maxp                 ! Current Clean value
  integer :: counter
  integer :: clean_slow=0      ! Precision and Speed control code (for tests)
  integer :: step_iter         ! Printout every Step_Iter component
  logical :: error, detail
  !
  ! real, allocatable :: lbeam(:,:)  ! Local beam (average of all dirty beams)
  !
  logical :: debug=.false.
  logical :: err
  integer :: nnt(3)
  !
  integer :: fs,ls, ncount, mthread
  !
  nnt = [mx,my,1]
  err = .false.
  call v_size_r4_2('DIRTY',dirty,nnt,err)
  call v_size_r4_2('RESID',resid,nnt,err)
  call v_size_r4_2('CLEAN',clean,nnt,err)
  call v_size_r4_3('TFBEAM',tfbeam,nnt,err)
  call v_size_r4_2('SRESID',sresid,nnt,err)
  if (np.gt.1) call v_size_r4_2('WEIGHT',weight,nnt,err)
  call v_size_r4_2('TRANS',trans,nnt,err)
  call v_size_l4_2('SMASK',smask,nnt,err)
  nnt = [nx,ny,np]
  call v_size_r4_3('BEAM',beam,nnt,err)
  nnt = [nx,ny,3]
  call v_size_r4_3('SBEAM',sbeam,nnt,err)
  if (err) then
    call map_message(seve%e,rname,'Size error')
    error = .true.
    return
  endif
!  complex, intent(inout) ::  cdata(:,:)        ! Work array
!  logical, intent(inout) ::  smask(:,:)        ! Smoothed mask
!  logical, intent(in)  :: mask(:,:)            ! Search area
!  real, intent(in)  :: limit                   ! Maximum residual
!
  step_iter = multi_print
  if (multi_print.eq.0) step_iter = 1000
  !
  call sic_get_logi('DEBUG',debug,error)
  error = .false.
  call sic_get_inte('CLEAN_SLOW',clean_slow,error)
  clean_slow = min(clean_slow,3)
  if (clean_slow.lt.0) then
    call map_message(seve%w,rname,'Using approximate MultiScale method - Try CLEAN_SLOW = 0 for better result')
  else if (clean_slow.ne.0) then
    call map_message(seve%w,rname,"Speed set to CLEAN_SLOW "//char(clean_slow+ichar('0')))
  endif
  !
  dimcum = method%converge
  allocate(oldcum(max(1,dimcum)))
  !
  smooth = method%smooth
  gain = method%gain
  plot = method%pflux
  nker = method%nker
  printout = method%verbose  .or. debug ! Default behaviour
  gains = method%gains
  worry = method%worry
  !
  ! Initialize the kernel
  interrupt = .false.
  kernel = 0.0
  ns = 1
  nker(1) = 1
  kernel = 0.0
  kernel(1,1,1) = 1.0
  !
  nker = method%nker
  if (nker(2).gt.0) then
    call init_kernel(kernel(:,:,2),mk,nker(2),smooth)
    ns = 2
    if (nker(3).gt.0) then
      smooth = smooth**2
      call init_kernel(kernel(:,:,3),mk,nker(3),smooth)
      ns = 3
    endif
  endif
  max_nker = ns
  ncase(1:ms) = 0
  fluxes(:) = 0.0
  trans(:,:) = 0.0
  !
  ! Initialize smoothed beams & mask
  call smooth_mask (mask,smask,mx,my,nker(ns))
  !
  kx = nx/2+1
  ky = ny/2+1
  ! 
  ! Build an average dirty beam for mosaics
  sbeam(:,:,1) = beam(:,:,1)
  do ip=2,np
    sbeam(:,:,1) = sbeam(:,:,1) + beam(:,:,ip)
  enddo
  if (np.ne.1) sbeam(:,:,1) = sbeam(:,:,1)/np
  !
  ! Get the scale factors and sensitivity loss
  loss(1)  = 1.0
  scale(1) = 1.0
  ! 
  ! Use the average dirty beams to estimate these factors
  do is = 2,ns
    call smooth_kernel (sbeam(:,:,1),sbeam(:,:,is),nx,ny,mk,nker(is),kernel(:,:,is))
    value = 1.0/sbeam(kx,ky,is)
    loss(is) = sqrt(value)
    scale(is) = value
    sbeam(:,:,is) = sbeam(:,:,is)*value      ! Now normalized
    kernel(:,:,is) = kernel(:,:,is)*value    ! Corresponding Kernel
  enddo
  !
  write(chain,'(2(A,3(1X,F5.3)))') 'Scales ',scale,'; Noise loss ',loss
  call map_message(seve%i,rname,chain)
  !
  ! Main clean loop
  niter = siter-1      ! Start at siter
  ok = niter.lt.miter
  flux = 0.0
  !
  ! Initialize convergence test
  call amaxmask (resid,mask,mx,my,ix(1),iy(1))
  if (resid(ix(1),iy(1)).gt.0.0) then
    sign = 1.0
  else
    sign =-1.0
  endif
  ncum = 1
  converge = 0.0
  oldcum = 0.0
  oldis = 0
  goodis = 1   ! To prevent compiler warning only..
  maxsn = 0    ! Also
  sn =    0 ! Make sure they are all initialized
  !
  counter = 0
  ncount = 0
  if (clean_slow.lt.0) then
    ncount = -clean_slow ! Test
    clean_slow = -2
  endif
  !
  detail = .false.    ! Debug test message
  !
  mthread = 1
  !$  mthread = omp_get_max_threads()
  !$  if (omp_in_parallel()) then
  !$    if (omp_get_nested()) then
  !$      ! Further optimisation requires to know the number of Outer Threads
  !$      mthread = omp_inner_thread
  !$      if (omp_debug) Print *,'Already in parallel mode, Outer THREAD ',omp_outer_thread,' Inner ',omp_inner_thread
  !$    else
  !$      mthread = 1
  !$      if (omp_debug) Print *,'Already in parallel mode, Outer THREAD ',omp_outer_thread,' No Inner threads'
  !$    endif
  !$  else
  !$    mthread = omp_inner_thread
  !$    if (omp_get_nested()) then
  !$      if (omp_debug) Print *,'Activating nesting ',omp_get_max_threads(),' possible, used ',mthread
  !$    else
  !$      if (omp_debug) Print *,'No parallel, and No nesting either, ',mthread
  !$    endif
  !$  endif
  !
  do           ! For ever...
    if (ncount.eq.0) then
      fs = 1
      ls = ns
    else if (mod(counter,ncount).eq.0) then
      fs = 1
      ls = max_nker
      oldis = 0 ! Ensure printout can happen
    else
      fs = oldis
      ls = oldis
    endif
    counter = counter+1
    !
    ! Locate the Clean Component - The Smoothed Beams do not intervene here,
    ! only the Normalized Kernel and Smoothed Mask
    maxa = -1.0
    do is = fs,ls
      if (is.eq.1) then
        call amaxmask (resid,mask,mx,my,ix(1),iy(1))
        bruit(1) = resid(ix(1),iy(1))
      else
        !
        ! Smooth within (smoothed) mask
        call smooth_masked(mx,my,sresid,resid,smask,mk,nker(is),kernel(:,:,is))
        !
        ! Use MASK or SMASK, more or less at will...
        call amaxmask (sresid,mask,mx,my,ix(is),iy(is))
        bruit(is) = sresid(ix(is),iy(is))
      endif
      !
      if (debug) print *,is, 'Bruit ',bruit(is),' Loss ',loss(is)
      sn(is) = abs(bruit(is)/loss(is))
      if (sn(is).gt.maxa) then
        maxa = sn(is)
        goodis = is
      endif
    enddo
    !
    if (debug) then
      Print *,'Good ',goodis,'Bruit ',bruit,' Loss ',loss,' S/N ',sn  !Debug
      if (counter.lt.10) then
        is = goodis
        Print *,Counter,is,' IX IY ',ix(is),iy(is),' Resid ',sresid(ix(is),iy(is)),bruit(is) !Debug
      endif
    endif
    !
    if (niter.lt.siter) maxsn = sn(goodis)
    !
    ! Check criterium
    ok = niter.lt.miter
    ok = ok .and. abs(bruit(1)).ge.limit
    if (.not.ok) exit
    if (sn(goodis).gt.maxsn) then
      ok = .false.  ! Stop if S/N has degraded
      exit
    endif
    maxsn = worry*sn(goodis)+(1.0-worry)*maxsn  ! Propagate S/N estimate
    if (debug) Print *,'Counter ',counter,' Maxsn ',maxsn,goodis,sn(goodis)
    !
    niter = niter+1
    !
    value = gains(goodis)*bruit(goodis)
    if (np.gt.1) then
      value = value * weight(ix(goodis),iy(goodis))    ! Convert to Clean component
    endif
    tcc(niter)%value = value 
    tcc(niter)%ix = ix(goodis)
    tcc(niter)%iy = iy(goodis)
    tcc(niter)%size = -goodis   ! Kernel number
    !
    ! Do not Scale component flux : See Note Later (#1)
    flux = flux + tcc(niter)%value*scale(goodis)
    !
    ! Check flux stability - Switch to the accurate method when
    ! approaching convergence 
    if (dimcum.ne.0) then
      ! Keep last DIMCUM cumulative fluxes to test convergence
      oldcum(mod(niter,dimcum)+1) = flux
      lastcum = oldcum(mod(niter+1,dimcum)+1)
      converge = sign * (flux - lastcum) 
      if (clean_slow.lt.0) then
        if (abs((flux-lastcum)/flux).lt.0.05) then
          clean_slow = 0
          call map_message(seve%i,rname,'Switching to precise mode') 
          max_nker = 1
          oldis = 0
        endif
      endif 
    endif
    !
    ! Plot the new point
    !! detail = weight(ix(goodis),iy(goodis)).gt.2 ! Test
    if ((printout.and.(goodis.ne.oldis)).or.(mod(niter,step_iter).eq.0)) then
      if (goodis.eq.1) then
        write(chain,101) niter,ix(goodis),iy(goodis),   &
     &            c_red,sn(1),c_clear,sn(2),sn(3),bruit(goodis)*loss(goodis) &
     &            ,weight(ix(goodis),iy(goodis))
      elseif (goodis.eq.2) then
        write(chain,102) niter,ix(goodis),iy(goodis),   &
     &            sn(1),c_green,sn(2),c_clear,sn(3),bruit(goodis)*loss(goodis) &
     &            ,weight(ix(goodis),iy(goodis))
      elseif (goodis.eq.3) then
        write(chain,103) niter,ix(goodis),iy(goodis),   &
     &            sn(1),sn(2),c_blue,sn(3),c_clear,bruit(goodis)*loss(goodis) &
     &            ,weight(ix(goodis),iy(goodis))
      endif
      call map_message(seve%i,rname,chain)
    endif
    ! In all cases
    oldis = goodis
    ncase(goodis) = ncase(goodis)+1
    ! Scale cumulative flux : See Note Later
    fluxes(goodis) = fluxes(goodis) + value*scale(goodis)
    if (plot) then
      is = goodis
      call next_flux90(niter,flux,is)
    endif
    !
    ! Subtract from residual
    !
    maxa = -value  ! This is the Clean Component to be subtracted
    !
    ! Pixel offset in small beam (not in large map)
    kx = ix(goodis)-nx/2-1 
    ky = iy(goodis)-ny/2-1
    lx = ix(goodis)
    ly = iy(goodis)
    !
    if (np.eq.1) then
      !
      ! Translate appropriate beam
      !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
      !$OMP   &   SHARED(resid,sbeam)  &
      !$OMP   &   SHARED(mx,my,nx,ny,kx,ky,ip,maxa,goodis) &
      !$OMP   &   PRIVATE(i,j)
      !$OMP DO COLLAPSE(2)
      do j=max(1,ky+1),min(my,ny+ky)
        do i=max(1,kx+1),min(mx,nx+kx)
          resid(i,j) = resid(i,j) + maxa * sbeam(i-kx,j-ky,goodis)
        enddo
      enddo
      !$OMP ENDDO
      !$OMP END PARALLEL
    else
      if (clean_slow.ge.0) then
        !
        ! The accurate approach is to expand the Clean Component
        ! by the kernel, attenuate each new component by the
        ! primary beam, and subtract the list of Clean Components
        ! using the un-smoothed dirty beam
        !
        nf = 1 ! Only one frequency
        nc = 0 ! No previous component in, many out
        if (nker(goodis).eq.0) then
          nc = 1
          kcct(1,1,1) = lx !! ix(goodis)
          kcct(2,1,1) = ly !! iy(goodis)
          kcct(3,1,1) = maxa 
        else
          ! Use Large Region
          call spread_kernel (mx,my,nf,nc,kcct,maxa,lx,ly, &
            &   nker(goodis),kernel(:,:,goodis))
        endif
        !!Print *,'LX LY ',lx,ly, 'MX MY ',mx,my,nker(goodis)
        !!Print *,'NC out ',nc,goodis,maxa
        !
        ! The following sections are memory access limited
        ! Parallelism is inefficient there.
        select case(clean_slow)
        case(0)
          ! Fastest way ...
          do ip=1,np
            !
            if (nc.eq.1) then
              lx = kcct(1,1,1)
              ly = kcct(2,1,1)
              kx = lx-nx/2-1
              ky = ly-ny/2-1
              ! 
              ! Attenuate by primary beam 
              maxp = kcct(3,1,1) * primary(ip,lx,ly)
              ! Translate the original dirty beam
              !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
              !$OMP   &   SHARED(resid,beam,primary,weight) &
              !$OMP   &   SHARED(mx,my,nx,ny,kx,ky,ip,maxp) &
              !$OMP   &   PRIVATE(i,j)
              !$OMP DO COLLAPSE(2)
              do j=max(1,ky+1),min(my,ny+ky)
                do i=max(1,kx+1),min(mx,nx+kx)
                  resid(i,j) = resid(i,j) + & 
                  & maxp*beam(i-kx,j-ky,ip)*primary(ip,i,j)*weight(i,j)
                enddo
              enddo
              !$OMP ENDDO
              !$OMP END PARALLEL
              !
            else
              trans = 0.
              ! Translate the original dirty beam for each component
              do ic=1,nc
                lx = kcct(1,1,ic)
                ly = kcct(2,1,ic)
                kx = lx-nx/2-1
                ky = ly-ny/2-1
                ! Attenuate by primary beam 
                maxp = kcct(3,1,ic) * primary(ip,lx,ly)
                !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
                !$OMP   &   SHARED(trans,beam) &
                !$OMP   &   SHARED(mx,my,nx,ny,kx,ky,ip,maxp) &
                !$OMP   &   PRIVATE(i,j)
                !$OMP DO COLLAPSE(2)
                do j=max(1,ky+1),min(my,ny+ky)
                  do i=max(1,kx+1),min(mx,nx+kx)
                    trans(i,j) = trans(i,j) + beam(i-kx,j-ky,ip)*maxp
                  enddo
                enddo
                !$OMP ENDDO
                !$OMP END PARALLEL
              enddo
              ! 
              ! Remove from residual
              !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
              !$OMP   &   SHARED(resid,trans,primary,weight) &
              !$OMP   &   SHARED(mx,my,ip) PRIVATE(i,j)
              !$OMP DO COLLAPSE(2)
              do j=1,my
                do i=1,mx
                  resid(i,j) = resid(i,j) + & 
                  & trans(i,j)*primary(ip,i,j)*weight(i,j)
                enddo
              enddo
              !$OMP ENDDO
              !$OMP END PARALLEL
            endif
          enddo
          !
        case(1)
          ! Slightly slower (ratio depends on number of point sources)
          do ip=1,np
            trans = 0.
            ! Translate the original dirty beam for each component
            do ic=1,nc
              lx = kcct(1,1,ic)
              ly = kcct(2,1,ic)
              kx = lx-nx/2-1
              ky = ly-ny/2-1
              if (detail) Print *,IP,'IC ',IC,' KCCT ',KCCT(1:3,1,IC)
              ! Attenuate by primary beam 
              maxp = kcct(3,1,ic) * primary(ip,lx,ly)
              !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
              !$OMP   &   SHARED(trans,beam) &
              !$OMP   &   SHARED(mx,my,nx,ny,kx,ky,ip,maxp) &
              !$OMP   &   PRIVATE(i,j)
              !$OMP DO COLLAPSE(2)
              do j=max(1,ky+1),min(my,ny+ky)
                do i=max(1,kx+1),min(mx,nx+kx)
                  trans(i,j) = trans(i,j) + beam(i-kx,j-ky,ip)*maxp
                enddo
              enddo
              !$OMP ENDDO
              !$OMP END PARALLEL
            enddo
            ! 
            ! Remove from residual
            !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
            !$OMP   &   SHARED(trans,resid,primary,weight) &
            !$OMP   &   SHARED(mx,my,ip) PRIVATE(i,j)
            !$OMP DO COLLAPSE(2)
            do j=1,my
              do i=1,mx
                resid(i,j) = resid(i,j) + & 
                & trans(i,j)*primary(ip,i,j)*weight(i,j)
              enddo
            enddo
            !$OMP ENDDO
            !$OMP END PARALLEL
          enddo
        case(2)
          ! Slower
          do ic=1,nc
            lx = kcct(1,1,ic)
            ly = kcct(2,1,ic)
            kx = lx-nx/2-1
            ky = ly-ny/2-1
            do ip=1,np
              ! 
              ! Attenuate by primary beam 
              maxp = kcct(3,1,ic) * primary(ip,lx,ly)
              ! Translate the original dirty beam
              do j=max(1,ky+1),min(my,ny+ky)
                do i=max(1,kx+1),min(mx,nx+kx)
                  resid(i,j) = resid(i,j) + & 
                  & maxp*beam(i-kx,j-ky,ip)*primary(ip,i,j)*weight(i,j)
                enddo
              enddo
              ! 
            enddo
          enddo
          !        
        case (3)
          ! Really slow
          do ic=1,nc
            lx = kcct(1,1,ic)
            ly = kcct(2,1,ic)
            kx = lx-nx/2-1
            ky = ly-ny/2-1
            do ip=1,np
              trans = 0. !
              ! Translate the original dirty beam
              do j=max(1,ky+1),min(my,ny+ky)
                do i=max(1,kx+1),min(mx,nx+kx)
                  trans(i,j) = beam(i-kx,j-ky,ip) 
                enddo
              enddo
              ! 
              ! Attenuate by primary beam 
              maxp = kcct(3,1,ic) * primary(ip,lx,ly)
              ! 
              do j=1,my
                do i=1,mx
                  resid(i,j) = resid(i,j) + & 
                  & maxp*trans(i,j)*primary(ip,i,j)*weight(i,j)
                enddo
              enddo
            enddo
          enddo
          !
        end select
      else ! if (clean_slow.lt.0) then 
        !
        ! This code is incorrect for two reasons.
        !
        ! 1) Fundamental
        !   A smooth beam per pointing would not represent the properly attenuated
        !   Clean component list.
        !     It would only be an approximate solution, but which could work
        !   in a Minor / Major cycle, where the faster, but approximate
        !   solution is used in Minor Cycles, but the accurate version
        !   is used in Major Cycles by Fourier Transform.
        ! 2) Circumstancial (due to lazyness)
        !   We do not have a smoothed beam per pointing, but only one 
        !   so far.
        !
        ! Yet, it works surprisingly well by a combination of several reasons
        ! 1)  The code is correct for point sources
        ! 2)  The approximation is limited for Extended sources near a
        !     pointing center
        ! 3)  Dirty beams are reasonably similar from pointing to pointing
        !     so Smoothed beams too.
        ! 4)  The deconvolution method is self-correcting: improperly
        !     removed components are corrected later by components at
        !     a different scale ...
        ! 
        select case(clean_slow)
        !
        case (-2)
          ! Most efficient
          do ip=1,np
            ! 
            ! Globally attenuate by primary beam -- There is an issue here
            ! since normally each individual Clean Component should
            ! have a different attenuation
            !
            maxp = maxa * primary(ip,lx,ly)
            ! 
            !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
            !$OMP   &   SHARED(resid,sbeam,primary,weight) &
            !$OMP   &   SHARED(mx,my,nx,ny,kx,ky,ip,maxp,goodis) &
            !$OMP   &   PRIVATE(i,j)
            !$OMP DO COLLAPSE(2)
            do j=max(1,ky+1),min(my,ny+ky)
              do i=max(1,kx+1),min(mx,nx+kx)
                resid(i,j) = resid(i,j) + & 
                & maxp*sbeam(i-kx,j-ky,goodis)*primary(ip,i,j)*weight(i,j)
              enddo
            enddo
            !$OMP ENDDO
            !$OMP END PARALLEL
          enddo
          !
        case (-1)
          ! Slightly slower
          do ip=1,np
            trans = 0. !
            ! Translate the appropriate smoothed dirty beam
            !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
            !$OMP   &   SHARED(trans,sbeam) &
            !$OMP   &   SHARED(mx,my,nx,ny,kx,ky,goodis) &
            !$OMP   &   PRIVATE(i,j)
            !$OMP DO COLLAPSE(2)
            do j=max(1,ky+1),min(my,ny+ky)
              do i=max(1,kx+1),min(mx,nx+kx)
                trans(i,j) = sbeam(i-kx,j-ky,goodis) ! WRONG, should be IP dependent (one per pointing)
              enddo
            enddo
            !$OMP ENDDO
            !$OMP END PARALLEL
            ! 
            ! Globally attenuate by primary beam -- There is an issue here
            ! since normally each individual Clean Component should
            ! have a different attenuation
            !
            maxp = maxa * primary(ip,lx,ly)
            ! 
            !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
            !$OMP   &   SHARED(resid,trans,primary,weight) &
            !$OMP   &   SHARED(mx,my,nx,ny,kx,ky,ip,maxp) &
            !$OMP   &   PRIVATE(i,j)
            !$OMP DO COLLAPSE(2)
            do j=1,my
              do i=1,mx
                resid(i,j) = resid(i,j) + & 
                & maxp*trans(i,j)*primary(ip,i,j)*weight(i,j)
              enddo
            enddo
            !$OMP ENDDO
            !$OMP END PARALLEL
          enddo
          !
        end select
      endif
    endif
!
    if (dimcum.gt.0) ok = ok.and.(converge.ge.0.0)
    if (.not.ok) exit
    if (sic_ctrlc()) then
      interrupt = .true.
      exit
    endif
  enddo
  !
  if (niter.eq.miter) then
    string = 'iteration limit'
  else if (sn(goodis).gt.maxsn) then
    string = 'signal to noise stability'
  else if (dimcum.gt.0.and.converge.lt.0.0) then
    string = 'flux convergence'
  else if (interrupt) then
    string = 'User ^C interrupt'
  else
    string = 'residual limit'
  endif
  write(chain,104) 'Stopped by ',trim(string),niter,bruit(1),limit
  call map_message(seve%d,rname,chain)
  nchain = 1
  do is=1,ns
    write(chain(nchain:),105) is,ncase(is),fluxes(is)
    nchain = len_trim(chain)+2
  enddo
  call map_message(seve%i,rname,chain)
  !
  ! Done: RESTORATION Process now
  clean = 0.0
  !
  ! If CCT component flux are not scaled, use the Kernel as they are
  ! If they are scaled,  normalize them to 1 back again...
  !
  ! Here they are NOT scaled (see comment Above)
  !
  mcct = 0
  do i=1,niter
    value = tcc(i)%value
    kx = tcc(i)%ix
    ky = tcc(i)%iy
    is =  -nint(tcc(i)%size)
    if (is.le.1) then         ! May have Type = 0 if restarted      
      clean (kx,ky) = clean(kx,ky) + value
      mcct = mcct+1
    else
      call add_kernel (clean,mx,my,value,kx,ky,mk,nker(is),kernel(:,:,is))
      mcct = mcct+nker(is)**2 ! Maximum value
    endif
  enddo
  !
  ! Final residual
  !
  if (np.eq.1) then
    ! This is only valid for a single field. 
    cdata = cmplx(clean,0.0)
    ndim = 2
    nn(1) = mx
    nn(2) = my
    call fourt(cdata,nn,ndim,-1,1,wfft)
    cdata = cdata*tfbeam(:,:,1)            ! Complex by Real multiplication
    call fourt(cdata,nn,ndim,1,1,wfft)
    resid = dirty-real(cdata)
  else  
    ! For mosaic, use the Weight - We already have the Residual here...
    ! resid = dirty-real(cdata)*weight
  endif
  !
  ! Convolution with clean beam is done outside
  if (debug) print *,'Returning'
  return
  !
  101   format(i6,i5,i5,a,' [',1pg11.4,'] ',a,1pg11.4,2x,1pg11.4,'  = ',   &
     &    1pg11.4,1pg11.4)
  102   format(i6,i5,i5,2x,1pg11.4,a,' [',1pg11.4,'] ',a,1pg11.4,'  = ',   &
     &    1pg11.4,1pg11.4)
  103   format(i6,i5,i5,2x,1pg11.4,2x,1pg11.4,a,' [',1pg11.4,'] = ',a,   &
     &    1pg11.4,1pg11.4)
  104   format(a,a,i6,1x,1pg11.4,1x,1pg11.4)
  105   format(('#',i0,' Ncct ',i0,' Flux ',1pg11.4))
  !
end subroutine old_major_multi90
!
subroutine old_hogbom_cycle90 (rname,pflux, beam,mx,my,resid,nx,ny,               &
     &    ixbeam,iybeam, box, fracres, absres, miter, piter, niter,          &
     &    gainloop, converge, cct, msk, list, nl, np, primary, weight, wtrun, &
     &    cflux, jcode, next_flux)
  use gkernel_interfaces
  use imager_interfaces, except_this=>old_hogbom_cycle90
  use clean_def
  use clean_default
  use gbl_message
  use omp_control
  !$ use omp_lib
  !----------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER    Support routine for HOGBOM
  !     Deconvolve map into residual map and source list
  !-----------------------------------------------------------------------
  external :: next_flux                       ! Cumulative flux display
  character(len=*), intent(in) :: rname       ! Calling command
  logical, intent(in) :: pflux                ! Plot cumulative flux ?
  integer, intent(in) :: mx                   ! X size of beam
  integer, intent(in) :: my                   ! Y size of beam
  integer, intent(in) :: nx                   ! X size of image
  integer, intent(in) :: ny                   ! Y size of image
  integer, intent(in) :: np                   ! Number of fields
  real, intent(in) :: beam(mx,my,np)          ! Primary beam(s)
  real, intent(inout) :: resid(nx,ny)         ! residual image
  real, intent(in) :: fracres                 ! Fractional residual
  real, intent(in) :: absres                  ! Absolute residual
  integer, intent(in) :: miter                ! Maximum number of clean components
  integer, intent(in) :: ixbeam, iybeam       ! Beam maximum position
  integer, intent(in) :: box(4)               ! Cleaning box
  real, intent(in) :: gainloop                ! Clean loop gain
  integer, intent(in) :: converge             ! Convergence iteration number 
  integer, intent(out) :: niter               ! Iterations
  integer, intent(in) :: piter                ! Positive Iterations
  logical, intent(in) :: msk(nx,ny)           ! Mask for clean search
  integer, intent(in) :: nl                   ! Size of search list
  integer, intent(in) :: list(nl)             ! Search list
  real, intent(in) :: primary(np,nx,ny)       ! Primary beams
  real, intent(in) :: weight(nx,ny)           ! Weight function
  real, intent(in) :: wtrun                   ! Safety threshold on primary beams
  type (cct_par), intent(out) :: cct(miter)   ! Clean Component Table
  integer, intent(out) :: jcode               ! Stopping code
  real, intent(out) :: cflux                  ! Cleaned Flux
  !
  ! Local
  logical ok
  integer :: dimcum
  real, allocatable :: oldcum(:)
  real cum, conv, sign
  real valmax, valmin, f, vnew, borne, gain
  integer i, j, ix, iy, ip, imax, jmax, imin, jmin, k, l
  character(len=message_length) :: chain
  !
  integer, allocatable :: imax_it(:), jmax_it(:)
  real, allocatable :: vnew_it(:)
  integer :: it, ier, nthread, mthread, ithread
  !
  dimcum = converge
  allocate(oldcum(max(1,dimcum)),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,rname,'Memory allocation error')
    return
  endif
  !
  oldcum = 0.0
  !
  ! Find highest point in region to be searched
  call maxlst (resid,nx,ny,list,nl,valmax,imax,jmax,   &
     &    valmin,imin,jmin)
  write(chain,'(A,1PG10.3,A,I6,I6,A,1PG10.3,A,I6,I6)') &
    &   'Map max. ',valmax,' at ',imax,jmax,  &
    &   ', Min. ',valmin,' at ',imin,jmin
  call map_message(seve%i,rname,chain)
  !
  ! Subtract +ve and -ve peaks
  niter = 0
  if (niter.lt.piter) then
    vnew = valmax
    ix = imax
    iy = jmax
    sign = 1.0
  elseif (abs(valmin) .gt. abs(valmax)) then
    vnew = valmin
    ix = imin
    iy = jmin
    sign = -1.0
  else
    vnew = valmax
    ix = imax
    iy = jmax
    sign = 1.0
  endif
  !
  ! Setup Subtraction loop
  cum    = 0.
  niter  = 0
  conv   = 0.
  borne = max(absres,fracres*abs(vnew))
  if (np.le.1) then
    gain = gainloop / beam(ixbeam,iybeam,1)
  else
    gain = gainloop
  endif
  !
  ! Main subtraction loop
  mthread = 1
  !$  mthread = omp_get_max_threads()
  !$  if (omp_in_parallel()) then
  !$    if (omp_get_nested()) then
  !$      ! Further optimisation requires to know the number of Outer Threads
  !$      mthread = omp_inner_thread
  !$      if (omp_debug) Print *,'Already in parallel mode, Outer THREAD ',omp_outer_thread,' Inner ',omp_inner_thread
  !$    else
  !$      mthread = 1
  !$      if (omp_debug) Print *,'Already in parallel mode, Outer THREAD ',omp_outer_thread,' No Inner threads'
  !$    endif
  !$  else
  !$    mthread = omp_inner_thread
  !$    if (omp_get_nested()) then
  !$      if (omp_debug) Print *,'Activating nesting ',omp_get_max_threads(),' possible, used ',mthread
  !$    else
  !$      if (omp_debug) Print *,'No parallel, and No nesting either, ',mthread
  !$    endif
  !$  endif
  allocate(vnew_it(mthread),imax_it(mthread),jmax_it(mthread),stat=ier)
  if (ier.ne.0) then
    write(chain,'(A,I4)') 'Memory allocation error for Mthread ',mthread
    call map_message(seve%e,rname,chain)
    return
  endif
  !
  ok = niter.lt.miter .and. abs(vnew).gt.borne
  !
  !!Print *,'VNEW at start ',vnew
  do while (ok)
    !
    ! Get the component flux
    niter = niter+1
    f = vnew * gain
    if (np.gt.1) then
      f = f * weight(ix,iy)    ! Convert to Clean component
    endif
    cct(niter)%value = f       ! Store as fractions of beam max
    cct(niter)%ix = ix
    cct(niter)%iy = iy
    cct(niter)%size = 0
    !
    cum = cum + f
    if (dimcum.ne.0) then
      !
      ! Keep last DIMCUM cumulative fluxes to test convergence
      oldcum(mod(niter,dimcum)+1) = cum
      conv = sign * (cum - oldcum(mod(niter+1,dimcum)+1))
    endif
    !
    ! Plot the new point
    if (pflux) call next_flux(niter,cum,0)
    !
    ! Subtract previous component from residual map
    nthread = 1
    !
    ! Parallel programming comment:
    ! Note that the gain is significant only in case of enough primary beams.
    ! It may slow down the method quite significantly otherwise, unless
    ! the number of inner threads has been properly evaluated.
    !
    !$OMP PARALLEL DEFAULT(none) NUM_THREADS(mthread) &
    !$OMP   &   SHARED(beam,resid,primary,weight,msk) &
    !$OMP   &   SHARED(nx,ny,mx,my,np,box,niter,piter,wtrun) &
    !$OMP   &   SHARED(vnew_it,imax_it,jmax_it) &
    !$OMP   &   SHARED(ixbeam,iybeam,f)  SHARED(ix,iy) &
    !$OMP   &   PRIVATE(j,l,i,k,ip,ithread) SHARED(nthread,omp_debug)
    !
    ithread = 1
    !$  nthread = omp_get_num_threads()
    !$  ithread = omp_get_thread_num()+1
    !$  if (omp_debug.and.niter.eq.1) Print *,'Inner Hogbom Nthread ',nthread,' Ithread ',ithread
    !
    vnew_it(ithread)  = 0
    !$OMP DO SCHEDULE(STATIC,1) 
    !$ ! The type of Scheduling does not seem to affect the timing
    !$ ! significantly.  DYNAMIC may be slightly better.
    do j=1,ny
      !
      ! Proceed Row by Row
      l = j-iy+iybeam
      if (l.ge.1 .and. l.le.my) then
        !
        ! Along that row, subtract clean component if in beam
        do i = 1,nx
          k = i-ix+ixbeam
          if (k.ge.1 .and. k.le.mx) then
            if (np.le.1) then
              resid(i,j) = resid(i,j) - f*beam(k,l,1)
            else
              if (resid(i,j).ne.0) then
                do ip = 1,np
                  !
                  ! Beware of truncating the primary beam.
                  if (primary(ip,i,j).gt.wtrun) then
                    resid(i,j) = resid(i,j) -   &
     &                      f*beam(k,l,ip)*primary(ip,i,j)   &
     &                      *primary(ip,ix,iy)*weight(i,j)
                  endif
                enddo
              endif
            endif
          endif
        enddo
      endif
      !
      ! Find new maximum inside cleaning box in residual map for this row
      if ((j.ge.box(2)).and.(j.le.box(4))) then
        if (niter.lt.piter) then
          ! Force positive components
          do i = box(1), box(3)
            if (msk(i,j)) then
              if (vnew_it(ithread).lt.resid(i,j)) then
                vnew_it(ithread)=resid(i,j)
                imax_it(ithread)=i
                jmax_it(ithread)=j
              endif
            endif
          enddo
        else
          ! Do not force positivity
          do i = box(1), box(3)
            if (msk(i,j)) then
              if (abs(vnew_it(ithread)).lt.abs(resid(i,j))) then
                vnew_it(ithread)=resid(i,j)
                imax_it(ithread)=i
                jmax_it(ithread)=j
              endif
            endif
          enddo
        endif
      endif
      !
      ! Loop for next row
    enddo
    !$OMP END DO
    !$OMP END PARALLEL
    !
    ! Compute VNEW and Position for next iteration
    vnew = vnew_it(1) 
    it = 1
    do i=2,nthread
      if (abs(vnew).lt.abs(vnew_it(i))) then
        it = i
        vnew = vnew_it(i)
      endif
    enddo
    vnew = vnew_it(it)
    ix = imax_it(it)
    iy = jmax_it(it)
    !
    !!Print *,'Niter ',niter,' < ',miter,niter.lt.miter
    !!Print *,'Converge ',converge, ' > 0',(converge.gt.0)
    !!Print *,'Vnew = ',vnew,' > Borne = ',borne,abs(vnew).gt.borne
    !
    jcode = 0
    if (sic_ctrlc()) exit
    !
    if (niter.ge.miter) then
      jcode = 1
      exit
    endif
    if ((converge.gt.0).and.(conv.le.0)) then
      jcode = 2
      exit
    endif
    if (abs(vnew) .le. borne) then
      jcode = 3
      exit
    endif
  enddo
  !
  cflux = cum
  deallocate(vnew_it,imax_it,jmax_it,stat=ier)
  !
end subroutine old_hogbom_cycle90
!
subroutine old_major_cycle90 (rname,method,head,   &
     &    beam,beam_nx,beam_ny,nx,ny,clean,resid,tfbeam,fcomp,   &
     &    wcl,mcl,ixbeam,iybeam,ixpatch,iypatch,bgain,   &
     &    box, wfft, tcc, list, nl, np, primary, weight,       &
     &    major_plot, next_flux)
  use imager_interfaces, except_this=>old_major_cycle90
  use clean_def
  use image_def
  use gbl_message
  !----------------------------------------------------------------------
  ! @ private
  !_
  ! IMAGER
  !   Major cycle loop according to B.Clark idea
  !----------------------------------------------------------------------
  external :: major_plot                      ! Major cycle Display
  external :: next_flux                       ! Cumulative flux display
  !
  character(len=*), intent(in) :: rname       ! Calling command
  type (clean_par), intent(inout) :: method   ! Method parameters
  type (gildas), intent(in)  :: head          ! Data header
  !
  integer, intent(in) :: nx                   ! X size
  integer, intent(in) :: ny                   ! Y size
  integer, intent(in) :: beam_nx,beam_ny      ! Beam size
  integer, intent(in) :: np                   ! Number of pointings
  integer, intent(in) :: mcl                  ! Maximum number of clean components
  real, intent(inout) :: clean(nx,ny)         ! Clean map
  real, intent(inout) :: resid(nx,ny)         ! Residual map
  real, intent(in) ::    beam(beam_nx,beam_ny,np)       ! Dirty beams (per pointing)
  real, intent(in) ::    tfbeam(nx,ny,np)     ! T.F. du beam
  complex, intent(inout) :: fcomp(nx,ny)      ! T.F. du vecteur modification
  real, intent(in) :: bgain                   ! Maximum sidelobe level
  integer, intent(in) :: ixbeam, iybeam       ! Beam maximum position
  integer, intent(in) :: ixpatch, iypatch     ! Beam patch radius
  integer, intent(in) :: box(4)               ! Cleaning box
  real, intent(inout) :: wfft(*)              ! Work space for FFT
  type(cct_par), intent(inout) :: tcc(method%m_iter) ! Clean components array
  type(cct_par), intent(inout) :: wcl(mcl)    ! Work space for Clean components
  integer, intent(inout) :: list(nx*ny)       ! list of searchable pixels
  integer, intent(inout) :: nl   ! List size
  !
  real, intent(in) :: primary(np,nx,ny)       ! Primary beams
  real, intent(in) :: weight (nx,ny)          ! Flat field response
  !
  ! Local
  real    maxc,minc,maxabs     ! max and min of data, absolute max value
  real    lastabs              ! Check for oscillations
  integer imax,jmax,imin,jmin  ! coordinates of the Max and Min pixels
  real    borne                ! Fraction of initial data
  real    limite               ! Minimal intensity retained
  real    clarkl               ! Clark worry limit
  real flux                    ! Total clean flux density
  integer ncl                  ! Number of selected data points
  logical fini                 ! Stopping criterium 
  logical converge             ! Stop by flux convergence
  integer k, kcl
  character(len=message_length) :: chain
  !
  ! Find maximum residual
  call maxlst (resid,nx,ny,list,nl, maxc,imax,jmax,minc,imin,jmin)
  !
  if (method%n_iter.lt.method%p_iter) then
    maxabs=abs(maxc)
  elseif ( abs(maxc).lt.abs(minc) ) then
    maxabs=abs(minc)
  else
    maxabs=abs(maxc)
  endif
  borne= max(method%fres*maxabs,method%ares)
  fini = maxabs.lt.borne
  method%n_iter= 0
  flux = 0.0
  !
  ! Major cycle
  k = 0
  do while (.not.fini)
    !
    ! Define minor cycle limit
    k = k+1
    write(chain,100) 'Major cycle ',k,' loop gain ',method%gain
    call map_message(seve%i,rname,chain)
    limite = max(maxabs*bgain,0.8*borne)
    clarkl = maxabs*bgain
    !
    kcl = mcl
    !
    ! Select points of maximum strength and load them in
    call choice (            &
     &      resid,           & ! Current residuals
     &      nx,ny,           & ! image size
     &      list, nl,        & ! Search list
     &      limite,          & ! Detection threshold
     &      kcl,             & ! Maximum number of candidates
     &      wcl,             & ! CCT
     &      ncl,             & ! Selected Number of components
     &      maxabs, method%ngoal)
    !
    if (ncl.gt.0) then
      write(chain,100) 'Selected ',ncl,' points above ',limite
      call map_message(seve%i,rname,chain)
      !
      ! Make minor cycles
      call old_minor_cycle90 (method,   &
     &        wcl,            &  ! CCT
     &        ncl,            &  ! Number of candidates
     &        beam,beam_nx,beam_ny,     &  ! Dirty beams and Size
     &        nx,ny,          &  ! Image size
     &        ixbeam,iybeam,  &  ! Beam center
     &        ixpatch,iypatch,&  ! Beam patch
     &        clarkl,limite,  &
     &        converge,       &  !
     &        tcc,            &  ! Cumulated components
     &        np, primary, weight, method%trunca,   &
     &        flux,           &  ! Total Flux
     &        method%pflux, next_flux)
      !
      call compresswcl(wcl,ncl)
      !
      ! Remove all components by FT : RESID = RESID - BEAM # WCL(*,4)
      call remisajour (    &
     &        clean,       &    ! CLEAN map used as work space
     &        resid,       &    ! Updated residuals
     &        tfbeam,      &    ! Beam TF
     &        fcomp,       &    ! Work space for Component TF
     &        wcl,         &    ! CCT
     &        ncl,         &    ! Number of Clean Components
     &        nx,ny,       &    ! Map size
     &        wfft,        &    ! FFT work space
     &        np, primary, weight, method%trunca)
      write (chain,101)  'Cleaned ',flux,' Jy with ',method%n_iter,' clean components'
      call map_message(seve%i,rname,chain)
      !
      ! Find new extrema
      lastabs = maxabs
      call maxlst (resid,nx,ny,list,nl, maxc,imax,jmax,minc,imin,jmin)
      if (method%n_iter.lt.method%p_iter) then
        maxabs=abs(maxc)
      elseif ( abs(maxc).lt.abs(minc) ) then
        maxabs=abs(minc)
      else
        maxabs=abs(maxc)
      endif
      if (maxabs.gt.1.15*lastabs) then
        write(chain,'(a,1pg10.3,a,1pg10.3)') &
     &      'Detected beginning of oscillations',maxabs,' > ',lastabs
        call map_message(seve%w,rname,chain)
      endif
      !
      ! Check if converge
      fini = (maxabs.le.borne)   &
     &        .or. (method%m_iter.le.method%n_iter)   &
     &        .or. converge
    else
      ! No component found: finish...
      write(chain,101) 'No points selected above ',limite
      call map_message(seve%i,rname,chain)
      fini = .true.
    endif
    !
    ! Intermediate or final PLOT
    converge = fini
    call major_plot (method,head,              &
     &      converge,method%n_iter,nx,ny,np,   &
     &      tcc,clean,resid,weight)
    fini = converge
    !
    ! Limit number of major cycles...
    if (k.gt.method%n_major) fini = .true.
    !
    ! Get new list
!!    if (.not.fini) then
!!      !
!!      ! Get a new list if in QUERY mode
!!      ! Query mode does not exist for MRC
!!      if (method%qcycle) then
!!        ! For MRC, method is s_method, while
!!        ! head is the normal stuff... This would create a problem
!!        call get_newmask (method,head,nl,error)
!!        !
!!        ! Reset the List in its defined range.
!!        list(1:nl) = method%list(1:nl)
!!      endif
!!    endif
  enddo
  !
  ! End
  if (maxabs.le.borne) then
    call map_message(seve%i,rname,'Reached minimum flux density')
  elseif (method%m_iter.le.method%n_iter) then
    call map_message(seve%i,rname,'Reached maximum number of components')
  elseif (converge) then
    call map_message(seve%i,rname,'Reached minor cycle convergence')
  elseif (k.gt.method%n_major) then
    write(chain,'(I0)') method%n_major
    call map_message(seve%i,rname,'Reached maximum number of cycles '//chain)
  else
    call map_message(seve%i,rname,'End of transcendental causes')
  endif
  !
  100   format (a,i6,a,1pg10.3,a)
  101   format (a,1pg10.3,a,i7,a)
end subroutine old_major_cycle90
!
subroutine old_minor_cycle90 (method, wcl, ncl,           &
     &    beam,beam_nx,beam_ny,nx,ny,ixbeam,iybeam,ixpatch,iypatch,   &
     &    clarkmin,limite,converge,   &
     &    tcc, np, primary, weight, wtrun, cum, pflux, next_flux )
  use gkernel_interfaces
  use imager_interfaces, except_this=>old_minor_cycle90
  use clean_def
  !----------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER    Internal routine
  !   B.Clark minor cycles
  !   Deconvolve as in standard clean a list of NCL points
  !   selected in the map until the residuals is less than CLARKMIN
  !----------------------------------------------------------------------
  external :: next_flux                       ! Cumulative flux display
  type (clean_par), intent(inout) :: method   ! Method parameters
  integer, intent(in) :: np                   ! Number of fields in mosaic
  integer, intent(in) :: ncl                  ! Number of pixels selected
  integer, intent(in) :: beam_nx,beam_ny      ! Beam size
  integer, intent(in) :: nx,ny,ixbeam,iybeam  ! Size and cente pixel of beam
  integer, intent(in) :: ixpatch,iypatch      ! Used size of beam
  real, intent(in) :: beam(beam_nx,beam_ny,np)          ! Dirty beam
  type(cct_par), intent(inout) :: wcl(*)      ! Clean components
  real, intent(in) :: clarkmin                ! Stopping criterium for minor cycles
  real, intent(in) :: limite                  ! Clean Stopping criterium
  logical, intent(out) :: converge            ! Convergence indicator
  type(cct_par), intent(inout) :: tcc(:)      ! Effective clean components
  real, intent(in) :: primary(np,nx,ny)       ! Primary beams of mosaics
  real, intent(in) :: weight(nx,ny)           ! Effective weights on sky
  real, intent(in) :: wtrun                   ! Threshold of primary beam
  real, intent(inout) :: cum                  ! Cumulative flux
  logical, intent(in) :: pflux                ! Plot cumulative flux
  !
  ! Local
  real gain                    ! CLEAN gain 
  logical goon                 ! Continue after convergence
  integer kcl                  ! Current Clean component
  integer nomax, nomin         ! Clean component of Max and Min 
  real rmax, rmin, sign, cdif  ! current Max and Min 
  real worry, xfac             ! Conservative and speedup factor
  integer kiter
  integer :: dimcum            ! Flux convergence control
  real, allocatable :: oldcum(:)
  real f, bmax
  integer n,ier,i,jiter
  logical abor
  character(len=20) comm
  !
  dimcum = method%converge
  allocate(oldcum(max(1,dimcum)),stat=ier)
  if (ier.ne.0) then
    Print *,'Convergence array allocation error ',ier,dimcum
    return
  endif
  oldcum = cum
  !
  abor = .false.
  do i=1,ncl
    wcl(i)%value = 0.0
  enddo
  gain = method%gain
  !
  call maxcct (wcl,ncl,nomin,rmin,nomax,rmax)
  !
  ! Remember the sign if cumulative
  if (cum.gt.0) then
    sign = 1.0
  else if (cum.lt.0) then
    sign = -1.0
  else
    sign = 0.0
  endif
  !
  ! Identify the max, and set the sign if not already done
  if (method%n_iter.lt.method%p_iter) then
    kcl=nomax
    rmax=abs(rmax)
    sign = 1.0
  elseif (abs(rmin).gt.rmax) then
    kcl=nomin
    rmax=abs(rmin)
    if (sign.eq.0) sign = -1.0
  else
    kcl=nomax
    rmax=abs(rmax)
    if (sign.eq.0) sign = 1.0
  endif
  !
  converge = rmax.le.limite
  worry = 1.0
  xfac = (clarkmin/rmax)**method%spexp
  kiter = 0
  goon = (method%n_iter.lt.method%m_iter) .and. (.not.converge)
  bmax = beam(ixbeam,iybeam,1)
  !
  do while (goon)
    method%n_iter = method%n_iter + 1
    kiter = kiter + 1
    if (np.gt.1) then
      f = gain * wcl(kcl)%influx* weight(wcl(kcl)%ix,wcl(kcl)%iy)
    else
      f = gain / bmax * wcl(kcl)%influx
    endif
    !
    ! Store clean component list
    cum = cum+f
    if (pflux) call next_flux(method%n_iter,cum,0)
    !
    wcl(kcl)%value = wcl(kcl)%value + f
    tcc(method%n_iter)%value = f    ! Store as fractions of beam max
    tcc(method%n_iter)%ix = wcl(kcl)%ix
    tcc(method%n_iter)%iy = wcl(kcl)%iy
    tcc(method%n_iter)%size = 0.
    !
    ! Subtract from iterated values VCL
    call soustraire (wcl,ncl,           &
     &      beam,beam_nx,beam_ny,nx,ny,ixbeam,iybeam,   &
     &      ixpatch,iypatch,kcl,gain,   &
     &      np,primary,weight,wtrun)
    !
    ! Find maximum again
    call maxcct (wcl,ncl,nomin,rmin,nomax,rmax)
    if (method%n_iter.lt.method%p_iter) then
      kcl=nomax
      rmax=abs(rmax)
    elseif (abs(rmin).gt.rmax) then
      kcl=nomin
      rmax=abs(rmin)
    else
      kcl=nomax
      rmax=abs(rmax)
    endif
    !
    ! B.CLARK Magic confidence factor
    worry = worry+xfac/float(kiter)
    !
    ! Check convergence
    abor = sic_ctrlc()
    goon = (rmax.gt.worry*clarkmin) .and. (rmax.gt.limite)   &
     &      .and. (method%n_iter.lt.method%m_iter)
    goon = goon .and. .not.abor
    if (dimcum.ne.0) then
      jiter = kiter-1 ! Not method%n_iter
      oldcum(mod(jiter,dimcum)+1) = cum
      if (jiter.ge.dimcum) then
        cdif = cum-oldcum(mod(jiter+1,dimcum)+1)
        converge = sign*cdif.lt.0.0
        goon = goon .and. .not.converge
      endif
    endif
  enddo
  !
  if (abor) then
    comm = ' '
    call sic_wprn('I-CLARK,  Enter last valid component ',comm,n)
    if (n.eq.0) return
    n = len_trim(comm)
    if (n.eq.0) return
    read(comm(1:n),*,iostat=ier) method%n_iter
    converge = .true. ! It must be converged
  endif
end subroutine old_minor_cycle90
!

subroutine sub_major_lin(method,hdirty,hresid,hclean,   &
     &    hbeam,hprim,hmask,dcct,mask,list,error,        &
     &    major_plot, next_flux)
  use gkernel_interfaces
  use imager_interfaces, except_this=>sub_major_lin
  use clean_def
  use image_def
  use gbl_message
  !--------------------------------------------------------------
  ! @ private
  !
  ! IMAGER Clean/Mosaic
  !     Perfom a CLEAN based on all CLEAN algorithms,
  !     except the MRC (Multi Resolution CLEAN)
  !     which requires a different tool
  !     Works for mosaic also, except for the Multi Scale clean
  !     (not yet implemented for this one, but feasible...)
  !--------------------------------------------------------------
  external :: major_plot
  external :: next_flux
  !
  type (clean_par), intent(inout) :: method
  type (gildas), intent(in) :: hdirty
  type (gildas), intent(inout) :: hbeam
  type (gildas), intent(inout) :: hclean
  type (gildas), intent(inout) :: hresid
  type (gildas), intent(in) :: hprim
  type (gildas), intent(in) :: hmask
  real, intent(inout) :: dcct(:,:,:) ! (3,hclean%gil%dim(3),*)
  logical, intent(in), target :: mask(:,:)
  integer, intent(in), target :: list(:)
  logical, intent(inout) ::  error
  !
  real, pointer :: dirty(:,:)  ! Dirty map
  real, pointer :: resid(:,:)  ! Iterated residual
  real, pointer :: clean(:,:)  ! Clean Map
  real, pointer :: d3prim(:,:,:)   ! Primary beam (for one frequency)
  real, pointer :: d3beam(:,:,:)   ! Dirty beam (for one frequency)
  real, pointer :: atten(:,:)     ! Mosaic atten
  !
  real, allocatable :: tfbeam(:,:,:)
  real, allocatable :: w_fft(:)    ! TF work area
  complex, allocatable :: w_work(:,:)  ! Work area
  type(cct_par), allocatable :: w_comp(:)
  real, allocatable :: w_cct(:,:)
  logical, allocatable :: s_mask(:,:)
  real, allocatable :: s_beam(:,:,:), t_beam(:,:), s_resi(:,:)
  integer, allocatable :: mymask(:,:)
  integer :: f_iter, m_iter
  !
  real, target :: dummy_prim(1,1,1), dummy_atten(1,1)
  integer iplane
  integer nx,ny,np,nl,beam_nx,beam_ny,kx,ky,nc, icct
  integer ip, ier, ix, iy, i, jcode
  real fhat, limit, flux
  logical do_fft
  character(len=message_length) :: chain
  character(len=12) :: cname 
  integer :: nplane
  !
  type (cct_par), allocatable :: tcc(:)
  !
  integer, pointer :: llist(:)
  logical, pointer :: lmask(:,:)
  ! Multi Kernel 
  integer, parameter :: ms=3
  integer, parameter :: mk=11
  integer nker(ms)                   ! Kernel size
  real :: kernel(mk,mk,ms)           ! Smoothing kernels
  !
  call imager_tree('SUB_MAJOR_LIN in sub_major.f90')
  error = .false.
  do_fft = method%method.ne.'HOGBOM'
  cname = method%method
  !
  llist => list
  lmask => mask
  !
  ! Local variables
  nx = hclean%gil%dim(1)
  ny = hclean%gil%dim(2)
  beam_nx = hbeam%gil%dim(1)
  beam_ny = hbeam%gil%dim(2)
  nl = method%nlist
  nc = nx*ny
  np = max(1,hprim%gil%dim(1)) ! or ! np = hbeam%gil%dim(3)
  !
  if (do_fft) then
    ! This may differ betweeen CLARK (beam_nx ?) and others
    kx = nx
    ky = ny
    allocate(w_work(kx,ky),w_fft(2*max(kx,ky)),tfbeam(kx,ky,np),stat=ier)
    if (ier.ne.0) then
      call map_message(seve%e,cname,'Memory allocation error for TFBEAM')
      error = .true.
      return
    endif
  else
    ! W_FFT is used in Get_Beam for Mosaics
    allocate(w_work(1,1),w_fft(2*max(nx,ny)),tfbeam(1,1,1),stat=ier)  
    if (ier.ne.0) then
      call map_message(seve%e,cname,'FFT Memory allocation failure')
      error = .true.
      return
    endif
  endif
  !
  if (method%method.eq.'CLARK') then
    allocate(w_comp(nc), &
    & w_cct(1,1),mymask(1,1),s_mask(1,1),s_resi(1,1),t_beam(1,1), &
    & s_beam(1,1,3),stat=ier)
  elseif  (method%method.eq.'SDI') then
    allocate(w_comp(nc),w_cct(nx,ny),mymask(nx,ny), &
    & s_mask(1,1),s_resi(1,1),t_beam(1,1), &
    & s_beam(1,1,3),stat=ier)
  elseif  (method%method.eq.'MULTI') then
    allocate (s_mask(nx,ny),s_resi(nx,ny),t_beam(nx,ny), &
      & s_beam(beam_nx,beam_ny,3),w_cct(nx,ny),mymask(nx,ny), &
      & w_comp(1), stat=ier)
  else
    allocate(w_comp(1), &
    & w_cct(1,1),mymask(1,1),s_mask(1,1),s_resi(1,1),t_beam(1,1), &
    & s_beam(1,1,3),stat=ier)
  endif
  if (ier.ne.0) then
    call map_message(seve%e,cname,'Work Arrays Memory allocation failure')
    error = .true.
    return
  endif
  !
  ! Clean component work array
  allocate(tcc(method%m_iter),stat=ier)
  if (ier.ne.0) then
    call map_message(seve%e,cname,'Memory allocation error for TCC')
    error = .true.
    return
  endif
  !
  nplane = method%last-method%first+1
  !
  ! Global aliases
  if (method%mosaic) then
    d3prim => dummy_prim
  else
    d3prim => dummy_prim
    atten => dummy_atten
  endif
  !
  cname = method%method
  !
  ! Loop over Frequency planes
  do iplane = method%first, method%last
    !
    method%iplane = iplane
    call beam_plane(method,hbeam,hdirty)
    ! Get the new mask (if any...)
    call get_maskplane(method,hmask,hdirty,lmask,llist)    
    nl = method%nlist
    !
    ! Local aliases
    if (method%imask.ge.1) then
      write(chain,'(A,I6,I6,I6,A,I2)') 'Image, Beam & Mask planes ',   &
          &      method%iplane,method%ibeam,method%imask
    else
      write(chain,'(A,I6,I6,A,I2)') 'Image & Beam planes ',   &
          &      method%iplane,method%ibeam
    endif
    call map_message(seve%i,cname,chain)
    dirty => hdirty%r3d(:,:,iplane)
    resid => hresid%r3d(:,:,iplane)
    clean => hclean%r3d(:,:,iplane)
    d3beam => hbeam%r4d(:,:,:,method%ibeam)
    if (method%mosaic) d3prim => hprim%r4d(:,:,:,method%ibeam)
    !
    ! Initialize to Dirty map
    resid = dirty
    if (method%pcycle) call init_plot (method,hdirty,resid)
    !
    ! Prepare beam parameters - subroutine is not Thread safe though...
    call get_clean (method, hbeam, d3beam, error)
    if (error) then
      !return !Oops, cannot do that in a DO parallel...
      cycle
    endif
    call get_beam (method,hbeam,hresid,hprim,   &
        &        tfbeam,w_work,w_fft,fhat,error, lmask)
    ! Empty beam case
    if (error) then
      error = .false.
      clean = resid
      !return !Oops, cannot do that in a DO parallel...
      cycle
    endif
    !
    ! Mosaic case
    if (method%mosaic) then
      ! Reset search list as the mask may have been altered
      call lmask_to_list (lmask,nx*ny,llist,method%nlist)
      atten=> method%atten(:,:,method%ibeam)
      resid = resid * atten
    endif
    !
    !
    ! Performs decomposition into components
    select case (method%method)
    case('HOGBOM')
      call old_hogbom_cycle90 (cname,method%pflux,   &   ! Plot flux
           &        d3beam,beam_nx,beam_ny,   & ! Beam and size
           &        resid,nx,ny,   & ! Residual and size
           &        method%beam0(1),method%beam0(2),   & ! Beam center
           &        method%box, method%fres, method%ares,   &
           &        method%m_iter,  method%p_iter, method%n_iter,   &
           &        method%gain, method%converge,   &    !
           &        tcc,   &         ! Component Structure
           &        lmask,   & ! Search mask
           &        llist,   & ! Search list
           &        nl,   &          ! and its size
           &        np,   &          ! Number of fields
           &        d3prim,   &      ! Primary beams
           &        atten,   &       ! Weight
           &        method%trunca, flux, jcode, next_flux)
    case('CLARK')
      !
      ! Find components
      call old_major_cycle90 (cname,method,hclean,   &   !
           &        d3beam,   &       ! Dirty beams
           &        beam_nx,beam_ny,  &
           &        nx,ny,   &        ! Image sizes
           &        clean,   &        ! Final CLEAN image
           &        resid,   &        ! Residual
           &        tfbeam, w_work,   &  ! FT of dirty beam + Work area
           &        w_comp, nc,       &  ! Component storage + Size
           &        method%beam0(1),method%beam0(2),   & ! Beam center
           &        method%patch(1), method%patch(2), method%bgain,   &
           &        method%box,   &
           &        w_fft,   &       ! Work space for FFTs
           &        tcc,   &         ! Component table
           &        llist, nl,   &   ! Search list (truncated...)
           &        np,                & ! Number of fields
           &        d3prim,            & ! Primary beams
           &        atten,            & ! Weight
           &        major_plot,        & ! Plotting routine
           &        next_flux)
    case('SDI')
      !
      ! Find components
      call major_sdi90 (cname,method,hclean,   &
           &        clean,             & ! Final CLEAN image
           &        d3beam,            & !BUG  (:,:,method%ibeam),   & ! Dirty beams
           &        resid,nx,ny,       & ! Residual and size
           &        tfbeam, w_work,    & ! FT of dirty beam + Work area
           &        w_comp, nc,        & ! Component storage + Size
           &        method%beam0(1),method%beam0(2),   & ! Beam center
           &        method%patch(1), method%patch(2), method%bgain,   &
           &        method%box,   &
           &        w_fft,             & ! Work space for FFTs
           &        w_cct,             & ! Clean Component Image
           &        llist, nl,         & ! Search list (truncated...)
           &        np,                & ! Number of fields
           &        d3prim,            & ! Primary beams
           &        atten,             & ! Weight
           &        major_plot)          ! Plotting routine
    case('MULTI')
      !
      ! Performs decomposition into components
      call amaxmask (resid,lmask,nx,ny,ix,iy)
      limit = max(method%ares,method%fres*abs(resid(ix,iy)))
      call map_message(seve%i,method%method,chain)
      if (limit.eq.method%ares) then
        write (chain,'(A,1PG10.3,A)')  'Cleaning down to ',limit,' from ARES'
      else
        write (chain,'(A,1PG10.3,A,I7,I7)')  'Cleaning down to ',limit,' from FRES at ',ix,iy
      endif
      call map_message(seve%i,cname,chain)
      !
      clean = 0 ! Reset
        call old_major_multi90 (cname,method,hclean,   &
          &  d3beam,         &   ! hbeam%r4d(:,:,:,method%ibeam),                  &
          &  beam_nx,beam_ny, &  ! Dirty Beam size
          &  nx,ny,          &   ! Image sizes
          &  dirty,          &   ! hdirty%r3d(:,:,iplane),   &
          &  resid,          &   ! hresid%r3d(:,:,iplane),   &
          &  lmask,          &   ! Check definition of this mask...
          &  clean,          &   ! hclean%r3d(:,:,iplane),   &
          &  tcc(:),         &   ! Component Structure
          &  1,              &   ! Starting iteration
          &  method%m_iter,  &   ! Maximum number of components
          &  limit,          &   ! Residual
          &  method%n_iter,  &   ! Number of components
          &  s_mask,         &   ! Smoothed mask
          &  s_resi,         &   ! Smoothed residual,
          &  t_beam,         &   ! Translated beam
          &  w_work,         &   ! Complex work space
          &  s_beam,         &   ! Smoothed beams
          &  tfbeam,         &   ! Beam Fourier Transform (real)
          &  w_fft, icct,    & 
          &  nker, kernel,   &   ! Kernel sizes & values
          &  np,             &   ! Number of fields
          &  d3prim,         &   ! Primary beams
          &  atten)              ! Weight
      w_cct(:,:) = clean
    end select
    !
    ! Add clean components and residuals to produce clean map
    if (method%n_iter.ne.0) then
      call clean_make90 (method, hclean, clean, tcc)
      if (np.le.1) then
        clean = clean + resid
      else
        clean = clean + resid*atten
        where (atten.eq.0) clean = hclean%gil%bval ! Undefined pixel there
      endif
    else
      if (np.le.1) then
        clean = resid
      else
        clean = resid*atten
        where (atten.eq.0) clean = hclean%gil%bval ! Undefined pixel there
      endif
    endif
    !
    ! Put the TCC structure into its final place
    if (method%method.eq.'MULTI' .or. method%method.eq.'SDI') then
      if (method%method.eq.'MULTI') then
        m_iter = method%ninflate*method%m_iter
      else
        m_iter = method%m_iter
      endif
      where (w_cct.ne.0)
        mymask = 1
      elsewhere
        mymask = 0
      end where
      f_iter = sum(mymask)
      if (f_iter.gt.m_iter) then
        write(chain,'(A,I8,A,I8)') 'Iterations overflow ',f_iter, &
            &  ' > ',m_iter
        call map_message(seve%w,cname,chain)
        dcct(3,iplane,1) = 0
        chain = 'UV_RESTORE will not work, consider increasing CLEAN_INFLATE'
        call map_message(seve%i,cname,chain)
      else
        i = 0
        flux = 0
        do iy=1,ny
          do ix=1,nx
            if (w_cct(ix,iy).ne.0) then
              i = i+1
              dcct(1,iplane,i) = (dble(ix) -   &
               & hclean%gil%convert(1,1)) * hclean%gil%convert(3,1) + &
               & hclean%gil%convert(2,1)
              dcct(2,iplane,i) = (dble(iy) -   &
               & hclean%gil%convert(1,2)) * hclean%gil%convert(3,2) + &
               & hclean%gil%convert(2,2)
              dcct(3,iplane,i) = w_cct(ix,iy)
              flux = flux+w_cct(ix,iy)
            endif
          enddo
        enddo
        method%n_iter = i
        write (chain,'(A,1PG10.3,A,I6,A,A,I6,A,I2)')  'Cleaned ',flux,   &
            &        ' Jy with ',method%n_iter,' components ' &
            &       ,' Plane ',iplane
        call map_message(seve%i,cname,chain)
      endif
    else if (method%method.ne.'MRC') then
      do i=1,method%n_iter
        dcct(1,iplane,i) = (dble(tcc(i)%ix) -   &
            & hclean%gil%convert(1,1)) * hclean%gil%convert(3,1) + &
            & hclean%gil%convert(2,1)
        dcct(2,iplane,i) = (dble(tcc(i)%iy) -   &
            & hclean%gil%convert(1,2)) * hclean%gil%convert(3,2) + &
            & hclean%gil%convert(2,2)
        dcct(3,iplane,i) = tcc(i)%value
      enddo
      if (method%n_iter.lt.method%m_iter) then
        dcct(3,iplane,method%n_iter+1) = 0
      endif
      if (method%method.eq.'HOGBOM') then
        write (chain,'(A,1PG10.3,A,I6,A,A,I6,A,I2)')  'Cleaned ',flux,   &
          &        ' Jy with ',method%n_iter,' components ' &
          &       ,' Plane ',iplane
        call map_message(seve%i,cname,chain)
      endif
      !
    endif
  enddo
  !
  ! PHAT
  if (method%phat.ne.0) then
    fhat = 1.0/fhat
    if (method%mosaic) then
      d3beam = d3beam*fhat
      do ip=1,np
        d3beam(method%beam0(1),method%beam0(2),ip) =   &
            &          d3beam(method%beam0(1),method%beam0(2),ip) -   &
            &          method%phat
      enddo
    else
      d3beam = d3beam*fhat
    endif
  endif
  !
  ! Set the blanking value for Mosaics
  if (method%mosaic) then
    hclean%gil%eval = 0
  endif
  !
  ! Clean work space: in principle, Fortran 95 does it for you
  if (method%method.eq.'CLARK') then
    deallocate(w_comp,stat=ier)
  elseif  (method%method.eq.'SDI') then
    deallocate(w_comp,w_cct,mymask)
  elseif  (method%method.eq.'MULTI') then
    deallocate (s_mask,s_resi,t_beam,s_beam,w_cct,mymask)
  endif
  if (do_fft) then
    deallocate(w_work,w_fft)
  endif
  !
end subroutine sub_major_lin
!
