subroutine sic_directory(line,error)
  use sic_dependencies_interfaces
  use gildas_def
  use sic_types
  use sic_interfaces, except_this=>sic_directory
  use iso_c_binding
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  ! Support routine for command
  !   SIC\SIC FIND [Filter [Directory] [LOCAL|GLOBAL RootName]
  ! Define  RootName%NFILE and RootName%FILE variables, either LOCAL
  !   or GLOBAL. Default RootName is DIR. Default status is GLOBAL so far
  !-----------------------------------------------------------------------
  character(len=*), intent(in)    :: line   ! Command line
  logical,          intent(inout) :: error  ! Logical error flag
  !
  ! Local
  integer(kind=4) :: nc
  character(len=filename_length) :: filestring,tmpstring,dirstring
  integer(kind=address_length) :: addr
  type(sic_descriptor_t) :: desc
  type(c_ptr) :: cptr
  integer, pointer :: i1ptr(:)
  logical :: global, found
  integer :: ndir, narg, n, type, i, leng 
  character(len=8) :: ctype
  character(len=32) :: croot
  character(len=128) :: chain
  character(len=filename_length), allocatable :: tmp_file(:)
  integer :: tmp_nfile
  !
  narg = sic_narg(0)
  !
  filestring = '*.*'
  call sic_ch(line,0,2,filestring,nc,.false.,error)
  if (error) return
  !
  if (narg.le.3) then
    global = .true.     ! Change it to .false. if default status LOCAL preferred
    croot = 'DIR'
    n = 3
    ndir = 3
  else
    call sic_findwhich_key('SIC FIND',line,narg-1,global,error)
    if (error) return
    call sic_ke(line,0,narg,croot,n,.true.,error)
    ndir = narg-2
  endif
  !
  if (ndir.gt.2) then
    tmpstring = ' '
    call sic_ch(line,0,ndir,tmpstring,nc,.false.,error)
    if (error) return
    call sic_parse_file(tmpstring,'','',dirstring)  ! Translate Sic logicals and others
  else
    dirstring = ' '
  endif
  !
  ! Delete stuff if it exists
  if (sic_varexist(croot(1:n))) call sic_delvariable(croot(1:n),.false.,error)
  !
  call sic_defstructure(croot(1:n),global,error)
  type = fmt_i4
  call sic_defvariable (type,croot(1:n)//'%NFILE',global,error)
  !
  call gag_directory(dirstring,filestring,tmp_file,tmp_nfile,error)
  if (error) return
  !
  if (tmp_nfile.ne.0) then
    leng = 0
    do i=1,tmp_nfile
      leng = max(leng,len_trim(tmp_file(i)))
    enddo
    write(chain,'(A,I0,A)') croot(1:n)//'%FILE[',tmp_nfile,']'
    call sic_defvariable (leng,chain,global,error)
    !
    ! Copy tmp_ ... to the destination variables
    call sic_descriptor(croot(1:n)//'%NFILE',desc,found)
    call adtoad(desc%addr,cptr,1)
    call c_f_pointer(cptr,i1ptr,[1]) 
    i1ptr(1) = tmp_nfile
    !
    call sic_descriptor(croot(1:n)//'%FILE',desc,found)
    addr = desc%addr
    do i=1,tmp_nfile
      call ctodes(tmp_file(i),leng,addr) 
      addr = addr+leng
    enddo
    deallocate(tmp_file)
  endif
end subroutine sic_directory
!
subroutine sic_which(line,error)
  use sic_interfaces, except_this=>sic_which
  use sic_types
  use gildas_def
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  ! Support routine for command
  !   SIC\SIC WHICH  Procedure [LOCAL|GLOBAL OutVariable]
  ! Print or Saves the full name of a procedure or file (in case the
  ! filename contains a search path) into OutVariable
  !-----------------------------------------------------------------------
  character(len=*), intent(in) :: line  ! Full filename
  logical, intent(inout) :: error
  !
  character(len=*), parameter :: rname='SIC WHICH '
  character(len=filename_length) :: file
  character(len=varname_length) :: croot
  type(sic_descriptor_t) :: desc
  logical :: global
  logical :: found
  integer :: nc, nf, narg
  character(len=filename_length) :: fich
  !
  narg = sic_narg(0)
  call sic_ch(line,0,2,fich,nf,.true.,error)
  if (error) return
  call find_procedure(fich,file,found)
  if (.not.found) then
    call sic_message(seve%w,rname,'No such procedure '//fich(1:nf))
    return
  endif
  !
  nf = len_trim(file)
  if (narg.le.2) then
    call sic_message(seve%r,rname,file(1:nf))
    return
  endif
  !
  call sic_findwhich_key('SIC WHICH',line,3,global,error)
  call sic_ke(line,0,4,croot,nc,.true.,error)
  if (error) return
  !
  call sic_delvariable(croot,.false.,error)
  !
  ! Re-Create the variable 
  call sic_defvariable (nf,croot,global,error)
  if (error) return
  !
  ! Copy local to variable
  call sic_descriptor(croot(1:nc),desc,found)
  call ctodes(file,nf,desc%addr) 
end subroutine sic_which
!
subroutine sic_findwhich_key(rname,line,iarg,global,error)
  use gbl_message
  use sic_interfaces, only : sic_ke, sic_message
  !--------------------------------------------------------
  !  @ private
  !     Support for SIC FIND and SIC WHICH 
  ! Parse the LOCAL or GLOBAL keyword
  !--------------------------------------------------------
  character(len=*), intent(in) :: rname
  character(len=*), intent(in) :: line
  integer, intent(in) :: iarg
  logical, intent(out) :: global
  logical, intent(inout) :: error
  !
  character(len=8) :: clocal ='LOCAL   '
  character(len=8) :: cglobal='GLOBAL  '
  character(len=16) :: ctype
  integer :: nc
  !
  global = .false.
  !
  call sic_ke(line,0,iarg,ctype,nc,.true.,error)
  if (error) return
  if (nc.le.6) then
    if (ctype(1:nc).eq.clocal(1:nc)) then
      global = .false.
      return
    else if (ctype(1:nc).eq.cglobal(1:nc)) then
      global = .true.
      return
    endif
  endif
  call sic_message(seve%e,rname,'Invalid keyword '//ctype(1:nc))
  error = .true.
end subroutine
