subroutine compress(nx,ny,large,wl,mx,my,small,ws,wfft)
  use gkernel_interfaces, only : fourt
  !----------------------------------------------------------------------
  !	@ public
  ! 
  ! IMAGER -- Utility routine
  !
  !   Compress an image through TF truncation
  !!
  !----------------------------------------------------------------------
  integer, intent(in) :: nx,ny         !! Large image size
  integer, intent(in) :: mx,my         !! Small image size
  real, intent(in) :: large(nx,ny)     !! Large image
  complex, intent(inout) :: wl(nx,ny)  !! Workspace for large FT
  real, intent(out) :: small(mx,my)    !! Small image
  complex, intent(inout) :: ws(mx,my)  !! Workspace for small FT
  real, intent(inout) :: wfft(*)       !! FFT workspace
  !
  ! Local ---
  integer :: j,ndim,dim(2)
  real :: fact
  !
  wl(:,:) = cmplx(large,0.0)
  !
  ndim = 2
  dim(1) = nx
  dim(2) = ny
  call fourt(wl,dim,ndim,-1,0,wfft)
  !
  ! Keep inner quarter
  do j=1,my/2
    ws(1:mx/2,j) = wl(1:mx/2,j)   
    ws(mx/2+1:mx,j) = wl(nx-mx/2+1:nx,j) 
  enddo
  do j=my/2+1,my
    ws(1:mx/2,j) = wl(1:mx/2,j+ny-my) 
    ws(mx/2+1:mx,j) = wl(nx-mx/2+1:nx,j+ny-my) 
  enddo
  dim(1) = mx
  dim(2) = my
  call fourt (ws,dim,ndim,1,1,wfft)
  fact = 1.0/(nx*ny)
  small(:,:) = fact*real(ws)
end subroutine compress
!
subroutine expand (nx,ny,large,wl,mx,my,small,ws,wfft)
  use gkernel_interfaces, only : fourt
  !----------------------------------------------------------------------
  ! @ public
  !*
  !   IMAGER -- Utility routine
  !
  !	  Expand an image through TF zero extension
  !!
  !----------------------------------------------------------------------
  integer, intent(in) :: nx,ny        !! Large image size
  integer, intent(in) :: mx,my        !! Small image size
  real, intent(out) :: large(nx,ny)   !! Large image
  complex, intent(inout) :: wl(nx,ny) !! Workspace for large FT
  real, intent(in) :: small(mx,my)    !! Small image
  complex, intent(inout) :: ws(mx,my) !! Workspace for small FT
  real, intent(inout) :: wfft(*)      !! FFT workspace
  !
  ! Local ---
  integer :: j,ndim,dim(2)
  real :: fact
  !
  ! Code ----
  ws = cmplx(small,0.0)
  !
  ndim = 2
  dim(1) = mx
  dim(2) = my
  call fourt(ws,dim,ndim,-1,0,wfft)
  !
  ! Clear output FT
  wl = 0.0
  ! Load inner quarter
  do j=1,my/2
    wl(1:mx/2,j) = ws(1:mx/2,j) 
    wl(nx-mx/2+1:nx,j) = ws(mx/2+1:mx,j) 
  enddo
  do j=my/2+1,my
    wl(1:mx/2,j+ny-my) = ws(1:mx/2,j)          
    wl(nx-mx/2+1:nx,j+ny-my) = ws(mx/2+1:mx,j) 
  enddo
  dim(1) = nx
  dim(2) = ny
  call fourt (wl,dim,ndim,1,1,wfft)
  fact = 1.0/(mx*my)
  large(:,:) = fact*real(wl)
end subroutine expand
