import birdbath.*;
import condor.*;
import java.rmi.*;

import birdbath.Transaction;

public class SubmitRemoveTest2
extends AbstractScheddTestCase
{
    // Transaction submits then removes job
    protected void runTest()
    throws Throwable
    {
        Transaction transaction1 = schedd.createTransaction();
        transaction1.begin(10);
        int cluster = transaction1.createCluster();
        int job = transaction1.createJob(cluster);
        transaction1.submit(cluster,
                            job,
                            "matt",
                            UniverseType.VANILLA,
                            "/bin/true",
                            null,
                            "FALSE",
                            null,
                            null);
        transaction1.closeSpool(cluster, job);
        transaction1.removeJob(cluster, job, "I can");
        transaction1.commit();

        try
        {
            schedd.getJobAd(cluster, job);
            fail("Remove didn't work");
        }
        catch (RemoteException exception)
        {
            // Good, there was no job
        }
    }

    private static void check(Status status, String message)
    {
        assertTrue(message, status.getCode().equals(StatusCode.SUCCESS));
    }
}

