import condor.*;

import java.io.*;
import java.net.URL;
import java.util.*;

public class MultipleTransactionSubmitTest1
extends AbstractScheddTestCase
{
    // Transaction 1 and 2 happen serially
    protected void runTest()
    throws Throwable
    {
        CondorScheddPortType scheddPort = schedd.getPort();

        TransactionAndStatus transaction1AndStatus = scheddPort.beginTransaction(10);
        check(transaction1AndStatus.getStatus(), "1: BeginTransaction failed");
        //System.out.println("1: Created a 10 second transaction.");
        Transaction transaction1 = transaction1AndStatus.getTransaction();

        IntAndStatus cluster1AndStatus = scheddPort.newCluster(transaction1);
        check(cluster1AndStatus.getStatus(), "1: NewCluster failed");
        int cluster1 = cluster1AndStatus.getInteger().intValue();
        //System.out.println("1: New cluster is: " + cluster1);

        IntAndStatus job1AndStatus = scheddPort.newJob(transaction1, cluster1);
        check(job1AndStatus.getStatus(), "1: NewJob failed");
        int job1 = job1AndStatus.getInteger().intValue();
        //System.out.println("1: New job is: " + job1);

        Status commit1 = scheddPort.commitTransaction(transaction1);
        check(commit1, "1: Commit failed");
        //System.out.println("1: Transaction committed.");

        TransactionAndStatus transaction2AndStatus = scheddPort.beginTransaction(10);
        check(transaction2AndStatus.getStatus(), "2: BeginTransaction failed");
        //System.out.println("2: Created a 10 second transaction.");
        Transaction transaction2 = transaction2AndStatus.getTransaction();

        IntAndStatus cluster2AndStatus = scheddPort.newCluster(transaction2);
        check(cluster2AndStatus.getStatus(), "2: NewCluster failed");
        int cluster2 = cluster2AndStatus.getInteger().intValue();
        //System.out.println("2: New cluster is: " + cluster2);

        IntAndStatus job2AndStatus = scheddPort.newJob(transaction2, cluster2);
        check(job2AndStatus.getStatus(), "2: NewJob failed");
        int job2 = job2AndStatus.getInteger().intValue();
        //System.out.println("2: New job is: " + job2);

        Status commit2 = scheddPort.commitTransaction(transaction2);
        check(commit2, "2: Commit failed");
        //System.out.println("2: Transaction committed.");
    }

    private static void check(Status status, String message)
    {
        assertTrue(message, status.getCode().equals(StatusCode.SUCCESS));
    }
}

