import birdbath.Transaction;
import condor.UniverseType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public abstract class AbstractScheddSpoolFileTestCase
	extends AbstractScheddTestCase
{
	private File sendTestFile;
	private File receiveTestFile;

	public static void compareFiles(File file1, File file2)
		throws Exception
	{
		//System.out.println("comparing: " + file1.getName() + " to " + file2.getName());

		FileInputStream file1InputStream = new FileInputStream(file1);
		FileInputStream file2InputStream = new FileInputStream(file2);

		/*
		 byte[] file1Input = new byte[1024];
		 int file1InputLength;
		 byte[] file2Input = new byte[1024];
		 int file2InputLength;
		 do
		 {
		 file1InputLength = file1InputStream.read(file1Input);
		 file2InputLength = file2InputStream.read(file2Input);

		 while (file1InputLength < file2InputLength &&
		 -1 != file1InputLength)
		 {
		 file1InputLength +=
		 file1InputStream.read(file1Input,
		 file1InputLength,
		 file2InputLength - file1InputLength);
		 }

		 while (file2InputLength < file1InputLength &&
		 -1 != file2InputLength)
		 {
		 file2InputLength +=
		 file2InputStream.read(file2Input,
		 file2InputLength,
		 file1InputLength - file2InputLength);
		 }

		 assertEquals(file1InputLength, file2InputLength);

		 for (int i = 0; i < file1InputLength && i < file2InputLength; i++)
		 {
		 assertEquals(file1Input[i], file2Input[i]);
		 }
		 }
		 while (-1 != file1InputLength || -1 != file2InputLength);
		 */

		BufferedInputStream file1BufferedInputStream =
			new BufferedInputStream(file1InputStream);
		BufferedInputStream file2BufferedInputStream =
			new BufferedInputStream(file2InputStream);

		int file1Input;
		int file2Input;
		do
		{
			file1Input = file1BufferedInputStream.read();
			file2Input = file2BufferedInputStream.read();

			assertEquals(file1Input, file2Input);
		}
		while (-1 != file1Input || -1 != file2Input);

		file1InputStream.close();
		file2InputStream.close();
	}

	protected abstract void generate(FileOutputStream testFileOutput)
		throws Exception;

	protected void setUp()
		throws Exception
	{
		super.setUp();

		receiveTestFile = File.createTempFile("Schedd", "ReceiveTestFile");
		sendTestFile = File.createTempFile("Schedd", "SendTestFile");

		FileOutputStream sendTestFileOutput = new FileOutputStream(sendTestFile);
		generate(sendTestFileOutput);
		sendTestFileOutput.close();
	}

	protected void tearDown()
		throws Exception
	{
		super.tearDown();

		assertTrue(receiveTestFile.delete());
		assertTrue(sendTestFile.delete());
	}

	protected void runTest()
		throws Throwable
	{
		File[] files = {sendTestFile};

		Transaction transaction = schedd.createTransaction();
		transaction.begin(10 * 60);

		try
		{
			int cluster = transaction.createCluster();
			int job = transaction.createJob(cluster);

			transaction.submit(cluster,
							   job,
							   null,
							   UniverseType.VANILLA,
							   "/bin/true",
							   null,
							   "FALSE",
							   null,
							   files);

			transaction.getFile(cluster,
								job,
								sendTestFile.getName(),
									(int) sendTestFile.length(),
								receiveTestFile);

			transaction.closeSpool(cluster, job);
			transaction.removeJob(cluster, job, "'cuz");
		}
		finally
		{
			transaction.commit();
		}

		compareFiles(sendTestFile, receiveTestFile);
	}
}
