#!/bin/sh

# generate.sh -- this script takes no arguments, 
# and generates a tarball of gsi certificates
# keys and proxies that can be used to run the condor gsi tests in the
# test suite.  It generates certs good for 10 years, but might occasionally
# need to be re-run when openssl or gsi decides that the encryption
# algorithms are deprecated, or if we need to test with different
# key lengths or algorithms.

# It needs to run run on a machine with openssl and grid-proxy-init installed
# I used osg-ss-submit, but any machine with the osg software stack will
# be fine.

# It will prompt y/n to create certs occassionaly, just take the default y
# I couldn't figure out how to tell openssl not to prompt in those cases.

# create password
dd if=/dev/urandom of=/dev/stdout bs=8 count=1 2>/dev/null | md5sum | awk '{print $1}' > password

# Generate Root CA key
echo generate root ca
openssl genrsa -des3 -out root-ca.key -passout file:password 1024

# Sign the key with itself
openssl req -new -x509 -days 3650 -key root-ca.key -out root-ca.crt -config openssl.cnf -subj '/C=US/ST=Wisconsin/L=Madison/O=UWCS/CN=CA/' -passin file:password

# Move 'em down
perl mk_new_ca_dir.pl CondorSigningCA1
mv root-ca.crt CondorSigningCA1/signing-ca-1.crt
mv root-ca.key CondorSigningCA1/signing-ca-1.key

# Make a host cert
openssl req -newkey rsa:1024 -keyout host.key -nodes -config openssl.cnf -out host.req  -subj '/C=US/ST=Wisconsin/L=Madison/O=UWCS/CN=BT/emailAddress=bt@cs.wisc.edu' -passin file:password

# Make host key from cert
openssl ca -passin file:password -config openssl.cnf -out host.crt -infiles host.req

#  grid-proxy-init insists on these permissions
chmod 0600 host.key host.crt

# make a host proxy cert good for 10 years minus 1 hour
grid-proxy-init -valid 87599:0 -cert host.crt -key host.key -out hostproxycert

rm password

# Now make directory structure the condor tests want

mkdir gsi_keys
mkdir gsi_keys/mapfiles

echo '"/C=US/ST=Wisconsin/L=Madison/O=UWCS/CN=BT/emailAddress=bt@cs.wisc.edu" USERNAME
' > gsi_keys/mapfiles/grid-mapfile

mkdir gsi_keys/certificates
mv host.key gsi_keys/hostkey.pem
mv host.crt gsi_keys/hostcert.pem
mv hostproxycert gsi_keys/hostproxycert

hash=`openssl x509 -noout -subject_hash -in CondorSigningCA1/signing-ca-1.crt`
cp CondorSigningCA1/signing-ca-1.crt gsi_keys/certificates/${hash}.0

cat > gsi_keys/certificates/${hash}.signing_policy <<EOF
# Format:
#------------------------------------------------------------------------
#  token type  | def.authority |                value              
#--------------|---------------|-----------------------------------------
# EACL entry #1|

access_id_CA      X509         '/C=US/ST=Wisconsin/L=Madison/O=UWCS/CN=CA'
pos_rights        globus        CA:sign
cond_subjects     globus       '"/C=US/ST=Wisconsin/L=Madison/O=UWCS/*"'
# end of EACL
EOF

# Some of our batlab machines (Macs) have older ssl that use md5 here, not sha1
oldhash=`openssl x509 -noout -subject_hash_old -in CondorSigningCA1/signing-ca-1.crt`
cp gsi_keys/certificates/${hash}.signing_policy gsi_keys/certificates/${oldhash}.signing_policy
cp gsi_keys/certificates/${hash}.0 gsi_keys/certificates/${oldhash}.0
# for posterity
cp -p generate.sh gsi_keys/
cp -p openssl.cnf gsi_keys/
cp -p mk_new_ca_dir.pl gsi_keys/

tar cvzf x_lib_auth-gsi_keys.tgz gsi_keys

rm -fr CondorSigningCA1 gsi_keys host.req
