/*
 * Author: Matthew Farrellee <matt@cs.wisc.edu>
 */

package birdbath;

import condor.ClassAdStructAttr;
import condor.Status;
import condor.StatusCode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

class Utilities
{
	static boolean isSuccess(Status status)
	{
		return StatusCode.SUCCESS.equals(status.getCode());
	}

	static void checkAndThrowRemoteException(Status status)
	throws RemoteException
	{
		if (!isSuccess(status))
		{
			//System.out.println("Status: " + status.getCode().getValue() + " Message: " + status.getMessage());
			throw new RemoteException(status.getMessage());
		}
	}

	static ClassAdStructAttr[] setAttribute(ClassAdStructAttr newAttribute,
											ClassAdStructAttr[] ad)
	{
		/* NOTES:
		 *  - This code is faster for setting attributes that already exist.
		 *  - This code does not make deep copies of attributes, so be careful!
		 */

		for (int index = 0; index < ad.length; index++)
		{
			ClassAdStructAttr attribute = ad[index];
			if (null != newAttribute.getName() &&
				null != attribute.getName())
			{
				if (0 == newAttribute.getName().compareToIgnoreCase(attribute.getName()))
				{
					attribute.setType(newAttribute.getType());
					attribute.setValue(newAttribute.getValue());

					return ad;
				}
			}
		}

		List attributes = new ArrayList(ad.length + 1);
		attributes.add(newAttribute);
		for (int index = 0; index < ad.length; index++)
		{
			attributes.add(ad[index]);
		}

		return (ClassAdStructAttr[]) attributes.toArray(new ClassAdStructAttr[0]);
	}

	static ClassAdStructAttr[] setAttributes(ClassAdStructAttr[] newAttributes,
											 ClassAdStructAttr[] ad)
	{
		for (int index = 0; index < newAttributes.length; index++)
		{
			ad = setAttribute(newAttributes[index], ad);
		}

		return ad;
	}
}

