import birdbath.*;
import condor.*;
import java.net.*;
import java.rmi.*;

import birdbath.Transaction;

public class ToddDestroyProcLookupClassAdTest
{
    public static void main(String[] args)
    throws Exception
    {
        Schedd schedd = new Schedd(new URL(args[0]));

        Transaction transaction1 = schedd.createTransaction();
        transaction1.begin(10);
        int cluster = transaction1.createCluster();
        int job = transaction1.createJob(cluster);
        transaction1.submit(cluster,
                            job,
                            "matt",
                            UniverseType.VANILLA,
                            "/bin/true",
                            null,
                            "FALSE",
                            null,
                            null);
        transaction1.closeSpool(cluster, job);
        transaction1.removeJob(cluster, job, "I can");
        transaction1.commit();

        try
        {
            schedd.getJobAd(cluster, job);

            System.out.println("FAILURE: Job is still in the queue!");
        }
        catch (RemoteException exception)
        {
            // Good, there was no job
        }
    }
}
