// -*- C++ -*-

/*

  Heap Layers: An Extensible Memory Allocation Infrastructure
  
  Copyright (C) 2000-2003 by Emery Berger
  http://www.cs.umass.edu/~emery
  emery@cs.umass.edu
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/*

  StaticHeap: manage a fixed range of memory.

*/

#ifndef _STATICHEAP_H_
#define _STATICHEAP_H_

namespace HL {

template <int MemorySize>
class StaticHeap {
public:

  StaticHeap (void)
    : ptr (&buf[0]),
    remaining (MemorySize)
  {}

  enum { Alignment = 1 };

  inline void * malloc (size_t sz) {
    if (remaining < sz) {
      return NULL;
    }
    void * p = ptr;
    ptr += sz;
    remaining -= sz;
    return p;
  }

  void free (void *) {}
  int remove (void *) { return 0; }

  int isValid (void * ptr) {
    return (((size_t) ptr >= (size_t) buf) &&
	    ((size_t) ptr < (size_t) buf));
  }

private:

  // Disable copying and assignment.
  StaticHeap (const StaticHeap& treap);
  StaticHeap& operator= (const StaticHeap& treap);

  char buf[MemorySize];
  char * ptr;
  size_t remaining;
};

};

#endif
